/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;

class Mask {
    static final int bitdepth = 8;

    Mask() {
    }

    static int GetMaskValue(int[] mask, int maskPos, int[] mask_next_row, int mask_next_rowPos, int x, int subsampling_x, int subsampling_y) {
        if ((subsampling_x | subsampling_y) == 0) {
            return mask[x];
        }
        if (subsampling_x == 1 && subsampling_y == 0) {
            return D.RightShiftWithRounding(mask[maskPos + x * 2] + mask[maskPos + x * 2 + 1], 1);
        }
        return D.RightShiftWithRounding(mask[maskPos + x * 2] + mask[maskPos + x * 2 + 1] + mask_next_row[mask_next_rowPos + x * 2] + mask_next_row[mask_next_rowPos + x * 2 + 1], 2);
    }

    static void MaskBlend(int[] pred0, int pred0Pos, int[] pred1, int pred1Pos, int prediction_stride_1, int[] mask, int maskPos, int mask_stride, int width, int height, int[] dst, int dstPos, int dst_stride, boolean is_inter_intra, int subsampling_x, int subsampling_y) {
        int step_y = subsampling_y != 0 ? 2 : 1;
        int[] mask_next_row = mask;
        int mask_next_rowPos = maskPos + mask_stride;
        int inter_post_round_bits = 4;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int mask_value = Mask.GetMaskValue(mask, maskPos, mask_next_row, mask_next_rowPos, x, subsampling_x, subsampling_y);
                if (is_inter_intra) {
                    dst[dstPos + x] = D.RightShiftWithRounding(mask_value * pred1[pred1Pos + x] + (64 - mask_value) * pred0[pred0Pos + x], 6);
                    continue;
                }
                int res = mask_value * pred0[pred0Pos + x] + (64 - mask_value) * pred1[pred1Pos + x] >> 6;
                dst[dstPos + x] = D.Clip3(D.RightShiftWithRounding(res += 0, 4), 0, 255);
            }
            dstPos += dst_stride;
            maskPos += mask_stride * step_y;
            mask_next_rowPos += mask_stride * step_y;
            pred0Pos += width;
            pred1Pos += prediction_stride_1;
        }
    }

    static void InterIntraMaskBlend8bpp(int[] pred0, int pred0Pos, int[] pred1, int pred1Pos, int prediction_stride_1, int[] mask, int maskPos, int mask_stride, int width, int height, int subsampling_x, int subsampling_y) {
        int step_y = subsampling_y != 0 ? 2 : 1;
        int[] mask_next_row = mask;
        int mask_next_rowPos = maskPos + mask_stride;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int mask_value = Mask.GetMaskValue(mask, maskPos, mask_next_row, mask_next_rowPos, x, subsampling_x, subsampling_y);
                pred1[pred1Pos + x] = D.RightShiftWithRounding(mask_value * pred1[pred1Pos + x] + (64 - mask_value) * pred0[pred0Pos + x], 6);
            }
            maskPos += mask_stride * step_y;
            mask_next_rowPos += mask_stride * step_y;
            pred0Pos += width;
            pred1Pos += prediction_stride_1;
        }
    }
}

