/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;
import org.jpedal.utils.LogWriter;

class Entropy {
    byte[] data_;
    int byteP = 0;
    int data_end_;
    boolean allow_update_cdf_;
    int bits_;
    long values_in_range_;
    long window_diff_;
    static final int kReadBitMask = -256;
    static final int kCdfPrecision = 6;
    static final int kMinimumProbabilityPerSymbol = 4;
    static final int kWindowSize = 32;

    Entropy(byte[] data, int offset, int size, boolean allow_update_cdf) {
        LogWriter.writeLog("Total Data Length: " + data.length + " Offset: " + offset + " Size: " + size);
        this.data_ = data;
        this.data_end_ = Math.min(offset + size, data.length);
        this.allow_update_cdf_ = allow_update_cdf;
        this.byteP = offset;
        int data_memcpy_end_ = size >= 4 ? offset + size - 4 + 1 : offset;
        this.values_in_range_ = 32768L;
        this.window_diff_ = 0L;
        this.bits_ = -15;
        this.PopulateBits();
    }

    static int ScaleCdf(int values_in_range_shifted, int[] cdf, int index, int symbol_count) {
        return (values_in_range_shifted * (cdf[index] >> 6) >> 1) + 4 * (symbol_count - index);
    }

    static void UpdateCdf(int[] cdf, int symbol_count, int symbol) {
        int count = cdf[symbol_count];
        int rate = (count >> 4) + 4 + (symbol_count > 3 ? 1 : 0);
        int i = 0;
        do {
            if (i < symbol) {
                int n = i;
                cdf[n] = cdf[n] + (32768 - cdf[i] >> rate);
                continue;
            }
            int n = i;
            cdf[n] = cdf[n] - (cdf[i] >> rate);
        } while (++i < symbol_count - 1);
        int n = symbol_count;
        cdf[n] = cdf[n] + (count < 32 ? 1 : 0);
    }

    int ReadBit() {
        long curr = ((this.values_in_range_ & 0xFFFFFFFFFFFFFF00L) >> 1) + 4L;
        int symbol_value = (int)(this.window_diff_ >> this.bits_ & 0xFFFFL);
        int bit = 1;
        if ((long)symbol_value >= curr) {
            this.values_in_range_ -= curr;
            this.window_diff_ -= curr << this.bits_;
            bit = 0;
        } else {
            this.values_in_range_ = curr;
        }
        this.NormalizeRange();
        return bit;
    }

    long ReadLiteral(int num_bits) {
        long literal = 0L;
        int bit = num_bits - 1;
        do {
            literal <<= 1;
            literal |= (long)this.ReadBit();
        } while (--bit >= 0);
        return literal;
    }

    int ReadSymbol(int[] cdf, int symbol_count) {
        int symbol = this.ReadSymbolImpl(cdf, symbol_count);
        if (this.allow_update_cdf_) {
            Entropy.UpdateCdf(cdf, symbol_count, symbol);
        }
        return symbol;
    }

    boolean ReadSymbol(int[] cdf) {
        boolean symbol;
        boolean bl = symbol = this.ReadSymbolImpl(cdf[0]) != 0;
        if (this.allow_update_cdf_) {
            int count = cdf[2] & 0xFFFF;
            int rate = 4 | count >> 4;
            cdf[0] = symbol ? cdf[0] + (32768 - cdf[0] >> rate) : cdf[0] - (cdf[0] >> rate);
            cdf[2] = cdf[2] + (count < 32 ? 1 : 0);
        }
        return symbol;
    }

    boolean ReadSymbolWithoutCdfUpdate(int cdf) {
        return this.ReadSymbolImpl(cdf) != 0;
    }

    private int ReadSymbolImpl(int cdf) {
        int symbol;
        int symbol_value = (int)(this.window_diff_ >> this.bits_ & 0xFFFFL);
        long curr = ((this.values_in_range_ >> 8) * (long)(cdf >> 6) >> 1) + 4L;
        int n = symbol = (long)symbol_value < curr ? 1 : 0;
        if (symbol == 1) {
            this.values_in_range_ = curr;
        } else {
            this.values_in_range_ -= curr;
            this.window_diff_ -= curr << this.bits_;
        }
        this.NormalizeRange();
        return symbol;
    }

    int ReadSymbolImpl(int[] cdf, int symbol_count) {
        long prev;
        long curr = this.values_in_range_;
        int symbol = -1;
        int symbol_value = (int)(this.window_diff_ >> this.bits_ & 0xFFFFL);
        int delta = 4 * --symbol_count;
        do {
            prev = curr;
            curr = ((this.values_in_range_ >> 8) * (long)(cdf[++symbol] >> 6) >> 1) + (long)delta;
            delta -= 4;
        } while ((long)symbol_value < curr);
        this.values_in_range_ = prev - curr;
        this.window_diff_ -= curr << this.bits_;
        this.NormalizeRange();
        return symbol;
    }

    int ReadSymbolImplBinarySearch(int[] cdf, int symbol_count) {
        int symbol_value = (int)(this.window_diff_ >> this.bits_ & 0xFFFFL);
        int low = 0;
        int high = --symbol_count - 1;
        long prev = this.values_in_range_;
        int curr = 0;
        int values_in_range_shifted = (int)(this.values_in_range_ >> 8);
        do {
            int mid;
            int scaled_cdf;
            if (symbol_value < (scaled_cdf = Entropy.ScaleCdf(values_in_range_shifted, cdf, mid = (low + high) / 2, symbol_count))) {
                low = mid + 1;
                prev = scaled_cdf;
                continue;
            }
            high = mid - 1;
            curr = scaled_cdf;
        } while (low <= high);
        this.values_in_range_ = prev - (long)curr;
        this.window_diff_ -= (long)(curr << this.bits_);
        this.NormalizeRange();
        return low;
    }

    void NormalizeRange() {
        int bits_used = (int)(0xFL ^ D.FloorLog2(this.values_in_range_));
        this.bits_ -= bits_used;
        this.values_in_range_ <<= bits_used;
        if (this.bits_ < 0) {
            this.PopulateBits();
        }
    }

    void PopulateBits() {
        int kMaxCachedBits = 16;
        for (int count = 23 - (this.bits_ + 15); count >= 0 && this.byteP < this.data_end_; count -= 8) {
            int value = ~(this.data_[this.byteP++] & 0xFF);
            this.window_diff_ = (long)(value &= 0xFF) | this.window_diff_ << 8;
            this.bits_ += 8;
        }
        if (this.byteP == this.data_end_) {
            this.window_diff_ = (this.window_diff_ + 1L << kMaxCachedBits - this.bits_) - 1L;
            this.bits_ = kMaxCachedBits;
        }
    }

    static int InverseRecenter(int r, int v) {
        if (v > r << 1) {
            return v;
        }
        if ((v & 1) != 0) {
            return r - (v + 1 >> 1);
        }
        return r + (v >> 1);
    }

    int DecodeUniform(int max) {
        int l = D.FloorLog2(max) + 1;
        int m = (1 << l) - max;
        int v = (int)this.ReadLiteral(l - 1);
        return v < m ? v : (v << 1) - m + this.ReadBit();
    }

    int DecodeUniform2(int n) {
        if (n <= 1) {
            return 0;
        }
        int w = D.FloorLog2(n) + 1;
        int m = (1 << w) - n;
        int v = (int)this.ReadLiteral(w - 1);
        if (v == -1) {
            return 0;
        }
        if (v < m) {
            return v;
        }
        int extra_bit = this.ReadBit();
        if (extra_bit == -1) {
            return 0;
        }
        return (v << 1) - m + extra_bit;
    }

    int DecodeSignedSubexpWithReference(int low, int high, int reference, int control) {
        int value = this.DecodeUnsignedSubexpWithReference(high - low, reference - low, control);
        return value += low;
    }

    int DecodeUnsignedSubexpWithReference(int mx, int reference, int control) {
        int v = this.DecodeSubexp(mx, control);
        int value = reference << 1 <= mx ? Entropy.InverseRecenter(reference, v) : mx - 1 - Entropy.InverseRecenter(mx - 1 - reference, v);
        return value;
    }

    int DecodeSubexp(int num_symbols, int control) {
        int b;
        int i = 0;
        int mk = 0;
        int value = 0;
        while (true) {
            int n = b = i != 0 ? control + i - 1 : control;
            if (b >= 32) {
                return 0;
            }
            int a = 1 << b;
            if (num_symbols <= mk + 3 * a) {
                value = this.DecodeUniform(num_symbols - mk);
                return value += mk;
            }
            int subexp_more_bits = this.ReadBit();
            if (subexp_more_bits == -1) {
                return 0;
            }
            if (subexp_more_bits == 0) break;
            ++i;
            mk += a;
        }
        int subexp_bits = (int)this.ReadLiteral(b);
        if (subexp_bits == -1) {
            return 0;
        }
        return subexp_bits + mk;
    }
}

