/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;
import com.idrsolutions.image.avif.dec.Mem;

class Cdef {
    Cdef() {
    }

    static void doCdef(boolean isDirection, int pos0, int pos1, int[] src, int srcPos, int src_stride, int[] dst, int dstPos, int dst_stride, int primary_strength, int secondary_strength, int damping, int[] direction, int directionPos, int[] variance, int block_height) {
        if (isDirection) {
            Cdef.CdefDirection(src, srcPos, src_stride, direction, directionPos, variance);
        } else {
            switch (pos1) {
                case 0: {
                    if (pos0 == 0) {
                        Cdef.CdefFilter(src, srcPos, src_stride, dst, dstPos, dst_stride, primary_strength, secondary_strength, damping, direction, 4, block_height, true, true);
                        break;
                    }
                    if (pos0 == 1) {
                        Cdef.CdefFilter(src, srcPos, src_stride, dst, dstPos, dst_stride, primary_strength, secondary_strength, damping, direction, 4, block_height, true, false);
                        break;
                    }
                    Cdef.CdefFilter(src, srcPos, src_stride, dst, dstPos, dst_stride, primary_strength, secondary_strength, damping, direction, 4, block_height, false, true);
                    break;
                }
                case 1: {
                    if (pos0 == 0) {
                        Cdef.CdefFilter(src, srcPos, src_stride, dst, dstPos, dst_stride, primary_strength, secondary_strength, damping, direction, 8, block_height, true, true);
                        break;
                    }
                    if (pos0 == 1) {
                        Cdef.CdefFilter(src, srcPos, src_stride, dst, dstPos, dst_stride, primary_strength, secondary_strength, damping, direction, 8, block_height, true, false);
                        break;
                    }
                    Cdef.CdefFilter(src, srcPos, src_stride, dst, dstPos, dst_stride, primary_strength, secondary_strength, damping, direction, 8, block_height, false, true);
                }
            }
        }
    }

    static void CdefDirection(int[] src, int srcPos, int stride, int[] direction, int dirPos, int[] variance) {
        int j;
        int i;
        int bitdepth = 8;
        int[] cost = new int[8];
        int[][] partial = new int[8][15];
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                int x = (src[srcPos + j] >> 0) - 128;
                int[] nArray = partial[0];
                int n = i + j;
                nArray[n] = nArray[n] + x;
                int[] nArray2 = partial[1];
                int n2 = i + j / 2;
                nArray2[n2] = nArray2[n2] + x;
                int[] nArray3 = partial[2];
                int n3 = i;
                nArray3[n3] = nArray3[n3] + x;
                int[] nArray4 = partial[3];
                int n4 = 3 + i - j / 2;
                nArray4[n4] = nArray4[n4] + x;
                int[] nArray5 = partial[4];
                int n5 = 7 + i - j;
                nArray5[n5] = nArray5[n5] + x;
                int[] nArray6 = partial[5];
                int n6 = 3 - i / 2 + j;
                nArray6[n6] = nArray6[n6] + x;
                int[] nArray7 = partial[6];
                int n7 = j;
                nArray7[n7] = nArray7[n7] + x;
                int[] nArray8 = partial[7];
                int n8 = i / 2 + j;
                nArray8[n8] = nArray8[n8] + x;
            }
            srcPos += stride;
        }
        for (i = 0; i < 8; ++i) {
            cost[2] = cost[2] + D.Square(partial[2][i]);
            cost[6] = cost[6] + D.Square(partial[6][i]);
        }
        cost[2] = cost[2] * D.kDivisionTable[7];
        cost[6] = cost[6] * D.kDivisionTable[7];
        for (i = 0; i < 7; ++i) {
            cost[0] = cost[0] + (D.Square(partial[0][i]) + D.Square(partial[0][14 - i])) * D.kDivisionTable[i];
            cost[4] = cost[4] + (D.Square(partial[4][i]) + D.Square(partial[4][14 - i])) * D.kDivisionTable[i];
        }
        cost[0] = cost[0] + D.Square(partial[0][7]) * D.kDivisionTable[7];
        cost[4] = cost[4] + D.Square(partial[4][7]) * D.kDivisionTable[7];
        for (i = 1; i < 8; i += 2) {
            for (j = 0; j < 5; ++j) {
                int n = i;
                cost[n] = cost[n] + D.Square(partial[i][3 + j]);
            }
            int n = i;
            cost[n] = cost[n] * D.kDivisionTable[7];
            for (j = 0; j < 3; ++j) {
                int n9 = i;
                cost[n9] = cost[n9] + (D.Square(partial[i][j]) + D.Square(partial[i][10 - j])) * D.kDivisionTable[2 * j + 1];
            }
        }
        int best_cost = 0;
        direction[dirPos + 0] = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            if (cost[i2] <= best_cost) continue;
            best_cost = cost[i2];
            direction[dirPos + 0] = i2;
        }
        variance[0] = best_cost - cost[direction[dirPos + 0] + 4 & 7] >> 10;
    }

    static void CdefFilter(int[] src, int srcPos, int src_stride, int[] dst, int dstPos, int dst_stride, int primary_strength, int secondary_strength, int damping, int[] direction, int block_width, int block_height, boolean enable_primary, boolean enable_secondary) {
        boolean coeff_shift = false;
        boolean clipping_required = enable_primary && enable_secondary;
        int[] kCdefSecondaryTaps = new int[]{2, 1};
        int y = block_height;
        do {
            int x = 0;
            do {
                int pixel_value;
                int sum = 0;
                int max_value = pixel_value = src[srcPos + x];
                int min_value = pixel_value;
                for (int k = 0; k < 2; ++k) {
                    int[] signs;
                    for (int sign : signs = new int[]{-1, 1}) {
                        int[] offsets;
                        int dx;
                        int dy;
                        int value;
                        if (enable_primary && (value = src[srcPos + (dy = sign * D.kCdefDirections[direction[0]][k][0]) * src_stride + (dx = sign * D.kCdefDirections[direction[0]][k][1]) + x]) != 16384) {
                            sum += D.Constrain(value - pixel_value, primary_strength, damping) * D.kCdefPrimaryTaps[primary_strength >> 0 & 1][k];
                            if (clipping_required) {
                                max_value = Math.max(value, max_value);
                                min_value = Math.min(value, min_value);
                            }
                        }
                        if (!enable_secondary) continue;
                        for (int offset : offsets = new int[]{-2, 2}) {
                            int dy2 = sign * D.kCdefDirections[direction[0] + offset][k][0];
                            int dx2 = sign * D.kCdefDirections[direction[0] + offset][k][1];
                            int value2 = src[srcPos + dy2 * src_stride + dx2 + x];
                            if (value2 == 16384) continue;
                            sum += D.Constrain(value2 - pixel_value, secondary_strength, damping) * kCdefSecondaryTaps[k];
                            if (!clipping_required) continue;
                            max_value = Math.max(value2, max_value);
                            min_value = Math.min(value2, min_value);
                        }
                    }
                }
                int offset = 8 + sum - (sum < 0 ? 1 : 0) >> 4;
                dst[dstPos + x] = clipping_required ? D.Clip3(pixel_value + offset, min_value, max_value) : pixel_value + offset;
            } while (++x < block_width);
            srcPos += src_stride;
            dstPos += dst_stride;
        } while (--y != 0);
    }

    static void CopyRowForCdef(int[] src, int srcPos, int block_width, int unit_width, boolean is_frame_left, boolean is_frame_right, int[] dst, int dstPos, int[] left_border, int leftPos) {
        if (is_frame_left) {
            Mem.set(dst, dstPos - 2, 16384, 2);
        } else if (left_border == null) {
            Mem.cpy(dst, dstPos - 2, src, srcPos - 2, 2);
        } else {
            Mem.cpy(dst, dstPos - 2, left_border, leftPos, 2);
        }
        Mem.cpy(dst, dstPos, src, srcPos, block_width);
        if (is_frame_right) {
            Mem.set(dst, dstPos + block_width, 16384, unit_width + 2 - block_width);
        } else {
            Mem.cpy(dst, dstPos + block_width, src, srcPos + block_width, unit_width + 2 - block_width);
        }
    }
}

