/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.common;

import com.idrsolutions.image.avif.common.MV;
import com.idrsolutions.image.avif.common.ScaleFactors;

class Scale {
    static final int SCALE_NUMERATOR = 8;
    static final int REF_SCALE_SHIFT = 14;
    static final int REF_NO_SCALE = 16384;
    static final int REF_INVALID_SCALE = -1;
    static final int FILTER_BITS = 7;
    static final int SUBPEL_BITS = 4;
    static final int SUBPEL_MASK = 15;
    static final int SUBPEL_SHIFTS = 16;
    static final int SUBPEL_TAPS = 8;
    static final int SCALE_SUBPEL_BITS = 10;
    static final int SCALE_SUBPEL_SHIFTS = 1024;
    static final int SCALE_SUBPEL_MASK = 1023;
    static final int SCALE_EXTRA_BITS = 6;
    static final int SCALE_EXTRA_OFF = 32;
    static final int RS_SUBPEL_BITS = 6;
    static final int RS_SUBPEL_MASK = 63;
    static final int RS_SCALE_SUBPEL_BITS = 14;
    static final int RS_SCALE_SUBPEL_MASK = 16383;
    static final int RS_SCALE_EXTRA_BITS = 8;
    static final int RS_SCALE_EXTRA_OFF = 128;

    Scale() {
    }

    static long ROUND_POWER_OF_TWO(long value, int n) {
        return value + (1L << n >> 1) >> n;
    }

    static long ROUND_POWER_OF_TWO_SIGNED(long value, int n) {
        return value < 0L ? -Scale.ROUND_POWER_OF_TWO(-value, n) : Scale.ROUND_POWER_OF_TWO(value, n);
    }

    static long ROUND_POWER_OF_TWO_64(long value, int n) {
        return value + (1L << n >> 1) >> n;
    }

    static long ROUND_POWER_OF_TWO_SIGNED_64(long value, int n) {
        return value < 0L ? -Scale.ROUND_POWER_OF_TWO_64(-value, n) : Scale.ROUND_POWER_OF_TWO_64(value, n);
    }

    static int av1_scaled_x(int val, ScaleFactors sf) {
        int off = (sf.x_scale_fp - 16384) * 8;
        long tval = (long)val * (long)sf.x_scale_fp + (long)off;
        return (int)Scale.ROUND_POWER_OF_TWO_SIGNED_64(tval, 8);
    }

    static int av1_scaled_y(int val, ScaleFactors sf) {
        int off = (sf.y_scale_fp - 16384) * 8;
        long tval = (long)val * (long)sf.y_scale_fp + (long)off;
        return (int)Scale.ROUND_POWER_OF_TWO_SIGNED_64(tval, 8);
    }

    static int av1_unscaled_value(int val, ScaleFactors sf) {
        return val * 64;
    }

    static boolean av1_is_valid_scale(ScaleFactors sf) {
        return sf.x_scale_fp != -1 && sf.y_scale_fp != -1;
    }

    static boolean av1_is_scaled(ScaleFactors sf) {
        return Scale.av1_is_valid_scale(sf) && (sf.x_scale_fp != 16384 || sf.y_scale_fp != 16384);
    }

    static boolean valid_ref_frame_size(int ref_width, int ref_height, int this_width, int this_height) {
        return 2 * this_width >= ref_width && 2 * this_height >= ref_height && this_width <= 16 * ref_width && this_height <= 16 * ref_height;
    }

    static int get_fixed_point_scale_factor(int other_size, int this_size) {
        return ((other_size << 14) + this_size / 2) / this_size;
    }

    static long fixed_point_scale_to_coarse_point_scale(int scale_fp) {
        return Scale.ROUND_POWER_OF_TWO(scale_fp, 4);
    }

    static MV av1_scale_mv(MV mvq4, int x, int y, ScaleFactors sf) {
        int x_off_q4 = Scale.av1_scaled_x(x << 4, sf);
        int y_off_q4 = Scale.av1_scaled_y(y << 4, sf);
        MV res = new MV();
        res.row = Scale.av1_scaled_y((y << 4) + mvq4.row, sf) - y_off_q4;
        res.col = Scale.av1_scaled_x((x << 4) + mvq4.col, sf) - x_off_q4;
        return res;
    }

    static void av1_setup_scale_factors_for_frame(ScaleFactors sf, int other_w, int other_h, int this_w, int this_h) {
        if (!Scale.valid_ref_frame_size(other_w, other_h, this_w, this_h)) {
            sf.x_scale_fp = -1;
            sf.y_scale_fp = -1;
            return;
        }
        sf.x_scale_fp = Scale.get_fixed_point_scale_factor(other_w, this_w);
        sf.y_scale_fp = Scale.get_fixed_point_scale_factor(other_h, this_h);
        sf.x_step_q4 = (int)Scale.fixed_point_scale_to_coarse_point_scale(sf.x_scale_fp);
        sf.y_step_q4 = (int)Scale.fixed_point_scale_to_coarse_point_scale(sf.y_scale_fp);
    }
}

