/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.ImageTypeFinder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.bmp.BmpDecoder;
import com.idrsolutions.image.bmp.options.BmpMetadata;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import com.idrsolutions.image.gif.GifDecoder;
import com.idrsolutions.image.gif.options.GifMetadata;
import com.idrsolutions.image.heic.options.HeicMetadata;
import com.idrsolutions.image.jpeg.ARGBJpegDecoder;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.options.JpegMetadata;
import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.jpeg2000.options.Jpeg2000Metadata;
import com.idrsolutions.image.jpegxl.JpegXLDecoder;
import com.idrsolutions.image.jpegxl.options.JpegxlMetadata;
import com.idrsolutions.image.metadata.Metadata;
import com.idrsolutions.image.pdf.PdfEncoder;
import com.idrsolutions.image.png.PngDecoder;
import com.idrsolutions.image.png.options.PngMetadata;
import com.idrsolutions.image.process.ImageProcessingOps;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.tiff.options.TiffEncoderOptions;
import com.idrsolutions.image.tiff.options.TiffMetadata;
import com.idrsolutions.image.utility.SupportedFormats;
import com.idrsolutions.image.webp.options.WebpMetadata;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.jpedal.utils.LogWriter;

public class JDeli
extends JDeliImage {
    public static void convert(File inputFile, File outputFile) throws Exception {
        JDeli.convert(inputFile, outputFile, null);
    }

    public static void convert(File inputFile, EncoderOptions outputOptions, File outputFile) throws Exception {
        ImageFormat inputFormatName = ImageTypeFinder.getImageType(JDeli.getTestBytes(inputFile));
        if (inputFormatName == ImageFormat.UNSUPPORTED_IMAGE) {
            throw new IOException("Unsupported image type - input format type not supported");
        }
        JDeli.convert(inputFormatName, inputFile, null, outputFile, outputOptions);
    }

    public static void convert(InputStream inputStream, EncoderOptions outputOptions, OutputStream outputStream, String format) throws Exception {
        JDeli.convert(inputStream, outputStream, format, outputOptions, null);
    }

    public static void convert(File inputFile, File outputFile, ImageProcessingOps operations) throws Exception {
        ImageFormat inputFormatName = ImageTypeFinder.getImageType(JDeli.getTestBytes(inputFile));
        if (inputFormatName == ImageFormat.UNSUPPORTED_IMAGE) {
            String filepath = inputFile.getPath();
            throw new IOException("Unsupported image type - input file format type " + filepath.substring(filepath.lastIndexOf(46) + 1) + " not supported");
        }
        OutputFormat formatName = SupportedFormats.getEnumFromString(JDeli.getFileFormat(outputFile.getAbsolutePath()));
        if (formatName == null) {
            throw new IOException("No filetype specified in path " + String.valueOf(outputFile));
        }
        EncoderOptions enc = SupportedFormats.getEncoderOptions(formatName);
        JDeli.convert(inputFormatName, inputFile, operations, outputFile, enc);
    }

    static byte[] convert(ImageFormat inputFormatName, byte[] input, ImageProcessingOps operations, EncoderOptions options, String format) throws Exception {
        if (options == null) {
            options = SupportedFormats.getEncoderOptions(SupportedFormats.getEnumFromString(format));
        }
        if (inputFormatName == ImageFormat.TIFF_IMAGE || inputFormatName == ImageFormat.DICOM_IMAGE) {
            if (options.getOutputFormat() == OutputFormat.PDF) {
                PdfEncoder pdf = new PdfEncoder();
                ByteArrayOutputStream baos = new ByteArrayOutputStream(input.length);
                pdf.write(JDeli.read(input), baos);
                return baos.toByteArray();
            }
            Decoder decoder = JDeli.getDecoder(inputFormatName);
            if (decoder != null) {
                int imageCount = decoder.getImageCount(input);
                byte[] output = new byte[]{};
                for (int i = 0; i < imageCount; ++i) {
                    BufferedImage image = decoder.readImageAt(i, input);
                    if (operations != null) {
                        image = operations.apply(image);
                    }
                    if (options.getOutputFormat() != OutputFormat.TIFF) {
                        return JDeli.write(image, options);
                    }
                    TiffEncoder enc = new TiffEncoder((TiffEncoderOptions)options);
                    output = enc.append(image, output);
                }
                return output;
            }
        } else {
            BufferedImage image = JDeli.read(input);
            if (operations != null) {
                image = operations.apply(image);
            }
            if (image != null) {
                return JDeli.write(image, options);
            }
        }
        return new byte[0];
    }

    static void convert(ImageFormat inputFormatName, File inputFile, ImageProcessingOps operations, File outputFile, EncoderOptions options) throws Exception {
        if (inputFile != null) {
            if (inputFormatName == ImageFormat.TIFF_IMAGE || inputFormatName == ImageFormat.DICOM_IMAGE) {
                if (options.getOutputFormat() == OutputFormat.PDF) {
                    PdfEncoder pdf = new PdfEncoder();
                    pdf.write(inputFile, outputFile);
                } else {
                    Decoder decoder = JDeli.getDecoder(inputFormatName);
                    if (decoder != null) {
                        int imageCount = decoder.getImageCount(inputFile);
                        for (int i = 0; i < imageCount; ++i) {
                            BufferedImage image = decoder.readImageAt(i, inputFile);
                            if (operations != null) {
                                image = operations.apply(image);
                            }
                            if (imageCount <= 1) {
                                JDeli.write(image, options, outputFile);
                                continue;
                            }
                            if (options.getOutputFormat() == OutputFormat.TIFF) {
                                TiffEncoder tiff = new TiffEncoder();
                                tiff.append(image, outputFile.getAbsolutePath());
                                continue;
                            }
                            JDeli.write(image, options, new File(outputFile.getAbsolutePath().substring(0, outputFile.getAbsolutePath().lastIndexOf(46)) + "_page_" + (i + 1) + "." + JDeli.getFileFormat(outputFile.getAbsolutePath())));
                        }
                    }
                }
            } else {
                BufferedImage image = JDeli.getBufferedImage(inputFile, inputFormatName, null);
                if (operations != null) {
                    image = operations.apply(image);
                }
                JDeli.write(image, options, outputFile);
            }
        }
    }

    public static BufferedImage process(ImageProcessingOps operations, BufferedImage image) {
        if (operations != null) {
            return operations.apply(image);
        }
        return image;
    }

    static String getFileFormat(String absolutePath) {
        int pos = absolutePath.lastIndexOf(46);
        if (pos == -1 && pos == absolutePath.length() - 1) {
            return null;
        }
        return absolutePath.substring(pos + 1);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, String format) throws Exception {
        JDeli.convert(inputStream, outputStream, format, null);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, String format, ImageProcessingOps operations) throws Exception {
        JDeli.convert(inputStream, outputStream, format, null, operations);
    }

    static void convert(InputStream inputStream, OutputStream outputStream, String format, EncoderOptions encOps, ImageProcessingOps operations) throws Exception {
        byte[] inputData = JDeli.readByteArray(inputStream);
        ImageFormat type = ImageTypeFinder.getImageType(inputData);
        if (encOps == null) {
            encOps = SupportedFormats.getEncoderOptions(SupportedFormats.getEnumFromString(format));
        }
        if (type == ImageFormat.UNSUPPORTED_IMAGE) {
            throw new IOException("Unsupported image type - input format type not supported");
        }
        if (type == ImageFormat.TIFF_IMAGE || type == ImageFormat.DICOM_IMAGE) {
            Decoder decoder = JDeli.getDecoder(type);
            if (decoder != null) {
                int imageCount = decoder.getImageCount(inputData);
                byte[] out = new byte[]{};
                for (int i = 0; i < imageCount; ++i) {
                    BufferedImage image = decoder.readImageAt(i, inputData);
                    if (operations != null) {
                        image = operations.apply(image);
                    }
                    if (encOps.getOutputFormat() == OutputFormat.TIFF) {
                        TiffEncoder enc = new TiffEncoder((TiffEncoderOptions)encOps);
                        out = enc.append(image, out);
                        continue;
                    }
                    JDeli.write(image, encOps, outputStream);
                }
                outputStream.write(out);
            }
        } else {
            BufferedImage image = JDeli.read(inputData);
            if (operations != null) {
                image = operations.apply(image);
            }
            JDeli.write(image, encOps, outputStream);
        }
    }

    public static byte[] convert(byte[] inputData, String format) throws Exception {
        return JDeli.convert(inputData, format, null);
    }

    public static byte[] convert(byte[] inputData, String format, ImageProcessingOps operations) throws Exception {
        ImageFormat type = ImageTypeFinder.getImageType(inputData);
        return JDeli.convert(type, inputData, operations, null, format);
    }

    public static byte[] convert(byte[] inputData, EncoderOptions options) throws Exception {
        ImageFormat type = ImageTypeFinder.getImageType(inputData);
        return JDeli.convert(type, inputData, null, options, "");
    }

    public static Metadata getImageInfo(File imageFile) throws Exception {
        byte[] bytes = JDeli.getTestBytes(imageFile);
        if (bytes.length == 0) {
            throw new RuntimeException("Zero Length file " + String.valueOf(imageFile));
        }
        ImageFormat type = ImageTypeFinder.getImageType(bytes);
        Metadata metadata = JDeli.getImageMetadataType(type);
        if (metadata == null) {
            throw new UnsupportedOperationException("Unsupported image type");
        }
        Decoder dec = JDeli.getDecoder(type);
        if (dec != null) {
            Rectangle size;
            dec.setMetadata(metadata);
            dec.readImageSpecificMetaData(imageFile, metadata);
            if (type == ImageFormat.TIFF_IMAGE) {
                dec.read(imageFile);
            }
            if ((size = JDeli.readDimension(imageFile)) != null) {
                metadata.setHeight(size.height);
                metadata.setWidth(size.width);
                String imageFile1 = imageFile.getPath();
                metadata.setReadable(JDeli.isImageSupportedForInput(imageFile1.substring(imageFile1.lastIndexOf(46) + 1)));
                metadata.setWritable(JDeli.isImageSupportedForOutput(imageFile1.substring(imageFile1.lastIndexOf(46) + 1)));
            }
        }
        return metadata;
    }

    public static Metadata getImageInfo(byte[] imageBytes) throws Exception {
        ImageFormat type = ImageTypeFinder.getImageType(imageBytes);
        Metadata metadata = JDeli.getImageMetadataType(type);
        if (metadata == null) {
            throw new UnsupportedOperationException("Unsupported image type");
        }
        Decoder dec = JDeli.getDecoder(type);
        if (dec != null) {
            Rectangle size;
            dec.setMetadata(metadata);
            dec.readImageSpecificMetaData(imageBytes, metadata);
            if (type == ImageFormat.TIFF_IMAGE) {
                dec.read(imageBytes);
            }
            if ((size = JDeli.readDimension(imageBytes)) != null) {
                metadata.setHeight(size.height);
                metadata.setWidth(size.width);
                String format = SupportedFormats.getInputStringFromEnum(type);
                metadata.setReadable(JDeli.isImageSupportedForInput(format));
                metadata.setWritable(JDeli.isImageSupportedForOutput(format));
            }
        }
        return metadata;
    }

    public static Metadata getImageInfo(InputStream inputStream) throws Exception {
        byte[] buffer = new byte[inputStream.available()];
        inputStream.read(buffer);
        Metadata metadata = JDeli.getImageInfo(buffer);
        inputStream.close();
        return metadata;
    }

    public static BufferedImage readEmbeddedThumbnail(byte[] imageBytes) throws Exception {
        ImageFormat type = ImageTypeFinder.getImageType(imageBytes);
        Decoder decoder = JDeli.getDecoder(type);
        if (decoder != null) {
            return decoder.readEmbeddedThumbnail(imageBytes);
        }
        return null;
    }

    public static BufferedImage readEmbeddedThumbnail(File imageFile) throws Exception {
        byte[] bytes = JDeli.getTestBytes(imageFile);
        if (bytes.length == 0) {
            throw new RuntimeException("Zero Length file " + String.valueOf(imageFile));
        }
        ImageFormat type = ImageTypeFinder.getImageType(bytes);
        Decoder decoder = JDeli.getDecoder(type);
        if (decoder != null) {
            return decoder.readEmbeddedThumbnail(imageFile);
        }
        return null;
    }

    public static BufferedImage readEmbeddedThumbnail(InputStream inputStream) throws Exception {
        byte[] buffer = new byte[inputStream.available()];
        inputStream.read(buffer);
        return JDeli.readEmbeddedThumbnail(buffer);
    }

    public static Rectangle readDimension(byte[] imageBytes) throws Exception {
        ImageFormat type = ImageTypeFinder.getImageType(imageBytes);
        Decoder decoder = JDeli.getDecoder(type);
        if (decoder != null) {
            return decoder.readDimension(imageBytes);
        }
        return null;
    }

    public static Rectangle readDimension(File imageFile) throws Exception {
        byte[] bytes = JDeli.getTestBytes(imageFile);
        if (bytes.length == 0) {
            throw new RuntimeException("Zero Length file " + String.valueOf(imageFile));
        }
        ImageFormat type = ImageTypeFinder.getImageType(bytes);
        Decoder decoder = JDeli.getDecoder(type);
        if (decoder != null) {
            return decoder.readDimension(imageFile);
        }
        return null;
    }

    public static Rectangle readDimension(InputStream inputStream) throws Exception {
        byte[] buffer = new byte[inputStream.available()];
        inputStream.read(buffer);
        return JDeli.readDimension(buffer);
    }

    private static Object getClassFromPath(String path) {
        Object instance = null;
        try {
            Class<?> c = Class.forName(path);
            instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            LogWriter.error(ex, "Exception thrown when retrieving class instance for " + path);
        }
        return instance;
    }

    private static Metadata getImageMetadataType(ImageFormat imageType) {
        return switch (imageType) {
            case ImageFormat.BMP_IMAGE -> new BmpMetadata();
            case ImageFormat.DICOM_IMAGE -> (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.dicom.options.DicomMetadata");
            case ImageFormat.EMF_IMAGE -> (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.emf.options.EmfMetadata");
            case ImageFormat.GIF_IMAGE, ImageFormat.ANIMATED_GIF -> new GifMetadata();
            case ImageFormat.HEIC_IMAGE, ImageFormat.HEIC_MULTI_FRAME_IMAGE -> new HeicMetadata();
            case ImageFormat.JPEG_IMAGE -> new JpegMetadata();
            case ImageFormat.JPEG2000_IMAGE -> new Jpeg2000Metadata();
            case ImageFormat.JPEGXL_IMAGE -> new JpegxlMetadata();
            case ImageFormat.PNG_IMAGE -> new PngMetadata();
            case ImageFormat.PSD_IMAGE -> (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.psd.options.PsdMetadata");
            case ImageFormat.SGI_IMAGE -> (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.sgi.options.SgiMetadata");
            case ImageFormat.TIFF_IMAGE -> new TiffMetadata();
            case ImageFormat.WEBP_IMAGE -> new WebpMetadata();
            case ImageFormat.WMF_IMAGE -> (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.wmf.options.WmfMetadata");
            default -> null;
        };
    }

    public static BufferedImage read(File imageFile) throws Exception {
        byte[] bytes = JDeli.getTestBytes(imageFile);
        if (bytes.length == 0) {
            throw new RuntimeException("Zero Length file " + String.valueOf(imageFile));
        }
        ImageFormat type = ImageTypeFinder.getImageType(bytes);
        return JDeli.getBufferedImage(imageFile, type, null);
    }

    private static Decoder getDecoder(ImageFormat type) {
        return switch (type) {
            case ImageFormat.AVIF_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.avif.AvifDecoder");
            case ImageFormat.BMP_IMAGE -> new BmpDecoder();
            case ImageFormat.DICOM_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.dicom.DicomDecoder");
            case ImageFormat.EMF_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.emf.EmfDecoder");
            case ImageFormat.GIF_IMAGE, ImageFormat.ANIMATED_GIF -> new GifDecoder();
            case ImageFormat.HEIC_IMAGE, ImageFormat.HEIC_MULTI_FRAME_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.heic.HeicDecoder");
            case ImageFormat.JPEG_IMAGE -> new JpegDecoder();
            case ImageFormat.JPEGXL_IMAGE -> new JpegXLDecoder();
            case ImageFormat.JPEG2000_IMAGE -> new Jpeg2000Decoder();
            case ImageFormat.PNG_IMAGE -> new PngDecoder();
            case ImageFormat.PSD_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.psd.PsdDecoder");
            case ImageFormat.SGI_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.sgi.SgiDecoder");
            case ImageFormat.TIFF_IMAGE -> new TiffDecoder();
            case ImageFormat.WEBP_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.webp.WebpDecoder");
            case ImageFormat.WMF_IMAGE -> (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.wmf.WmfDecoder");
            default -> null;
        };
    }

    private static BufferedImage getBufferedImage(File imageFile, ImageFormat type, Metadata metadata) throws Exception {
        Decoder dec = JDeli.getDecoder(type);
        if (dec != null) {
            if (metadata != null) {
                dec.setMetadata(metadata);
            }
            return dec.read(imageFile);
        }
        return null;
    }

    private static byte[] getTestBytes(File imageFile) throws IOException {
        byte[] test;
        try (FileInputStream fis = new FileInputStream(imageFile);){
            test = new byte[Math.min(140, (int)imageFile.length())];
            fis.read(test);
        }
        return test;
    }

    public static BufferedImage read(File imageFile, HashMap<String, String> map) throws Exception {
        byte[] test = JDeli.getTestBytes(imageFile);
        if (map != null && map.containsKey("DECODE_4_COMPONENTS_AS_ARGB") && "true".equalsIgnoreCase(map.get("DECODE_4_COMPONENTS_AS_ARGB")) && ImageTypeFinder.getImageType(test) == ImageFormat.JPEG_IMAGE) {
            try (FileInputStream fis = new FileInputStream(imageFile);){
                byte[] data = new byte[(int)imageFile.length()];
                fis.read(data);
                BufferedImage bufferedImage = ARGBJpegDecoder.read(data);
                return bufferedImage;
            }
        }
        return JDeli.read(imageFile);
    }

    public static BufferedImage read(byte[] data, HashMap<String, String> map) throws Exception {
        if (map != null && map.containsKey("decode_4_components_as_argb") && "true".equalsIgnoreCase(map.get("decode_4_components_as_argb")) && ImageTypeFinder.getImageType(data) == ImageFormat.JPEG_IMAGE) {
            return ARGBJpegDecoder.read(data);
        }
        return JDeli.read(data);
    }

    public static BufferedImage read(byte[] data) throws Exception {
        ImageFormat type = ImageTypeFinder.getImageType(data);
        Decoder dec = JDeli.getDecoder(type);
        if (dec != null) {
            return dec.read(data);
        }
        return null;
    }

    public static BufferedImage read(InputStream is, HashMap<String, String> map) throws Exception {
        if (is instanceof ByteArrayInputStream) {
            LogWriter.writeLog("Do not wrap a byte[] in a ByteArrayInputStream, please use our read(byte[], HashMap) method instead");
        }
        return JDeli.read(JDeli.readByteArray(is), map);
    }

    public static BufferedImage read(InputStream is) throws Exception {
        if (is instanceof ByteArrayInputStream) {
            LogWriter.writeLog("Do not wrap a byte[] in a ByteArrayInputStream, please use our read(byte[]) method instead");
        }
        return JDeli.read(JDeli.readByteArray(is));
    }

    private static byte[] readByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[2048];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    public static void write(BufferedImage image, EncoderOptions options, File outputFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
        JDeli.write(image, options, (OutputStream)bos);
        bos.close();
    }

    public static byte[] write(BufferedImage image, EncoderOptions options) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(image.getWidth() * image.getHeight() * 3);
        JDeli.write(image, options, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void write(BufferedImage image, OutputFormat format, File outputFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
        JDeli.write(image, format, (OutputStream)bos);
        bos.close();
    }

    public static void write(BufferedImage image, String formatName, File outputFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
        JDeli.write(image, formatName, (OutputStream)bos);
        bos.close();
    }

    public static byte[] filter(byte[] raw_data, FilterOptions options) throws Exception {
        Filter filter = options.getFilter();
        if (options.getMode() == FilterOptions.FilterMode.COMPRESS) {
            return filter.encode(raw_data);
        }
        return filter.decode(raw_data);
    }

    public static void filter(InputStream inputStream, FilterOptions options, OutputStream outputStream) throws Exception {
        Filter filter = options.getFilter();
        if (options.getMode() == FilterOptions.FilterMode.COMPRESS) {
            filter.encode((BufferedInputStream)inputStream, (BufferedOutputStream)outputStream);
        }
        filter.decode((BufferedInputStream)inputStream, (BufferedOutputStream)outputStream, null, null);
    }

    public static boolean isImageSupportedForOutput(String formatName) {
        return SupportedFormats.hasEncoderSupportForImageFormat(formatName);
    }

    public static boolean isImageSupportedForInput(String formatName) {
        return SupportedFormats.hasDecoderSupportForImageFormat(formatName);
    }

    public static byte[] write(BufferedImage image, String formatName) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        JDeli.write(image, formatName, (OutputStream)bos);
        bos.close();
        return bos.toByteArray();
    }

    public static void write(BufferedImage image, String formatName, OutputStream stream) throws Exception {
        if (!JDeli.isImageSupportedForOutput(formatName)) {
            throw new IOException("The format Name " + formatName + " not supported yet for writing");
        }
        JDeli.write(image, SupportedFormats.getEnumFromString(formatName), stream);
    }

    public static void write(BufferedImage image, EncoderOptions options, OutputStream outputStream) throws Exception {
        OutputFormat format = options.getOutputFormat();
        Encoder enc = JDeli.getEncoder(format, options);
        if (enc != null) {
            enc.write(image, outputStream);
        }
    }

    public static void write(BufferedImage image, OutputFormat format, OutputStream outputStream) throws Exception {
        Encoder enc = JDeli.getEncoder(format, null);
        if (enc != null) {
            enc.write(image, outputStream);
        }
    }

    private static Encoder getEncoder(OutputFormat format, EncoderOptions options) {
        return SupportedFormats.getEncoder(format, options);
    }
}

