/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.metadata.Metadata;
import com.idrsolutions.image.png.PngCompressor;
import com.idrsolutions.image.process.ImageProcessingOperations;
import com.idrsolutions.image.process.ImageProcessingOps;
import com.idrsolutions.image.utility.SupportedFormats;
import com.idrsolutions.image.viewer.JDeliImageViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jpedal.utils.LogWriter;

public final class CommandLine {
    private static final Color BACKGROUND_COLOR = new Color(84, 130, 31);
    private static final Color FOREGROUND_COLOR = Color.WHITE;
    private static final Font FONT = new Font("SansSerif", 1, 13);
    private static final String EXCEPTION = "Exception: ";
    private static final String INPUT_NOT_FOUND = "Input Directory not found";
    private static final String OUTPUT_NOT_FOUND = "Output Directory not found";
    private static final String VERSION;

    private CommandLine() {
    }

    private static JLabel getStyledLabel(JLabel label) {
        label.setFont(FONT);
        label.setForeground(FOREGROUND_COLOR);
        return label;
    }

    private static void doAction(String actionAsString, String[] args) throws Exception {
        Action action;
        try {
            action = Action.valueOf(actionAsString.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            action = null;
        }
        if (action == null) {
            System.out.println("JDeli action '" + actionAsString + "' not recognised. Available actions are: " + Arrays.toString((Object[])Action.values()));
        } else {
            switch (action.ordinal()) {
                case 0: {
                    PngCompressor.main(args);
                    break;
                }
                case 1: {
                    CommandLine.convertFiles(args);
                    break;
                }
                case 2: {
                    CommandLine.showHelp();
                    break;
                }
                case 3: {
                    Metadata metadata = JDeli.getImageInfo(new File(args[0]));
                    if (metadata == null) break;
                    System.out.println(metadata);
                    break;
                }
                case 5: {
                    CommandLine.resizeToFit(args);
                    break;
                }
                case 6: {
                    CommandLine.changeSize(args, false);
                    break;
                }
                case 7: {
                    CommandLine.changeSize(args, true);
                    break;
                }
                case 4: {
                    CommandLine.rotate(args);
                    break;
                }
                case 8: {
                    CommandLine.openViewer(args);
                }
            }
        }
    }

    private static void openViewer(String[] args) {
        if (args.length < 2) {
            JDeliImageViewer.main(args);
        } else {
            CommandLine.showCommandLineValues("VIEW accepts 0 or 1 argument");
        }
    }

    private static void changeSize(String[] args, boolean setToWidth) {
        if (args.length < 3) {
            CommandLine.showCommandLineValues("RESIZETOWIDTH or RESIZETOHEIGHT needs 3 values");
        }
        try {
            int newSize = Integer.parseInt(args[0]);
            File inputDir = new File(args[1]);
            File outputDir = new File(args[2]);
            if (!inputDir.exists()) {
                throw new IOException(INPUT_NOT_FOUND);
            }
            if (!outputDir.exists()) {
                throw new IOException(OUTPUT_NOT_FOUND);
            }
            String outputFilename = inputDir.getName();
            File outputFile = new File(outputDir.getPath() + File.separator + outputFilename);
            ImageProcessingOperations operations = new ImageProcessingOperations();
            if (setToWidth) {
                operations.resizeToWidth(newSize);
            } else {
                operations.resizeToHeight(newSize);
            }
            JDeli.convert(inputDir, outputFile, (ImageProcessingOps)operations);
        }
        catch (Exception e) {
            CommandLine.writeLog(EXCEPTION + e.getMessage());
        }
    }

    private static void resizeToFit(String[] args) {
        if (args.length < 4) {
            CommandLine.showCommandLineValues("RESIZETOFIT needs 4 values");
        }
        try {
            int newWidth = Integer.parseInt(args[0]);
            int newHeight = Integer.parseInt(args[1]);
            File inputDir = new File(args[2]);
            File outputDir = new File(args[3]);
            if (!inputDir.exists()) {
                throw new IOException(INPUT_NOT_FOUND);
            }
            if (!outputDir.exists()) {
                throw new IOException(OUTPUT_NOT_FOUND);
            }
            String outputFilename = inputDir.getName();
            File outputFile = new File(outputDir.getPath() + File.separator + outputFilename);
            ImageProcessingOperations operations = new ImageProcessingOperations();
            operations.resizeToFit(newWidth, newHeight);
            JDeli.convert(inputDir, outputFile, (ImageProcessingOps)operations);
        }
        catch (Exception e) {
            CommandLine.writeLog(EXCEPTION + e.getMessage());
        }
    }

    private static void convertFiles(String[] args) throws Exception {
        if (args.length < 3) {
            CommandLine.showCommandLineValues("convert");
        }
        try {
            String outputFormat = args[0];
            File inputDir = new File(args[1]);
            File outputDir = new File(args[2]);
            if (!JDeli.isImageSupportedForOutput(outputFormat)) {
                throw new IOException("Supported image formats are: " + Arrays.toString((Object[])OutputFormat.values()));
            }
            if (!inputDir.exists()) {
                throw new IOException(INPUT_NOT_FOUND);
            }
            if (inputDir.isDirectory()) {
                CommandLine.convertAllFilesInInputDir(inputDir, outputDir, outputFormat);
            } else {
                String outputFilename = CommandLine.getFileName(inputDir);
                if (!outputDir.exists()) {
                    throw new IOException(OUTPUT_NOT_FOUND);
                }
                File outputFile = new File(outputDir.getPath() + File.separator + outputFilename + "." + outputFormat);
                CommandLine.convert(inputDir, outputFile);
            }
        }
        catch (IOException e) {
            CommandLine.writeLog(EXCEPTION + e.getMessage());
        }
    }

    private static void convertAllFilesInInputDir(File inputDir, File outputDir, String outputFormat) throws Exception {
        List<File> list;
        if (!outputDir.exists()) {
            throw new IOException(OUTPUT_NOT_FOUND);
        }
        try (Stream<Path> stream = Files.walk(inputDir.toPath(), 5, new FileVisitOption[0]);){
            list = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::toAbsolutePath).map(Path::toFile).toList();
        }
        String inputDirPath = inputDir.getAbsolutePath();
        for (File file2 : list) {
            String fileName = file2.getName();
            String inputFileExtension = CommandLine.getInputFileExtension(fileName);
            if (!JDeli.isImageSupportedForInput(inputFileExtension) || fileName.startsWith(".")) continue;
            String inputFilePath = file2.getAbsolutePath();
            String sharedPath = inputFilePath.substring(inputDirPath.length(), inputFilePath.length() - file2.getName().length());
            File sub = new File(outputDir, sharedPath);
            if (!sub.exists()) {
                sub.mkdir();
            }
            File outputFile = new File(sub, CommandLine.getFileName(file2) + "." + outputFormat);
            CommandLine.convert(file2, outputFile);
        }
    }

    private static String getInputFileExtension(String name) {
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf + 1);
    }

    private static String getFileName(File file) {
        String name = "output";
        if (file != null) {
            name = file.getName();
            int i = name.lastIndexOf(46);
            name = name.substring(0, i);
        }
        return name;
    }

    private static void convert(File inputFile, File outputFile) throws Exception {
        JDeli.convert(inputFile, outputFile);
    }

    private static void writeLog(String msg) {
        LogWriter.writeLog(msg);
    }

    private static String listFormats(String[][] list) {
        StringBuilder formats = new StringBuilder();
        if (list != null) {
            int len = 0;
            for (String[] supported : list) {
                if (++len % 8 == 0) {
                    formats.append("\n \t  ");
                }
                if ("jpx".equals(supported[0])) {
                    formats.append("jpeg2000");
                } else {
                    formats.append(supported[0]);
                }
                if (len == list.length) {
                    formats.append('.');
                    continue;
                }
                formats.append(", ");
            }
        }
        return formats.toString().toUpperCase();
    }

    private static void showHelp() {
        StringBuilder usages = new StringBuilder();
        for (Action a : Action.values()) {
            usages.append("   ").append(a.exampleUsage()).append('\n');
        }
        String info = "\t \t \t     JDeli \n \t Java Decoding and Encoding Library for Images\n\n \t \t     Version:  " + VERSION + "\nFeatures:\n   - Encoders:\n\t   " + CommandLine.listFormats(SupportedFormats.getSupportedImageEncoders()) + "\n   - Decoders:\n\t   " + CommandLine.listFormats(SupportedFormats.getSupportedImageDecoders()) + "\n   - Processing\n\n   - Filtering\n\n More on using JDeli:\n   Support site: https://support.idrsolutions.com/jdeli/\n   Homepage: https://www.idrsolutions.com/jdeli\n   Javadoc: https://files.idrsolutions.com/maven/site/jdeli/apidocs/\n\n\n Accepted Arguments:\n" + String.valueOf(usages);
        if (System.console() != null || GraphicsEnvironment.isHeadless()) {
            System.out.println(info);
        } else if (!GraphicsEnvironment.isHeadless()) {
            CommandLine.showHelpWindow();
        }
    }

    private static void showHelpWindow() {
        final JFrame jf = new JFrame("JDeli - Java Decoding and Encoding Library for Images");
        jf.setSize(440, 500);
        jf.setDefaultCloseOperation(3);
        final JPanel panel = new JPanel();
        panel.setBackground(BACKGROUND_COLOR);
        ImageIcon logo = new ImageIcon(Objects.requireNonNull(JDeli.class.getResource("/com/idrsolutions/image/res/jdeliLogo.png")));
        JLabel idrLogo = new JLabel(logo, 0);
        jf.getContentPane().add((Component)idrLogo, "North");
        JPanel question = new JPanel();
        question.setBackground(BACKGROUND_COLOR);
        question.setForeground(FOREGROUND_COLOR);
        question.setPreferredSize(new Dimension(250, 50));
        question.setLayout(new BoxLayout(question, 1));
        question.add(CommandLine.getStyledLabel(new JLabel("              Version:  " + VERSION, 0)));
        question.add(CommandLine.getStyledLabel(new JLabel(" ")));
        question.add(CommandLine.getStyledLabel(new JLabel("       What would you like to do?", 0)));
        panel.add(question);
        JPanel lPanel = new JPanel();
        lPanel.setBackground(BACKGROUND_COLOR);
        lPanel.setPreferredSize(new Dimension(400, 125));
        lPanel.setLayout(new GridLayout(2, 2, 40, 20));
        lPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JButton homeURL = new JButton("Visit Homepage");
        homeURL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli"));
                }
                catch (IOException | URISyntaxException e1) {
                    CommandLine.writeLog(CommandLine.EXCEPTION + e1.getMessage());
                }
            }
        });
        lPanel.add(homeURL);
        JButton supportURL = new JButton("Read Documentation");
        supportURL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://support.idrsolutions.com/jdeli/"));
                }
                catch (IOException | URISyntaxException e1) {
                    CommandLine.writeLog(CommandLine.EXCEPTION + e1.getMessage());
                }
            }
        });
        lPanel.add(supportURL);
        JButton viewer = new JButton("Launch Viewer");
        viewer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CommandLine.openViewer(new String[0]);
                jf.dispose();
            }
        });
        lPanel.add(viewer);
        JButton javadocURL = new JButton("View Javadoc");
        javadocURL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://files.idrsolutions.com/maven/site/jdeli/apidocs/"));
                }
                catch (IOException | URISyntaxException e1) {
                    CommandLine.writeLog(CommandLine.EXCEPTION + e1.getMessage());
                }
            }
        });
        lPanel.add(javadocURL);
        panel.add(lPanel);
        jf.getContentPane().add(panel);
        panel.add(CommandLine.getStyledLabel(new JLabel(" ")));
        jf.setVisible(true);
        jf.setLocationRelativeTo(null);
        jf.setResizable(false);
    }

    private static void showCommandLineValues(String val2) {
        String val = "rotate".equals(val2) ? "degrees in which you would like to rotate the image" : "output format to which the image file needs to be converted";
        System.out.println("Example takes 4 parameters");
        System.out.println("Value 1 is the option you want to select from: " + Arrays.toString((Object[])Action.values()));
        System.out.println("Value 2 is the " + val);
        System.out.println("Value 3 is the path to write out the input directory and must end with / or \\ character)");
        System.out.println("Value 4 is the path to write out the converted directory and must end with / or \\ character)");
    }

    private static void rotate(String[] args) {
        if (args.length < 3) {
            CommandLine.showCommandLineValues("rotate");
        }
        try {
            double degrees = Double.parseDouble(args[0]);
            File inputDir = new File(args[1]);
            File outputDir = new File(args[2]);
            if (!inputDir.exists()) {
                throw new IOException(INPUT_NOT_FOUND);
            }
            if (!outputDir.exists()) {
                throw new IOException(OUTPUT_NOT_FOUND);
            }
            String outputFilename = inputDir.getName();
            File outputFile = new File(outputDir.getPath() + File.separator + outputFilename);
            ImageProcessingOperations operations = new ImageProcessingOperations();
            operations.rotate(degrees %= 360.0);
            JDeli.convert(inputDir, outputFile, (ImageProcessingOps)operations);
        }
        catch (Exception e) {
            CommandLine.writeLog(EXCEPTION + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            CommandLine.showHelp();
        } else {
            String actionName = args[0];
            if (actionName.startsWith("--")) {
                CommandLine.doAction(actionName.substring(2), CommandLine.removeFirstValue(args));
            } else {
                throw new IOException("Supported Actions are: " + Arrays.toString((Object[])Action.values()));
            }
        }
    }

    private static String[] removeFirstValue(String[] inputValues) {
        int newArraySize = inputValues.length - 1;
        String[] outputValues = new String[newArraySize];
        System.arraycopy(inputValues, 1, outputValues, 0, newArraySize);
        return outputValues;
    }

    static {
        Properties props = new Properties();
        try (InputStream is = CommandLine.class.getResourceAsStream("/version.num");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            CommandLine.writeLog(EXCEPTION + e.getMessage());
        }
        String versionSet = props.getProperty("release");
        VERSION = versionSet != null ? versionSet : "@VERSION@";
    }

    private static enum Action {
        COMPRESSPNG,
        CONVERT,
        HELP,
        INFO,
        ROTATE,
        RESIZETOFIT,
        RESIZETOHEIGHT,
        RESIZETOWIDTH,
        VIEW;


        String exampleUsage() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> "--compresspng file.png";
                case 1 -> "--convert outputFormat inputDir outputDir";
                case 2 -> "--help";
                case 3 -> "--info file.png";
                case 5 -> "--resizetofit width-pixels height-pixels inputfile outputdir";
                case 6 -> "--resizetoheight height-pixels inputfile outputdir";
                case 7 -> "--resizetowidth width-pixels inputfile outputdir";
                case 4 -> "--rotate degree inputfile outputdir";
                case 8 -> "--view file.png";
            };
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

