/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions;

import com.idrsolutions.JDeliImageReaderSpi;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.ImageTypeFinder;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class TIFFImageReaderSpi
extends JDeliImageReaderSpi {
    private static final String[] names = new String[]{"tif", "TIF", "tiff", "TIFF"};
    private static final String[] suffixes = new String[]{"tif", "tiff"};
    private static final String[] MIMETypes = new String[]{"image/tiff"};

    public TIFFImageReaderSpi() {
        super(names, suffixes, MIMETypes);
    }

    @Override
    public String getDescription(Locale locale) {
        return "TIFF JDeli Image Reader";
    }

    public static boolean isFormatSupported(String extension) {
        return "TIFF".equalsIgnoreCase(extension);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (this.isRegistered()) {
            ImageInputStream input = (ImageInputStream)source;
            byte[] b = new byte[140];
            input.read(b);
            return ImageTypeFinder.getImageType(b).equals((Object)ImageFormat.TIFF_IMAGE);
        }
        return false;
    }

    @Override
    public ImageReader createReaderInstance() throws IOException {
        return this.createReaderInstance("tiff");
    }
}

