/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions;

import com.idrsolutions.JDeliImageReaderSpi;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.ImageTypeFinder;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class JPEGXLImageReaderSpi
extends JDeliImageReaderSpi {
    private static final String[] names = new String[]{"JPEGXL"};
    private static final String[] suffixes = new String[]{"jxl"};
    private static final String[] MIMETypes = new String[]{"image/jxl"};

    public JPEGXLImageReaderSpi() {
        super(names, suffixes, MIMETypes);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (this.isRegistered()) {
            ImageInputStream input = (ImageInputStream)source;
            byte[] b = new byte[140];
            input.read(b);
            return ImageTypeFinder.getImageType(b).equals((Object)ImageFormat.JPEGXL_IMAGE);
        }
        return false;
    }

    @Override
    public String getDescription(Locale locale) {
        return "JPEG XL JDeli Image Reader";
    }

    public static boolean isFormatSupported(String extension) {
        return "JPEGXL".equalsIgnoreCase(extension);
    }

    @Override
    public ImageReader createReaderInstance() throws IOException {
        return this.createReaderInstance("jxl");
    }
}

