/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions;

import com.idrsolutions.JDeliImageWriteParam;
import com.idrsolutions.JDeliMetadata;
import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class JDeliImageWriter
extends ImageWriter {
    private ImageOutputStream stream;
    private final OutputFormat output;
    private JDeliImageWriteParam iwp;

    public JDeliImageWriter(ImageWriterSpi originatingProvider, OutputFormat format) {
        super(originatingProvider);
        this.output = format;
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        this.stream = output != null ? (ImageOutputStream)output : null;
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return new JDeliMetadata();
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) {
        BufferedImage im = (BufferedImage)image.getRenderedImage();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            if (param != null) {
                JDeliImageWriteParam params = (JDeliImageWriteParam)param;
                JDeli.write(im, SupportedFormats.getEncoderOptions(params, this.output), (OutputStream)b);
            } else {
                JDeli.write(im, this.output, (OutputStream)b);
            }
            if (this.stream != null) {
                this.stream.write(b.toByteArray());
            }
        }
        catch (Exception ex) {
            System.err.println("Using" + JDeliImageWriter.class.getName() + " Error:" + ex.getMessage());
        }
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        if (this.iwp == null) {
            this.iwp = new JDeliImageWriteParam(Locale.getDefault(), this.output);
        }
        return this.iwp;
    }
}

