/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.time;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.time.internal.TimeConverter;
import java.util.concurrent.TimeUnit;

public interface Timestamp {
    public static final Timestamp NONE = Timestamp.fromMicros(0L);

    public static Timestamp fromSeconds(long seconds) {
        Preconditions.checkArgument(seconds >= 0L);
        return Timestamp.fromMicros(TimeUnit.SECONDS.toMicros(seconds));
    }

    public static Timestamp fromMillis(long milliseconds) {
        Preconditions.checkArgument(milliseconds >= 0L);
        return Timestamp.fromMicros(TimeUnit.MILLISECONDS.toMicros(milliseconds));
    }

    public static Timestamp fromMicros(long microseconds) {
        Preconditions.checkArgument(microseconds >= 0L);
        return com.teamdev.jxbrowser.time.internal.rpc.Timestamp.newBuilder().setMicroseconds(TimeConverter.unixToWindowsEpochMicros(microseconds)).build();
    }

    default public long toMicros() {
        return TimeConverter.windowsToUnixEpochMicros(((com.teamdev.jxbrowser.time.internal.rpc.Timestamp)this).getMicroseconds());
    }

    default public long toMillis() {
        return TimeUnit.MICROSECONDS.toMillis(this.toMicros());
    }

    default public long toSeconds() {
        return TimeUnit.MICROSECONDS.toSeconds(this.toMicros());
    }
}

