/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.profile.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.profile.ProfilePreferences;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfilePreferencesStub;
import com.teamdev.jxbrowser.profile.internal.rpc.SetPreferenceRequest;

final class ProfilePreferencesImpl
extends CloseableImpl
implements ProfilePreferences {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<ProfilePreferencesStub> rpc;

    ProfilePreferencesImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.rpc = new ServiceConnectionImpl<ProfilePreferencesStub>(profile.id(), profile.engine().connection(), ProfilePreferencesStub::new);
    }

    @Override
    public boolean isAutofillEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAutofillEnabled, this.profile.id())).getValue();
    }

    @Override
    public void enableAutofill() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setAutofillEnabled, this.setPreferenceRequest(true));
    }

    @Override
    public void disableAutofill() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setAutofillEnabled, this.setPreferenceRequest(false));
    }

    @Override
    public boolean isCaretBrowsingEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isCaretBrowsingEnabled, this.profile.id())).getValue();
    }

    @Override
    public void enableCaretBrowsing() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setCaretBrowsingEnabled, this.setPreferenceRequest(true));
    }

    @Override
    public void disableCaretBrowsing() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setCaretBrowsingEnabled, this.setPreferenceRequest(false));
    }

    @Override
    public boolean isNetworkPredictionEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isNetworkPredictionEnabled, this.profile.id())).getValue();
    }

    @Override
    public void enableNetworkPrediction() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setNetworkPredictionEnabled, this.setPreferenceRequest(true));
    }

    @Override
    public void disableNetworkPrediction() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setNetworkPredictionEnabled, this.setPreferenceRequest(false));
    }

    private SetPreferenceRequest setPreferenceRequest(boolean value) {
        return SetPreferenceRequest.newBuilder().setProfileId(this.profile.id()).setIsEnabled(value).build();
    }
}

