/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.print.internal;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.print.PdfPrinter;
import com.teamdev.jxbrowser.print.PrintSettings;
import com.teamdev.jxbrowser.print.Printers;
import com.teamdev.jxbrowser.print.SystemPrinter;
import com.teamdev.jxbrowser.print.internal.PrinterImpl;
import com.teamdev.jxbrowser.print.internal.rpc.PrintHtml;
import com.teamdev.jxbrowser.print.internal.rpc.PrintPdf;
import com.teamdev.jxbrowser.print.internal.rpc.Printer;
import com.teamdev.jxbrowser.print.internal.settings.PdfPrinterHtmlSettings;
import com.teamdev.jxbrowser.print.internal.settings.PdfPrinterPdfSettings;
import com.teamdev.jxbrowser.print.internal.settings.PrintSettingsConstructor;
import com.teamdev.jxbrowser.print.internal.settings.SystemPrinterHtmlSettings;
import com.teamdev.jxbrowser.print.internal.settings.SystemPrinterPdfSettings;
import java.util.List;
import java.util.Optional;

public final class PrintersImpl<PdfT extends PrintSettings, SystemT extends PrintSettings>
implements Printers<PdfT, SystemT> {
    private final PrinterImpl<PdfT> pdfPrinter;
    private final List<PrinterImpl<SystemT>> printers;

    public static PrintersImpl<PdfPrinter.HtmlSettings, SystemPrinter.HtmlSettings> from(PrintHtml.Request params) {
        BrowserImpl browser = BrowserImpl.of(params.getBrowserId());
        return new PrintersImpl<PdfPrinter.HtmlSettings, SystemPrinter.HtmlSettings>(params.getPrintersList(), params.getPdfPrinter(), browser, SystemPrinterHtmlSettings::new, PdfPrinterHtmlSettings::new);
    }

    public static PrintersImpl<PdfPrinter.PdfSettings, SystemPrinter.PdfSettings> from(PrintPdf.Request params) {
        BrowserImpl browser = BrowserImpl.of(params.getBrowserId());
        return new PrintersImpl<PdfPrinter.PdfSettings, SystemPrinter.PdfSettings>(params.getPrintersList(), params.getPdfPrinter(), browser, SystemPrinterPdfSettings::new, PdfPrinterPdfSettings::new);
    }

    private PrintersImpl(List<Printer> printers, Printer pdfPrinter, BrowserImpl browser, PrintSettingsConstructor<SystemT> systemCtor, PrintSettingsConstructor<PdfT> pdfCtor) {
        this.pdfPrinter = new PrinterImpl<PdfT>(pdfPrinter, browser, pdfCtor);
        this.printers = printers.stream().map(printer -> new PrinterImpl((Printer)printer, browser, systemCtor)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public PdfPrinter<PdfT> pdfPrinter() {
        return this.pdfPrinter;
    }

    @Override
    public Optional<SystemPrinter<SystemT>> defaultPrinter() {
        return this.printers.stream().filter(PrinterImpl::isDefault).findFirst().map(printer -> printer);
    }

    @Override
    @Immutable
    public List<SystemPrinter<SystemT>> list() {
        return this.printers.stream().collect(ImmutableList.toImmutableList());
    }
}

