/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.os.internal;

import com.teamdev.jxbrowser.browser.internal.rpc.WindowHandle;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.Maybe;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.os.callback.internal.HideOnScreenKeyboardCallback;
import com.teamdev.jxbrowser.os.callback.internal.ShowOnScreenKeyboardCallback;
import com.teamdev.jxbrowser.os.internal.rpc.NotifyOnScreenKeyboardHiddenRequest;
import com.teamdev.jxbrowser.os.internal.rpc.NotifyOnScreenKeyboardShownRequest;
import com.teamdev.jxbrowser.os.internal.rpc.OnScreenKeyboardStub;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OnScreenKeyboard {
    private static final List<OnScreenKeyboard> keyboards = Collections.synchronizedList(new ArrayList());
    private final ServiceConnectionImpl<OnScreenKeyboardStub> rpc;

    public static boolean isEnabled() {
        return Environment.isWindows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List<OnScreenKeyboard> list = keyboards;
        synchronized (list) {
            keyboards.remove(this);
        }
    }

    public static Maybe<OnScreenKeyboard> maybeNewInstance(EngineImpl engine) {
        return Maybe.of(() -> OnScreenKeyboard.isEnabled() ? new OnScreenKeyboard(engine) : null);
    }

    private void notifyShown(WindowHandle windowHandle, int x, int y, int width, int height) {
        Rect occludedRect = Wrappers.unwrap(Geometry.newRect(x, y, width, height), Rect.class);
        NotifyOnScreenKeyboardShownRequest.Builder builder = NotifyOnScreenKeyboardShownRequest.newBuilder().setOccludedRect(occludedRect).setWindowHandle(windowHandle);
        this.rpc.invokeAsync(this.rpc.stub()::notifyOnScreenKeyboardShown, builder.build());
    }

    private void notifyHidden(WindowHandle windowHandle) {
        NotifyOnScreenKeyboardHiddenRequest.Builder builder = NotifyOnScreenKeyboardHiddenRequest.newBuilder().setWindowHandle(windowHandle);
        this.rpc.invokeAsync(this.rpc.stub()::notifyOnScreenKeyboardHidden, builder.build());
    }

    public static void addNativeListeners(long windowHandle) {
        if (OnScreenKeyboard.isEnabled()) {
            ToolkitLibrary.instance().registerOskEventHandler(windowHandle, new Callback());
        }
    }

    public static void removeNativeListeners(long windowHandle) {
        if (OnScreenKeyboard.isEnabled()) {
            ToolkitLibrary.instance().unregisterOskEventHandler(windowHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OnScreenKeyboard(EngineImpl engine) {
        List<OnScreenKeyboard> list = keyboards;
        synchronized (list) {
            keyboards.add(this);
        }
        this.rpc = new ServiceConnectionImpl<OnScreenKeyboardStub>(engine.id(), engine.connection(), OnScreenKeyboardStub::new);
        this.rpc.set(ShowOnScreenKeyboardCallback.class, (params, tell) -> {
            long windowHandle = params.windowHandle().getValue();
            ToolkitLibrary.instance().showOnScreenKeyboard(windowHandle, tell::proceed);
        });
        this.rpc.set(HideOnScreenKeyboardCallback.class, (params, tell) -> {
            ToolkitLibrary.instance().hideOnScreenKeyboard(params.windowHandle().getValue());
            tell.proceed();
        });
    }

    public static class Callback {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onShow(long windowHandle, int x, int y, int width, int height) {
            List list = keyboards;
            synchronized (list) {
                for (OnScreenKeyboard keyboard : keyboards) {
                    keyboard.notifyShown(WindowHandle.newBuilder().setValue(windowHandle).build(), x, y, width, height);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onHide(long windowHandle) {
            List list = keyboards;
            synchronized (list) {
                for (OnScreenKeyboard keyboard : keyboards) {
                    keyboard.notifyHidden(WindowHandle.newBuilder().setValue(windowHandle).build());
                }
            }
        }
    }
}

