/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net;

import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.net.internal.rpc.ContentType;
import java.util.Optional;

public interface ContentType {
    public static Builder newBuilder(String mediaType) {
        StringPreconditions.checkNotNullEmptyOrBlank(mediaType);
        return new Builder(mediaType);
    }

    default public String mediaType() {
        return com.teamdev.jxbrowser.net.internal.rpc.ContentType.cast(this).getMediaType();
    }

    default public Optional<String> charset() {
        if (com.teamdev.jxbrowser.net.internal.rpc.ContentType.cast(this).hasCharset()) {
            return Optional.of(com.teamdev.jxbrowser.net.internal.rpc.ContentType.cast(this).getCharset().getValue());
        }
        return Optional.empty();
    }

    default public Optional<String> boundary() {
        if (com.teamdev.jxbrowser.net.internal.rpc.ContentType.cast(this).hasBoundary()) {
            return Optional.of(com.teamdev.jxbrowser.net.internal.rpc.ContentType.cast(this).getBoundary().getValue());
        }
        return Optional.empty();
    }

    public static final class Builder {
        private final ContentType.Builder builder = com.teamdev.jxbrowser.net.internal.rpc.ContentType.newBuilder();

        private Builder(String mediaType) {
            this.builder.setMediaType(mediaType);
        }

        public Builder charset(String charset) {
            StringPreconditions.checkNotNullEmptyOrBlank(charset);
            this.builder.setCharset(StringValue.of(charset));
            return this;
        }

        public Builder boundary(String boundary) {
            StringPreconditions.checkNotNullEmptyOrBlank(boundary);
            this.builder.setBoundary(StringValue.of(boundary));
            return this;
        }

        public ContentType build() {
            return this.builder.build();
        }
    }
}

