/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.navigation.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Int32Value;
import com.teamdev.jxbrowser.deps.com.google.protobuf.UInt32Value;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.navigation.LoadUrlParams;
import com.teamdev.jxbrowser.navigation.Navigation;
import com.teamdev.jxbrowser.navigation.NavigationEntry;
import com.teamdev.jxbrowser.navigation.NavigationException;
import com.teamdev.jxbrowser.navigation.TimeoutException;
import com.teamdev.jxbrowser.navigation.callback.NavigationCallback;
import com.teamdev.jxbrowser.navigation.event.NavigationEvent;
import com.teamdev.jxbrowser.navigation.internal.rpc.Index;
import com.teamdev.jxbrowser.navigation.internal.rpc.LoadRequest;
import com.teamdev.jxbrowser.navigation.internal.rpc.LoadResponse;
import com.teamdev.jxbrowser.navigation.internal.rpc.NavigationStub;
import com.teamdev.jxbrowser.navigation.internal.rpc.ReloadRequest;
import com.teamdev.jxbrowser.net.NetError;
import java.time.Duration;
import java.util.Optional;

public final class NavigationImpl
extends CloseableImpl
implements Navigation {
    private final BrowserImpl browser;
    private final ServiceConnectionImpl<NavigationStub> rpc;

    public NavigationImpl(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.rpc = new ServiceConnectionImpl<NavigationStub>(browser.id(), browser.engine().connection(), NavigationStub::new);
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public void loadUrl(String url) {
        StringPreconditions.checkNotNullEmptyOrBlank(url);
        this.checkNotClosed();
        this.loadUrl(LoadUrlParams.newBuilder(url).build());
    }

    @Override
    public void loadUrl(LoadUrlParams params) {
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        LoadRequest request = LoadRequest.cast(params).toBuilder().setBrowserId(this.browser.id()).setTimeoutInSeconds(Navigation.defaultTimeout().getSeconds()).build();
        this.rpc.invokeAsync(this.rpc.stub()::load, request);
    }

    @Override
    public void loadUrlAndWait(String url) {
        this.loadUrlAndWait(url, Navigation.defaultTimeout());
    }

    @Override
    public void loadUrlAndWait(String url, Duration timeout) {
        StringPreconditions.checkNotNullEmptyOrBlank(url);
        Preconditions.checkArgument(!timeout.isNegative() && !timeout.isZero());
        this.checkNotClosed();
        this.loadUrlAndWait(LoadUrlParams.newBuilder(url).build(), timeout);
    }

    @Override
    public void loadUrlAndWait(LoadUrlParams params) {
        this.loadUrlAndWait(params, Navigation.defaultTimeout());
    }

    @Override
    public void loadUrlAndWait(LoadUrlParams params, Duration timeout) {
        Preconditions.checkNotNull(params);
        Preconditions.checkArgument(timeout.getSeconds() > 0L);
        this.checkNotClosed();
        this.loadAndWait(params, timeout).ifPresent(netError -> {
            throw new NavigationException("Failed to load resource: " + netError, (NetError)netError);
        });
    }

    @Override
    public boolean isLoading() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isLoading, this.browser.id())).getValue();
    }

    @Override
    public void goBack() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::goBack, this.browser.id());
    }

    @Override
    public boolean canGoBack() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::canGoBack, this.browser.id())).getValue();
    }

    @Override
    public void goForward() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::goForward, this.browser.id());
    }

    @Override
    public boolean canGoForward() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::canGoForward, this.browser.id())).getValue();
    }

    @Override
    public void stop() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::stop, this.browser.id());
    }

    @Override
    public void reload() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void reloadAndCheckForRepost() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).setCheckForRepost(true).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void reloadIgnoringCache() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).setIgnoreCache(true).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void reloadIgnoringCacheAndCheckForRepost() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).setIgnoreCache(true).setCheckForRepost(true).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void goToIndex(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.entryCount());
        this.checkNotClosed();
        Index request = Index.newBuilder().setBrowserId(this.browser.id()).setValue(index).build();
        this.rpc.invokeAsync(this.rpc.stub()::goToEntry, request);
    }

    @Override
    public int entryCount() {
        this.checkNotClosed();
        return ((UInt32Value)this.rpc.invoke(this.rpc.stub()::getSize, this.browser.id())).getValue();
    }

    @Override
    public int currentEntryIndex() {
        this.checkNotClosed();
        return ((Int32Value)this.rpc.invoke(this.rpc.stub()::getCurrentIndex, this.browser.id())).getValue();
    }

    @Override
    public NavigationEntry entryAtIndex(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.entryCount());
        this.checkNotClosed();
        Index request = Index.newBuilder().setBrowserId(this.browser.id()).setValue(index).build();
        return (NavigationEntry)this.rpc.invoke(this.rpc.stub()::getEntry, request);
    }

    @Override
    public boolean removeEntryAtIndex(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.entryCount() && index != this.currentEntryIndex());
        this.checkNotClosed();
        Index request = Index.newBuilder().setBrowserId(this.browser.id()).setValue(index).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::removeEntry, request)).getValue();
    }

    private Optional<NetError> loadAndWait(LoadUrlParams params, Duration timeout) {
        Preconditions.checkNotNull(params);
        Preconditions.checkNotNull(timeout);
        this.checkNotClosed();
        LoadRequest request = LoadRequest.cast(params).toBuilder().setBrowserId(this.browser.id()).setTimeoutInSeconds(timeout.getSeconds()).build();
        LoadResponse response = (LoadResponse)this.rpc.invoke(this.rpc.stub()::load, request);
        if (response.hasError()) {
            return Optional.of(response.getError());
        }
        if (response.hasTimedOut()) {
            throw new TimeoutException(String.format("Failed to complete the navigation within %d seconds.", timeout.getSeconds()));
        }
        return Optional.empty();
    }

    public <E extends NavigationEvent> void notifyObservers(E event) {
        Preconditions.checkNotNull(event);
        this.rpc.dispatch(event);
    }

    @Override
    public <E extends NavigationEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public <C extends NavigationCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((NavigationCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends NavigationCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends NavigationCallback> C remove(Class<C> callbackClass) {
        return (C)((NavigationCallback)this.rpc.remove(callbackClass));
    }
}

