/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class JsAccessibleMethod {
    private final Method method;

    JsAccessibleMethod(Method method) {
        this.method = method;
    }

    String name() {
        return this.method.getName();
    }

    boolean canAccept(List<JavaValue> params) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (params.size() != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaValue value = params.get(i);
            if (value.isConvertibleTo(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Nullable
    Object invoke(Object object, List<JavaValue> jsArgs) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] methodArgs = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            methodArgs[i] = jsArgs.get(i).toObject(parameterTypes[i]);
        }
        return this.method.invoke(object, methodArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsAccessibleMethod that = (JsAccessibleMethod)o;
        return this.method.getName().equals(that.method.getName()) && Arrays.equals(this.method.getParameterTypes(), that.method.getParameterTypes());
    }

    public int hashCode() {
        return Objects.hash(this.method.getName(), Arrays.hashCode(this.method.getParameterTypes()));
    }

    public String toString() {
        return this.method.toString();
    }
}

