/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Any;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.NewObservableHelper;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.event.internal.rpc.EventSubscription;
import com.teamdev.jxbrowser.internal.rpc.Service;
import com.teamdev.jxbrowser.internal.rpc.StreamData;
import com.teamdev.jxbrowser.internal.rpc.StreamMessage;
import com.teamdev.jxbrowser.internal.rpc.TextFormat;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.stream.Stream;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.logging.Logger;

public final class EventStream
extends Stream {
    private final NewObservableHelper observable = new NewObservableHelper();

    public EventStream(Service service, Descriptors.MethodDescriptor method, Message targetId, Connection connection) {
        super(service, method, targetId, connection);
    }

    public synchronized <T extends Event> SubscriptionImpl on(Observer<T> observer) {
        this.checkNotClosed();
        SubscriptionImpl subscription = this.observable.addObserver(observer);
        subscription.onUnsubscribe(() -> {
            EventStream eventStream = this;
            synchronized (eventStream) {
                if (!this.observable.hasSubscribers() && !this.interceptor().isPresent()) {
                    this.unsubscribe();
                    this.closeStream();
                }
            }
        });
        if (!this.isSubscribed()) {
            this.openStream();
            this.subscribe();
        }
        return subscription;
    }

    public <T extends Event> void dispatch(T event) {
        this.observable.notifyObservers(event);
    }

    @Override
    protected StreamMessage createSubscriptionRequest(boolean subscribe) {
        EventSubscription.Builder builder = EventSubscription.newBuilder();
        if (subscribe) {
            builder.setSubscribe(Any.pack(this.targetId()));
        } else {
            builder.setUnsubscribe(Any.pack(this.targetId()));
        }
        return StreamMessage.newBuilder().setBytes(builder.build().toByteString()).build();
    }

    @Override
    protected String convertRequestToString(Message message) {
        EventSubscription subscription = (EventSubscription)message;
        EventSubscription.ActionCase actionCase = subscription.getActionCase();
        if (actionCase == EventSubscription.ActionCase.SUBSCRIBE || actionCase == EventSubscription.ActionCase.UNSUBSCRIBE) {
            return String.format("stage: %1$s id: %2$s", actionCase.name(), TextFormat.shortDebugString(this.targetId()));
        }
        return "";
    }

    @Override
    protected void process(StreamData data) {
        if (this.isClosed()) {
            return;
        }
        switch (data.getStageCase()) {
            case SUBSCRIBE: {
                this.state.change(true);
                break;
            }
            case UNSUBSCRIBE: {
                this.state.change(false);
                break;
            }
            case MESSAGE: {
                try {
                    Message event = this.service().responsePrototype(this.method()).newBuilderForType().mergeFrom(data.getMessage().getBytes()).build();
                    Interceptor.Action action = this.interceptor().map(interceptor -> interceptor.intercept(event)).orElse(Interceptor.Action.PROCEED);
                    if (action != Interceptor.Action.PROCEED) break;
                    this.dispatch((Event)((Object)event));
                }
                catch (InvalidProtocolBufferException e) {
                    Logger.error("Failed to deserialize the proto message.", e);
                }
                break;
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.isSubscribed()) {
            this.resetInterceptor();
            this.observable.unsubscribeAll();
        }
        super.close();
    }
}

