/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.RpcChannel;
import com.teamdev.jxbrowser.deps.com.google.protobuf.RpcController;
import com.teamdev.jxbrowser.internal.RpcThreadImpl;
import com.teamdev.jxbrowser.internal.rpc.Id;
import com.teamdev.jxbrowser.internal.rpc.RequestData;
import com.teamdev.jxbrowser.internal.rpc.RpcLogging;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcRequestId;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;

public final class ServiceChannel
implements RpcChannel {
    private final Connection connection;

    ServiceChannel(Connection connection) {
        this.connection = connection;
    }

    public Connection connection() {
        return this.connection;
    }

    @Override
    public void callMethod(Descriptors.MethodDescriptor method, final RpcController controller, Message request, final Message responsePrototype, final com.teamdev.jxbrowser.deps.com.google.protobuf.RpcCallback<Message> done) {
        final RpcRequest rpcRequest = RpcRequest.newBuilder().setId(RpcRequestId.newBuilder().setValue(Id.generate()).build()).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setRequestData(RequestData.newBuilder().setSerializedMessage(request.toByteString()).setNested(RpcThreadImpl.forCurrentThread().isPresent()).build()).build();
        RpcLogging.logClientRequest(rpcRequest, request);
        this.connection.send(rpcRequest, new RpcCallback<RpcResponse>(){

            @Override
            public void onNext(RpcResponse rpcResponse) {
                try {
                    Message.Builder builder = responsePrototype.newBuilderForType().mergeFrom(rpcResponse.getResponseData().getSerializedMessage());
                    if (builder.isInitialized()) {
                        Message response = builder.build();
                        RpcLogging.logServerResponse(rpcResponse, rpcRequest, response);
                        done.run(response);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    controller.setFailed("Failed to parse response." + e.getMessage());
                    done.run(null);
                }
            }

            @Override
            public void onError(Throwable t) {
                controller.setFailed(t.getMessage());
                done.run(null);
            }
        });
    }
}

