/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.string.StringPreconditions;

public final class SystemProperties {
    public static final String LOGGING_LEVEL = "jxbrowser.logging.level";
    public static final String LOGGING_FILE = "jxbrowser.logging.file";
    public static final String CHROMIUM_DIR = "jxbrowser.chromium.dir";
    public static final String LICENSE_KEY = "jxbrowser.license.key";
    public static final String JS_ACCESSIBLE_OFF = "jxbrowser.jsaccessible.off";
    public static final String CHROMIUM_VERIFICATION_OFF = "jxbrowser.chromium.verification.off";
    public static final String DISABLE_FORK_EXTRACTION_PROPERTY = "jxbrowser.disable.fork.extraction";
    public static final String CRASH_DUMP_DIR = "jxbrowser.crash.dump.dir";
    public static final String NAVIGATION_TIMEOUT_IN_SECONDS = "jxbrowser.navigation.timeout.seconds";
    public static final String FORCE_DPI_AWARENESS = "jxbrowser.force.dpi.awareness";
    public static final String NESTED_UI_MESSAGE_LOOP_OFF = "jxbrowser.nested.ui.message.loop.off";
    public static final String JAVAFX_LEGACY_HANDLE = "jxbrowser.javafx.legacy.handle";
    public static final String SKIP_LINUX_DEPS_CHECK = "jxbrowser.linux.deps.check.off";
    public static final String USE_NATIVE_KEYBOARD_INPUT = "jxbrowser.use.native.keyboard.input";
    public static final String LINUX_TOUCH_SCREEN = "jxbrowser.linux.touch.screen";
    static final String NATIVE_VERIFICATION_DISABLED = "jxbrowser.native.verification.disabled";

    public static boolean hasProperty(String propertyName) {
        StringPreconditions.checkNotNullEmptyOrBlank(propertyName);
        return System.getProperties().containsKey(propertyName);
    }

    public static String get(String propertyName, String defaultValue) {
        return System.getProperty(propertyName, defaultValue);
    }

    public static int getAsInt(String propertyName, int defaultValue) {
        String strValue = System.getProperty(propertyName);
        if (strValue != null) {
            return Integer.parseInt(strValue);
        }
        return defaultValue;
    }

    private SystemProperties() {
    }
}

