/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.engine.ChromiumBinariesDeliveryException;
import com.teamdev.jxbrowser.internal.BinariesListing;
import com.teamdev.jxbrowser.internal.BinaryVerifier;
import com.teamdev.jxbrowser.internal.JavaBinaryVerifier;
import com.teamdev.jxbrowser.internal.NativeBinaryVerifier;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.nio.file.Path;
import java.util.List;

public final class BinariesIntegrity {
    private final Path chromiumDir;
    private final List<BinariesListing> listings;

    public BinariesIntegrity(List<BinariesListing> listings, Path chromiumDir) {
        this.listings = ImmutableList.copyOf(listings);
        this.chromiumDir = chromiumDir;
    }

    public void verifyOrThrow() {
        if (!this.verify()) {
            throw new ChromiumBinariesDeliveryException("Failed to check integrity of the Chromium binaries.");
        }
    }

    public boolean verify() {
        BinaryVerifier verifier;
        if (SystemProperties.hasProperty("jxbrowser.chromium.verification.off")) {
            Logger.debug("Skip checking binaries integrity, because it is explicitly disabled.");
            return true;
        }
        Logger.debug("Checking binaries integrity in {0}...", this.chromiumDir);
        if (BinariesIntegrity.isNativeVerificationEnabled()) {
            verifier = new NativeBinaryVerifier();
            try {
                return verifier.verify(this.chromiumDir, this.listings);
            }
            catch (Exception e) {
                Logger.debug("Checking binaries integrity... [FAIL]. Falling back to Java verifier...");
            }
        }
        verifier = new JavaBinaryVerifier();
        return verifier.verify(this.chromiumDir, this.listings);
    }

    private static boolean isNativeVerificationEnabled() {
        return Environment.isWindows() && !Environment.isArm() && !Boolean.getBoolean("jxbrowser.native.verification.disabled");
    }
}

