/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.frame.internal.convert.ArrayBufferValue;
import com.teamdev.jxbrowser.frame.internal.convert.ArrayValue;
import com.teamdev.jxbrowser.frame.internal.convert.BooleanValue;
import com.teamdev.jxbrowser.frame.internal.convert.FunctionValue;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.frame.internal.convert.MapValue;
import com.teamdev.jxbrowser.frame.internal.convert.NodeValue;
import com.teamdev.jxbrowser.frame.internal.convert.NullOrUndefinedValue;
import com.teamdev.jxbrowser.frame.internal.convert.NumberValue;
import com.teamdev.jxbrowser.frame.internal.convert.ObjectValue;
import com.teamdev.jxbrowser.frame.internal.convert.PromiseValue;
import com.teamdev.jxbrowser.frame.internal.convert.ProxyObjectValue;
import com.teamdev.jxbrowser.frame.internal.convert.SetValue;
import com.teamdev.jxbrowser.frame.internal.convert.StringValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.Map;

final class JavaValues {
    private static final Map<JsValue.ValueCase, JavaValueConstructor> constructors;

    static JavaValue create(JsValue jsValue) {
        Preconditions.checkArgument(constructors.containsKey(jsValue.getValueCase()));
        return constructors.get(jsValue.getValueCase()).newInstance(jsValue);
    }

    private JavaValues() {
    }

    static {
        ImmutableMap.Builder<JsValue.ValueCase, JavaValueConstructor> builder = ImmutableMap.builder();
        builder.put(JsValue.ValueCase.NUMBER_VALUE, NumberValue::new);
        builder.put(JsValue.ValueCase.STRING_VALUE, StringValue::new);
        builder.put(JsValue.ValueCase.BOOL_VALUE, BooleanValue::new);
        builder.put(JsValue.ValueCase.NODE_INFO, NodeValue::new);
        builder.put(JsValue.ValueCase.OBJECT_ID, ObjectValue::new);
        builder.put(JsValue.ValueCase.OBJECT_PROXY_ID, ProxyObjectValue::new);
        builder.put(JsValue.ValueCase.FUNCTION_ID, FunctionValue::new);
        builder.put(JsValue.ValueCase.PROMISE_ID, PromiseValue::new);
        builder.put(JsValue.ValueCase.ARRAY, ArrayValue::new);
        builder.put(JsValue.ValueCase.SET, SetValue::new);
        builder.put(JsValue.ValueCase.MAP, MapValue::new);
        builder.put(JsValue.ValueCase.ARRAY_BUFFER, ArrayBufferValue::new);
        builder.put(JsValue.ValueCase.NULL_OR_UNDEFINED, NullOrUndefinedValue::new);
        constructors = builder.build();
    }

    @FunctionalInterface
    static interface JavaValueConstructor {
        public JavaValue newInstance(JsValue var1);
    }
}

