/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.Document;
import com.teamdev.jxbrowser.dom.DocumentPosition;
import com.teamdev.jxbrowser.dom.Element;
import com.teamdev.jxbrowser.dom.Node;
import com.teamdev.jxbrowser.dom.NodeType;
import com.teamdev.jxbrowser.dom.XPathException;
import com.teamdev.jxbrowser.dom.XPathResult;
import com.teamdev.jxbrowser.dom.XPathResultType;
import com.teamdev.jxbrowser.dom.event.internal.EventTargetImpl;
import com.teamdev.jxbrowser.dom.internal.XPathResultImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.AppendChildRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.ClickRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.CloseNodeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.CompareDocumentPositionRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.DocumentPositionsValue;
import com.teamdev.jxbrowser.dom.internal.rpc.EvaluateRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.FrameNode;
import com.teamdev.jxbrowser.dom.internal.rpc.GetChildrenRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetDocumentRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetElementsByClassNameRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetElementsByCssSelectorRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetElementsByNameRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetElementsByTagNameRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetNextSiblingRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetNodeNameRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetNodeValueRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetParentRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetPreviousSiblingRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetTextContentRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetXPathRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.InsertChildRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfoList;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeStub;
import com.teamdev.jxbrowser.dom.internal.rpc.RemoveChildRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.ReplaceChildRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetNodeValueRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetTextContentRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathResponse;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class NodeImpl
extends EventTargetImpl
implements Node {
    private final List<XPathResultImpl> xPathResults = new ArrayList<XPathResultImpl>();
    private final ServiceConnectionImpl<NodeStub> rpc;

    public static NodeImpl newInstance(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        return new NodeImpl(connection, domContext, nodeInfo);
    }

    NodeImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<NodeStub>(nodeInfo.getNodeId(), connection, NodeStub::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            this.xPathResults.forEach(CloseableImpl::close);
            this.xPathResults.clear();
        }
        try {
            this.rpc.invoke(this.rpc.stub()::close, CloseNodeRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.domContext().onNodeClosed(this.nodeId());
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeClosed() {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            this.xPathResults.forEach(CloseableImpl::close);
            this.xPathResults.clear();
        }
        super.makeClosed();
    }

    @Override
    public final NodeType type() {
        this.checkNotClosed();
        return this.nodeInfo().getNodeType();
    }

    @Override
    public Document document() {
        this.checkNotClosed();
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return this.domContext().toNode((NodeInfo)this.rpc.invoke(this.rpc.stub()::getDocument, request), Document.class);
    }

    @Override
    public final String nodeName() {
        this.checkNotClosed();
        GetNodeNameRequest request = GetNodeNameRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getNodeName, request)).getValue();
    }

    @Override
    public final String nodeValue() {
        this.checkNotClosed();
        GetNodeValueRequest request = GetNodeValueRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getNodeValue, request)).getValue();
    }

    @Override
    public final void nodeValue(String value) {
        Preconditions.checkNotNull(value);
        this.checkNotClosed();
        SetNodeValueRequest request = SetNodeValueRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setNodeValue(value).build();
        this.rpc.invoke(this.rpc.stub()::setNodeValue, request);
    }

    @Override
    public final Optional<Node> parent() {
        this.checkNotClosed();
        GetParentRequest request = GetParentRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::getParent, request);
        return this.domContext().toOptionalNode(response);
    }

    @Override
    public final List<Node> children() {
        this.checkNotClosed();
        GetChildrenRequest request = GetChildrenRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getChildren, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList()));
    }

    @Override
    public final Optional<Node> nextSibling() {
        this.checkNotClosed();
        GetNextSiblingRequest request = GetNextSiblingRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::getNextSibling, request);
        return this.domContext().toOptionalNode(response);
    }

    @Override
    public final Optional<Node> previousSibling() {
        this.checkNotClosed();
        GetPreviousSiblingRequest request = GetPreviousSiblingRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::getPreviousSibling, request);
        return this.domContext().toOptionalNode(response);
    }

    @Override
    public final void click() {
        this.checkNotClosed();
        ClickRequest request = ClickRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        this.rpc.invoke(this.rpc.stub()::click, request);
    }

    @Override
    public final boolean insertChild(Node node, Node beforeNode) {
        Preconditions.checkNotNull(node);
        Preconditions.checkNotNull(beforeNode);
        this.checkNotClosed();
        InsertChildRequest request = InsertChildRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setInsertNodeId(Wrappers.unwrap(node, NodeImpl.class).nodeId()).setBeforeNodeId(Wrappers.unwrap(beforeNode, NodeImpl.class).nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::insertChild, request)).getValue();
    }

    @Override
    public final boolean replaceChild(Node newNode, Node oldNode) {
        Preconditions.checkNotNull(newNode);
        Preconditions.checkNotNull(oldNode);
        this.checkNotClosed();
        ReplaceChildRequest request = ReplaceChildRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setNewNodeId(Wrappers.unwrap(newNode, NodeImpl.class).nodeId()).setOldNodeId(Wrappers.unwrap(oldNode, NodeImpl.class).nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::replaceChild, request)).getValue();
    }

    @Override
    public final boolean removeChild(Node childNode) {
        Preconditions.checkNotNull(childNode);
        this.checkNotClosed();
        RemoveChildRequest request = RemoveChildRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setChildNodeId(Wrappers.unwrap(childNode, NodeImpl.class).nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::removeChild, request)).getValue();
    }

    @Override
    public final boolean appendChild(Node childNode) {
        Preconditions.checkNotNull(childNode);
        this.checkNotClosed();
        AppendChildRequest request = AppendChildRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setChildNodeId(Wrappers.unwrap(childNode, NodeImpl.class).nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::appendChild, request)).getValue();
    }

    @Override
    public final String textContent() {
        this.checkNotClosed();
        GetTextContentRequest request = GetTextContentRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getTextContent, request)).getValue();
    }

    @Override
    public final void textContent(String textContent) {
        Preconditions.checkNotNull(textContent);
        this.checkNotClosed();
        SetTextContentRequest request = SetTextContentRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setTextContent(textContent).build();
        this.rpc.invoke(this.rpc.stub()::setTextContent, request);
    }

    @Override
    public final XPathResult evaluate(String expression) {
        return this.evaluate(expression, XPathResultType.ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XPathResult evaluate(String expression, XPathResultType type) {
        StringPreconditions.checkNotNullEmptyOrBlank(expression);
        Preconditions.checkNotNull(type);
        this.checkNotClosed();
        EvaluateRequest request = EvaluateRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setExpression(expression).setType(type).build();
        XPathResponse response = (XPathResponse)this.rpc.invoke(this.rpc.stub()::evaluate, request);
        if (response.getValueCase() == XPathResponse.ValueCase.EVALUATION_RESULT) {
            XPathResultImpl result = new XPathResultImpl(this.rpc.connection(), this.domContext(), response.getEvaluationResult());
            NodeImpl nodeImpl = this;
            synchronized (nodeImpl) {
                this.xPathResults.add(result);
            }
            return result;
        }
        throw new XPathException(response.getErrorMessage());
    }

    @Override
    public final List<Element> findElementsByClassName(String className) {
        this.checkSearchParam(className);
        this.checkNotClosed();
        GetElementsByClassNameRequest request = GetElementsByClassNameRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setClassName(className).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getElementsByClassName, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), Element.class));
    }

    @Override
    public final List<Element> findElementsByCssSelector(String cssSelector) {
        this.checkSearchParam(cssSelector);
        this.checkNotClosed();
        GetElementsByCssSelectorRequest request = GetElementsByCssSelectorRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setCssSelector(cssSelector).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getElementsByCssSelector, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), Element.class));
    }

    @Override
    public final List<Element> findElementsById(String id) {
        this.checkSearchParam(id);
        this.checkNotClosed();
        GetElementsByCssSelectorRequest request = GetElementsByCssSelectorRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setCssSelector("[id='" + id + "']").build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getElementsByCssSelector, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), Element.class));
    }

    @Override
    public final List<Element> findElementsByName(String name) {
        this.checkSearchParam(name);
        this.checkNotClosed();
        GetElementsByNameRequest request = GetElementsByNameRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setName(name).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getElementsByName, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), Element.class));
    }

    @Override
    public final List<Element> findElementsByTagName(String tagName) {
        this.checkSearchParam(tagName);
        this.checkNotClosed();
        GetElementsByTagNameRequest request = GetElementsByTagNameRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setTagName(tagName).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getElementsByTagName, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), Element.class));
    }

    @Override
    public final Optional<Element> findElementByClassName(String className) {
        this.checkSearchParam(className);
        return this.findElementsByClassName(className).stream().findFirst();
    }

    @Override
    public final Optional<Element> findElementByCssSelector(String cssSelector) {
        this.checkSearchParam(cssSelector);
        return this.findElementsByCssSelector(cssSelector).stream().findFirst();
    }

    @Override
    public final Optional<Element> findElementById(String id) {
        this.checkSearchParam(id);
        return this.findElementsById(id).stream().findFirst();
    }

    @Override
    public final Optional<Element> findElementByName(String name) {
        this.checkSearchParam(name);
        return this.findElementsByName(name).stream().findFirst();
    }

    @Override
    public final Optional<Element> findElementByTagName(String tagName) {
        this.checkSearchParam(tagName);
        return this.findElementsByTagName(tagName).stream().findFirst();
    }

    private void checkSearchParam(String param) {
        Preconditions.checkNotNull(param);
        Preconditions.checkArgument(!param.trim().isEmpty());
    }

    @Override
    public String xPath() {
        this.checkNotClosed();
        GetXPathRequest request = GetXPathRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getXPath, request)).getValue();
    }

    @Override
    public Set<DocumentPosition> compareDocumentPosition(Node otherNode) {
        this.checkNotClosed();
        Preconditions.checkNotNull(otherNode);
        FrameNode frameNode = FrameNode.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        FrameNode otherFrameNode = FrameNode.newBuilder().setFrameId(Wrappers.unwrap(otherNode, NodeImpl.class).frameId()).setNodeId(Wrappers.unwrap(otherNode, NodeImpl.class).nodeId()).build();
        CompareDocumentPositionRequest request = CompareDocumentPositionRequest.newBuilder().setFrameNode(frameNode).setOtherFrameNode(otherFrameNode).build();
        List<DocumentPosition> result = ((DocumentPositionsValue)this.rpc.invoke(this.rpc.stub()::compareDocumentPosition, request)).getValueList();
        return result.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(result));
    }
}

