/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.FormControlElement;
import com.teamdev.jxbrowser.dom.FormElement;
import com.teamdev.jxbrowser.dom.NodeType;
import com.teamdev.jxbrowser.dom.internal.ElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.FormControlElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.GetFormRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetValueRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsEnabledRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.SetValueRequest;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import java.util.Optional;

public class FormControlElementImpl
extends ElementImpl
implements FormControlElement {
    private final ServiceConnectionImpl<FormControlElementStub> rpc;

    FormControlElementImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<FormControlElementStub>(nodeInfo, connection, FormControlElementStub::new);
    }

    @Override
    public final boolean isEnabled() {
        this.checkNotClosed();
        IsEnabledRequest request = IsEnabledRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isEnabled, request)).getValue();
    }

    @Override
    public final String value() {
        this.checkNotClosed();
        GetValueRequest request = GetValueRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getValue, request)).getValue();
    }

    @Override
    public final void value(String value) {
        Preconditions.checkNotNull(value);
        this.checkNotClosed();
        SetValueRequest request = SetValueRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setValue(value).build();
        this.rpc.invoke(this.rpc.stub()::setValue, request);
    }

    @Override
    public final Optional<FormElement> form() {
        this.checkNotClosed();
        GetFormRequest request = GetFormRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::getForm, request);
        if (response.getNodeType() == NodeType.ELEMENT_NODE) {
            FormElement element = this.domContext().toNode(response, FormElement.class);
            return Optional.of(element);
        }
        return Optional.empty();
    }
}

