/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.math;

import com.teamdev.jxbrowser.deps.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.teamdev.jxbrowser.deps.org.checkerframework.checker.nullness.qual.Nullable;

@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(@Nullable String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(role).length()).append(role).append(" (").append(x).append(") must be > 0").toString());
        }
        return x;
    }

    static int checkNonNegative(@Nullable String role, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(role).length()).append(role).append(" (").append(x).append(") must be >= 0").toString());
        }
        return x;
    }

    static double checkNonNegative(@Nullable String role, double x) {
        if (!(x >= 0.0)) {
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(role).length()).append(role).append(" (").append(x).append(") must be >= 0").toString());
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }
}

