/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.collect;

import com.teamdev.jxbrowser.deps.com.google.common.collect.BiMap;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableBiMapFauxverideShim;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.deps.com.google.common.collect.Maps;
import com.teamdev.jxbrowser.deps.com.google.common.collect.Ordering;
import com.teamdev.jxbrowser.deps.com.google.common.collect.RegularImmutableBiMap;
import com.teamdev.jxbrowser.deps.com.google.common.collect.SingletonImmutableBiMap;
import com.teamdev.jxbrowser.deps.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;

public abstract class ImmutableBiMap<K, V>
extends ImmutableBiMapFauxverideShim<K, V>
implements BiMap<K, V> {
    public static <K, V> ImmutableBiMap<K, V> of() {
        return RegularImmutableBiMap.EMPTY;
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1) {
        return new SingletonImmutableBiMap<K, V>(k1, v1);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableBiMap() {
    }

    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSet<V> values() {
        return this.inverse().keySet();
    }

    @Override
    final ImmutableSet<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    return ImmutableBiMap.of(this.entries[0].getKey(), this.entries[0].getValue());
                }
            }
            if (this.valueComparator != null) {
                if (this.entriesUsed) {
                    this.entries = Arrays.copyOf(this.entries, this.size);
                }
                Arrays.sort(this.entries, 0, this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }
    }
}

