/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.callback.internal;

import com.teamdev.jxbrowser.callback.Callback;
import java.util.Optional;

final class TypeInspector {
    private final Class<? extends Callback> callbackClass;

    private TypeInspector(Class<? extends Callback> callbackClass) {
        this.callbackClass = callbackClass;
    }

    TypeInspector(Callback callback) {
        this(callback.getClass());
    }

    Class<? extends Callback> closestCallbackInterface() {
        for (Class<? extends Callback> clazz = this.callbackClass; clazz != null; clazz = clazz.getSuperclass()) {
            Optional<Class<?>> iface = TypeInspector.implementedCallbackInterface(clazz);
            if (!iface.isPresent()) continue;
            return iface.get();
        }
        throw TypeInspector.unreachable();
    }

    private static Optional<Class<?>> implementedCallbackInterface(Class<?> callbackClass) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = callbackClass.getInterfaces()) {
            if (!Callback.class.isAssignableFrom(iface)) continue;
            return Optional.of(iface);
        }
        return Optional.empty();
    }

    private static IllegalStateException unreachable() {
        throw new IllegalStateException("This line is not logically reachable.");
    }
}

