/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Locale;

public class EncoderUtil {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    static final byte[] BASE64_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte BASE64_PAD = 61;
    private static final BitSet Q_REGULAR_CHARS = EncoderUtil.initChars("=_?");
    private static final BitSet Q_RESTRICTED_CHARS = EncoderUtil.initChars("=_?\"#$%&'(),.:;<>@[\\]^`{|}~");
    private static final int MAX_USED_CHARACTERS = 50;
    private static final String ENC_WORD_PREFIX = "=?";
    private static final String ENC_WORD_SUFFIX = "?=";
    private static final int ENCODED_WORD_MAX_LENGTH = 75;
    private static final BitSet TOKEN_CHARS = EncoderUtil.initChars("()<>@,;:\\\"/[]?=");
    private static final BitSet ATEXT_CHARS = EncoderUtil.initChars("()<>@.,;:\\\"[]");

    private static BitSet initChars(String specials) {
        BitSet bs = new BitSet(128);
        for (int ch = 33; ch < 127; ch = (int)((char)(ch + 1))) {
            if (specials.indexOf(ch) != -1) continue;
            bs.set(ch);
        }
        return bs;
    }

    private EncoderUtil() {
    }

    public static String encodeAddressDisplayName(String displayName) {
        if (EncoderUtil.isAtomPhrase(displayName)) {
            return displayName;
        }
        if (EncoderUtil.hasToBeEncoded(displayName, 0)) {
            return EncoderUtil.encodeEncodedWord(displayName, Usage.WORD_ENTITY);
        }
        return EncoderUtil.quote(displayName);
    }

    public static String encodeAddressLocalPart(String localPart) {
        if (EncoderUtil.isDotAtomText(localPart)) {
            return localPart;
        }
        return EncoderUtil.quote(localPart);
    }

    public static String encodeHeaderParameter(String name, String value) {
        name = name.toLowerCase(Locale.US);
        if (EncoderUtil.isToken(value)) {
            return name + "=" + value;
        }
        return name + "=" + EncoderUtil.quote(value);
    }

    public static String encodeIfNecessary(String text, Usage usage, int usedCharacters) {
        if (EncoderUtil.hasToBeEncoded(text, usedCharacters)) {
            return EncoderUtil.encodeEncodedWord(text, usage, usedCharacters);
        }
        return text;
    }

    public static boolean hasToBeEncoded(String text, int usedCharacters) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (usedCharacters < 0 || usedCharacters > 50) {
            throw new IllegalArgumentException();
        }
        int nonWhiteSpaceCount = usedCharacters;
        for (int idx = 0; idx < text.length(); ++idx) {
            char ch = text.charAt(idx);
            if (ch == '\t' || ch == ' ') {
                nonWhiteSpaceCount = 0;
                continue;
            }
            if (++nonWhiteSpaceCount > 77) {
                return true;
            }
            if (ch >= ' ' && ch < '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String encodeEncodedWord(String text, Usage usage) {
        return EncoderUtil.encodeEncodedWord(text, usage, 0, null, null);
    }

    public static String encodeEncodedWord(String text, Usage usage, int usedCharacters) {
        return EncoderUtil.encodeEncodedWord(text, usage, usedCharacters, null, null);
    }

    public static String encodeEncodedWord(String text, Usage usage, int usedCharacters, Charset charset, Encoding encoding) {
        String mimeCharset;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (usedCharacters < 0 || usedCharacters > 50) {
            throw new IllegalArgumentException();
        }
        if (charset == null) {
            charset = EncoderUtil.determineCharset(text);
        }
        if ((mimeCharset = charset.name()) == null) {
            throw new IllegalArgumentException("Unsupported charset");
        }
        byte[] bytes = EncoderUtil.encode(text, charset);
        if (encoding == null) {
            encoding = EncoderUtil.determineEncoding(bytes, usage);
        }
        if (encoding == Encoding.B) {
            String prefix = ENC_WORD_PREFIX + mimeCharset + "?B?";
            return EncoderUtil.encodeB(prefix, text, usedCharacters, charset, bytes);
        }
        String prefix = ENC_WORD_PREFIX + mimeCharset + "?Q?";
        return EncoderUtil.encodeQ(prefix, text, usage, usedCharacters, charset, bytes);
    }

    public static String encodeB(byte[] bytes) {
        int data;
        int idx;
        StringBuilder sb = new StringBuilder();
        int end = bytes.length;
        for (idx = 0; idx < end - 2; idx += 3) {
            data = (bytes[idx] & 0xFF) << 16 | (bytes[idx + 1] & 0xFF) << 8 | bytes[idx + 2] & 0xFF;
            sb.append((char)BASE64_TABLE[data >> 18 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 12 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 6 & 0x3F]);
            sb.append((char)BASE64_TABLE[data & 0x3F]);
        }
        if (idx == end - 2) {
            data = (bytes[idx] & 0xFF) << 16 | (bytes[idx + 1] & 0xFF) << 8;
            sb.append((char)BASE64_TABLE[data >> 18 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 12 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 6 & 0x3F]);
            sb.append('=');
        } else if (idx == end - 1) {
            data = (bytes[idx] & 0xFF) << 16;
            sb.append((char)BASE64_TABLE[data >> 18 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 12 & 0x3F]);
            sb.append('=');
            sb.append('=');
        }
        return sb.toString();
    }

    public static String encodeQ(byte[] bytes, Usage usage) {
        BitSet qChars = usage == Usage.TEXT_TOKEN ? Q_REGULAR_CHARS : Q_RESTRICTED_CHARS;
        StringBuilder sb = new StringBuilder();
        int end = bytes.length;
        for (int idx = 0; idx < end; ++idx) {
            int v = bytes[idx] & 0xFF;
            if (v == 32) {
                sb.append('_');
                continue;
            }
            if (!qChars.get(v)) {
                sb.append('=');
                sb.append(EncoderUtil.hexDigit(v >>> 4));
                sb.append(EncoderUtil.hexDigit(v & 0xF));
                continue;
            }
            sb.append((char)v);
        }
        return sb.toString();
    }

    public static boolean isToken(String str) {
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            if (TOKEN_CHARS.get(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAtomPhrase(String str) {
        boolean containsAText = false;
        int length = str.length();
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            if (ATEXT_CHARS.get(ch)) {
                containsAText = true;
                continue;
            }
            if (!Character.isWhitespace(ch)) continue;
            return false;
        }
        return containsAText;
    }

    private static boolean isDotAtomText(String str) {
        int prev = 46;
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            if (ch == '.' ? prev == 46 || idx == length - 1 : !ATEXT_CHARS.get(ch)) {
                return false;
            }
            prev = ch;
        }
        return true;
    }

    private static String quote(String str) {
        String escaped = str.replaceAll("[\\\\\"]", "\\\\$0");
        return "\"" + escaped + "\"";
    }

    private static String encodeB(String prefix, String text, int usedCharacters, Charset charset, byte[] bytes) {
        int encodedLength = EncoderUtil.bEncodedLength(bytes);
        int totalLength = prefix.length() + encodedLength + ENC_WORD_SUFFIX.length();
        if (totalLength <= 75 - usedCharacters) {
            return prefix + EncoderUtil.encodeB(bytes) + ENC_WORD_SUFFIX;
        }
        int splitOffset = text.offsetByCodePoints(text.length() / 2, -1);
        String part1 = text.substring(0, splitOffset);
        byte[] bytes1 = EncoderUtil.encode(part1, charset);
        String word1 = EncoderUtil.encodeB(prefix, part1, usedCharacters, charset, bytes1);
        String part2 = text.substring(splitOffset);
        byte[] bytes2 = EncoderUtil.encode(part2, charset);
        String word2 = EncoderUtil.encodeB(prefix, part2, 0, charset, bytes2);
        return word1 + " " + word2;
    }

    private static int bEncodedLength(byte[] bytes) {
        return (bytes.length + 2) / 3 * 4;
    }

    private static String encodeQ(String prefix, String text, Usage usage, int usedCharacters, Charset charset, byte[] bytes) {
        int encodedLength = EncoderUtil.qEncodedLength(bytes, usage);
        int totalLength = prefix.length() + encodedLength + ENC_WORD_SUFFIX.length();
        if (totalLength <= 75 - usedCharacters) {
            return prefix + EncoderUtil.encodeQ(bytes, usage) + ENC_WORD_SUFFIX;
        }
        int splitOffset = text.offsetByCodePoints(text.length() / 2, -1);
        String part1 = text.substring(0, splitOffset);
        byte[] bytes1 = EncoderUtil.encode(part1, charset);
        String word1 = EncoderUtil.encodeQ(prefix, part1, usage, usedCharacters, charset, bytes1);
        String part2 = text.substring(splitOffset);
        byte[] bytes2 = EncoderUtil.encode(part2, charset);
        String word2 = EncoderUtil.encodeQ(prefix, part2, usage, 0, charset, bytes2);
        return word1 + " " + word2;
    }

    private static int qEncodedLength(byte[] bytes, Usage usage) {
        BitSet qChars = usage == Usage.TEXT_TOKEN ? Q_REGULAR_CHARS : Q_RESTRICTED_CHARS;
        int count = 0;
        for (int idx = 0; idx < bytes.length; ++idx) {
            int v = bytes[idx] & 0xFF;
            if (v == 32) {
                ++count;
                continue;
            }
            if (!qChars.get(v)) {
                count += 3;
                continue;
            }
            ++count;
        }
        return count;
    }

    private static byte[] encode(String text, Charset charset) {
        ByteBuffer buffer = charset.encode(text);
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    private static Charset determineCharset(String text) {
        boolean ascii = true;
        int len = text.length();
        for (int index = 0; index < len; ++index) {
            char ch = text.charAt(index);
            if (ch > '\u00ff') {
                return Charset.forName("UTF-8");
            }
            if (ch <= '\u007f') continue;
            ascii = false;
        }
        return ascii ? Charset.forName("US-ASCII") : Charset.forName("ISO-8859-1");
    }

    private static Encoding determineEncoding(byte[] bytes, Usage usage) {
        if (bytes.length == 0) {
            return Encoding.Q;
        }
        BitSet qChars = usage == Usage.TEXT_TOKEN ? Q_REGULAR_CHARS : Q_RESTRICTED_CHARS;
        int qEncoded = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            if (v == 32 || qChars.get(v)) continue;
            ++qEncoded;
        }
        int percentage = qEncoded * 100 / bytes.length;
        return percentage > 30 ? Encoding.B : Encoding.Q;
    }

    private static char hexDigit(int i) {
        return i < 10 ? (char)(i + 48) : (char)(i - 10 + 65);
    }

    public static enum Usage {
        TEXT_TOKEN,
        WORD_ENTITY;

    }

    public static enum Encoding {
        B,
        Q;

    }
}

