/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BookUtils {
    static Properties parseRule(String wikiText, String tempalateName, int fromIndex) {
        int start = BookUtils.findTemplate(wikiText, tempalateName, fromIndex);
        if (start > 0) {
            int length = wikiText.length();
            int braces = 2;
            block4: for (int end = start; end < length; ++end) {
                switch (wikiText.charAt(end)) {
                    case '{': {
                        ++braces;
                        continue block4;
                    }
                    case '}': {
                        if (--braces != 0) continue block4;
                        return BookUtils.parseRule(wikiText, start, end - 1);
                    }
                }
            }
        }
        return null;
    }

    static Properties parseRule(String wikiText, int idxStart, int idxEnd) {
        Properties props = new Properties();
        int idxName = 1;
        int bracket = 0;
        int valueStart = idxStart;
        while (idxStart < idxEnd) {
            char ch = wikiText.charAt(idxStart);
            switch (ch) {
                case '[': {
                    ++bracket;
                    break;
                }
                case ']': {
                    --bracket;
                    break;
                }
                case '|': {
                    if (bracket != 0) break;
                    String value = wikiText.substring(valueStart, idxStart).trim();
                    int idx = value.indexOf(61);
                    if (idx > 0) {
                        String name = value.substring(0, idx);
                        value = value.substring(idx + 1);
                        props.setProperty(name.trim(), value.trim());
                    } else {
                        props.setProperty(Integer.toString(idxName++), value.trim());
                    }
                    valueStart = idxStart + 1;
                }
            }
            ++idxStart;
        }
        String value = wikiText.substring(valueStart, idxEnd).trim();
        int idx = value.indexOf(61);
        if (idx > 0) {
            String name = value.substring(0, idx);
            value = value.substring(idx + 1);
            props.setProperty(name.trim(), value.trim());
        } else {
            props.setProperty(Integer.toString(idxName++), value.trim());
        }
        return props;
    }

    static int findTemplate(String wikiText, String tempalateName, int fromIndex) {
        Pattern pattern = Pattern.compile("\\{\\{\\s*\\Q" + tempalateName.replace(" ", "\\E\\s+\\Q") + "\\E\\s*\\|");
        Matcher matcher = pattern.matcher(wikiText);
        if (matcher.find(fromIndex)) {
            return matcher.end();
        }
        return -1;
    }

    public static int calcDiff(String word1, String word2) {
        int diff = 0;
        int j = 0;
        for (int i = 0; i < word1.length(); ++i) {
            char ch2;
            char ch1 = word1.charAt(i);
            if (word2.length() <= j) {
                ++diff;
                continue;
            }
            if (ch1 == (ch2 = word2.charAt(j++))) continue;
            ++diff;
            if (word2.length() > j && word2.charAt(j) == ch1) {
                ++j;
                continue;
            }
            if (word1.length() <= i + 1 || word1.charAt(i + 1) != ch2) continue;
            ++i;
        }
        return diff += word2.length() - j;
    }
}

