/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookUtils;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BookGenerator_de
extends BookGenerator {
    public BookGenerator_de() {
        this.addWord("Ihnen");
        this.addWord("Ihrer");
        this.addWord("Ihre");
        this.addWord("Ihres");
        this.addWord("Ihrem");
        this.addWord("Ihren");
        this.addWord("Sie");
        this.addWord("Du");
    }

    @Override
    protected boolean isValidWord(String word) {
        if (super.isValidWord(word)) {
            return true;
        }
        return word.endsWith("(Deklination)") || word.endsWith("(Konjugation)") || word.equals("Wiktionary:Wunschliste");
    }

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        wikiText = this.removeHtmlFormating(wikiText);
        if (word.equals("Wiktionary:Wunschliste")) {
            this.addLinkWords(word, wikiText, "Wunschliste");
            return false;
        }
        int idxGerman = wikiText.indexOf("{{Sprache|Deutsch}}");
        if (idxGerman < 0 || word.endsWith("(Deklination)") || word.endsWith("(Konjugation)")) {
            Properties props = BookUtils.parseRule(wikiText, "Deklinationsseite Adjektiv", 0);
            if (props != null) {
                this.addDeklinationAdjektiv(props);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb unregelm\u00e4\u00dfig", 0);
            if (props != null) {
                this.addKonjugationVerbUnregular(props);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach untrennbar", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachUntrennbar(props, false);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach untrennbar reflexiv", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachUntrennbar(props, true);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach trennbar", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachTrennbar(props, false);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach trennbar reflexiv", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachTrennbar(props, true);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach doppelt trennbar", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachDoppeltTrennbar(props);
                return false;
            }
            return false;
        }
        do {
            String chapter = this.getChapter(wikiText, idxGerman);
            this.searchFlexion(word, chapter);
            idxGerman = wikiText.indexOf(chapter) + chapter.length();
        } while ((idxGerman = wikiText.indexOf("{{Sprache|Deutsch}}", idxGerman)) > 0);
        return true;
    }

    private final void searchFlexion(String word, String wikiText) {
        int lastIdx;
        int idx = wikiText.indexOf("{{Wortart|Verb|Deutsch}}");
        while (idx > 0) {
            String table = this.getTable(wikiText, "Verb-Tabelle", idx);
            if (table.length() > 0 && this.searchWordAndAdd(word, table, "Gegenwart_ich=", 0)) {
                this.searchWordAndAdd(word, table, "Gegenwart_du=", 0);
                this.searchWordAndAdd(word, table, "Gegenwart_er, sie, es=", 0);
                this.searchWordAndAdd(word, table, "1.Vergangenheit_ich=", 0);
                this.searchWordAndAdd(word, table, "Partizip II=", 0);
                this.searchWordAndAdd(word, table, "Konjunktiv II_ich=", 0);
                this.searchWordAndAdd(word, table, "Befehl_du=", 0);
                this.searchWordAndAdd(word, table, "Befehl_ihr=", 0);
            }
            lastIdx = idx + 1;
            idx = wikiText.indexOf("{{Wortart|Verb|Deutsch}}", lastIdx);
        }
        idx = wikiText.indexOf("{{Wortart|Substantiv}}");
        if (idx < 0) {
            idx = wikiText.indexOf("{{Wortart|Substantiv|Deutsch}}");
        }
        while (idx > 0) {
            String chapter = this.getChapter(wikiText, idx);
            if (!this.addDeklinationSubstTable(chapter, 0, word)) {
                // empty if block
            }
            if ((idx = wikiText.indexOf("{{Wortart|Substantiv}}", lastIdx = idx + 1)) >= 0) continue;
            idx = wikiText.indexOf("{{Wortart|Substantiv|Deutsch}}", lastIdx);
        }
        idx = wikiText.indexOf("{{Wortart|Adjektiv|Deutsch}}");
        while (idx > 0) {
            Properties props = BookUtils.parseRule(wikiText, "Deutsch Adjektiv \u00dcbersicht", idx);
            if (props != null) {
                String grundform = props.getProperty("Positiv");
                this.addFormatedWordPhrase(word, "Positiv", grundform);
                this.addFormatedWordPhrase(word, "Komparativ", props.getProperty("Komparativ"));
                this.addFormatedWordPhrase(word, "Superlativ", props.getProperty("Superlativ"));
                if (grundform == null || !super.isValidWord(grundform)) {
                    grundform = word;
                }
                if (!grundform.endsWith("e")) {
                    this.addDeklinationAdjektiv(grundform);
                }
            }
            lastIdx = idx + 1;
            idx = wikiText.indexOf("{{Wortart|Adjektiv|Deutsch}}", lastIdx);
        }
        if (wikiText.indexOf("{{Wortart|Partizip I|Deutsch}}") >= 0) {
            this.addDeklinationAdjektiv(word);
        }
        if (wikiText.indexOf("{{Wortart|Partizip II|Deutsch}}") >= 0) {
            this.addDeklinationAdjektiv(word);
        }
        if (wikiText.indexOf("{{Wortart|Indefinitpronomen|Deutsch}}") >= 0) {
            this.addIndefinitpronomen(word, wikiText);
        }
        this.searchExtendsWords(word, wikiText, "{{Synonyme}}");
        this.searchExtendsWords(word, wikiText, "{{Unterbegriffe}}");
        this.searchExtendsWords(word, wikiText, "{{Abgeleitete Begriffe}}");
    }

    private String getChapter(String wikiText, int headerIdx) {
        int prefixSize;
        int startIdx = wikiText.lastIndexOf(10, headerIdx) + 1;
        int endIdx = wikiText.indexOf(10, headerIdx);
        if (endIdx == -1) {
            return wikiText.substring(startIdx);
        }
        String header = wikiText.substring(startIdx, endIdx).trim();
        for (prefixSize = 0; header.length() > prefixSize && header.charAt(prefixSize) == '='; ++prefixSize) {
        }
        if (prefixSize == 0) {
            return wikiText.substring(startIdx);
        }
        String marker = header.substring(0, prefixSize);
        if (!header.endsWith(marker)) {
            return wikiText.substring(startIdx);
        }
        Pattern pattern = Pattern.compile("^" + marker + "[^=].*[^=]" + marker + "\\s*$", 8);
        Matcher matcher = pattern.matcher(wikiText);
        if (matcher.find(endIdx)) {
            String chapter = wikiText.substring(startIdx, matcher.start()).trim();
            if (header.equals(chapter)) {
                return wikiText.substring(startIdx);
            }
            return chapter;
        }
        return wikiText.substring(startIdx);
    }

    private String getTable(String wikiText, String tableName, int fromIndex) {
        int start = wikiText.indexOf("{{" + tableName, fromIndex);
        if (start > 0) {
            int length = wikiText.length();
            int braces = 0;
            block4: for (int end = start; end < length; ++end) {
                switch (wikiText.charAt(end)) {
                    case '{': {
                        ++braces;
                        continue block4;
                    }
                    case '}': {
                        if (--braces != 0) continue block4;
                        return wikiText.substring(start, end + 1);
                    }
                }
            }
        }
        return "";
    }

    private final boolean searchWordAndAdd(String baseWord, String wikiText, String marker, int fromIndex) {
        int idx1 = wikiText.indexOf(marker, fromIndex);
        if (idx1 > 0) {
            int idx2 = this.indexOf(wikiText, new char[]{'|', '<', '}', '{'}, idx1 += marker.length());
            if (idx2 > 0) {
                String word = wikiText.substring(idx1, idx2).trim();
                this.addFormatedWordPhrase(baseWord, marker, word);
                return true;
            }
            System.out.println("End not found for marker '" + marker + "' for base word '" + baseWord + "'");
        } else {
            System.out.println("Marker '" + marker + "' was not found for base word '" + baseWord + "'");
        }
        return false;
    }

    private boolean searchExtendsWords(String baseWord, String wikiText, String marker) {
        int idx1 = wikiText.indexOf(marker);
        if (idx1 >= 0) {
            int idx2 = this.indexOf(wikiText, new char[]{'{', '='}, idx1 += marker.length());
            if (idx2 < 0) {
                idx2 = wikiText.length();
            }
            String extendsWords = wikiText.substring(idx1, idx2);
            this.addLinkWords(baseWord, extendsWords, marker);
            return true;
        }
        return false;
    }

    private void addLinkWords(String baseWord, String wikiText, String marker) {
        int idx3 = wikiText.indexOf("[[");
        while (idx3 > 0) {
            int idx4 = wikiText.indexOf("]]", idx3);
            if (idx4 > 0) {
                if (idx3 + 2 < idx4) {
                    String word = wikiText.substring(idx3 + 2, idx4);
                    if (word.startsWith("WikiSaurus:")) {
                        word = word.substring(11).trim();
                    }
                    if (word.startsWith("Thesaurus:")) {
                        word = word.substring(10).trim();
                    }
                    if (word.indexOf(124) > 0) {
                        word = word.substring(0, word.indexOf(124));
                    }
                    if (!this.addWordPhrase(word)) {
                        System.out.println("Invalid Extend Word '" + word + "' for marker '" + marker + "' for base word '" + baseWord + "'");
                    }
                }
                idx3 = wikiText.indexOf("[[", idx4);
                continue;
            }
            idx3 = -1;
        }
    }

    private final void addFormatedWordPhrase(String baseWord, String key, String phrase) {
        if (phrase == null) {
            return;
        }
        if (phrase.endsWith("!") || phrase.endsWith("\u2019")) {
            phrase = phrase.substring(0, phrase.length() - 1);
        }
        if (phrase.length() <= 1) {
            return;
        }
        if (phrase.equals("{{fehlend}}") || phrase.equals("---") || phrase.equals("--") || phrase.equals("{{center")) {
            return;
        }
        int idx3 = phrase.indexOf("(");
        int idx4 = phrase.indexOf(")", idx3);
        if (idx3 >= 0 && idx4 > 0) {
            String word3;
            String word1 = phrase.substring(0, idx3);
            String word2 = phrase.substring(idx4 + 1);
            String string = word3 = word1.length() + word2.length() > 0 ? word1 + word2 : phrase.substring(idx3 + 1, idx4);
            if (this.addWordPhrase(word3)) {
                this.addWordPhrase(word1 + phrase.substring(idx3 + 1, idx4) + word2);
                return;
            }
            System.out.println("Invalid Word '" + phrase + "' for marker '" + key + "' for base word '" + baseWord + "'");
        } else {
            if (this.addWordPhrase(phrase)) {
                return;
            }
            System.out.println("Invalid Word '" + phrase + "' for marker '" + key + "' for base word '" + baseWord + "'");
        }
    }

    private final boolean addWordPhrase(String phrase) {
        boolean isValid = true;
        int index = phrase.indexOf("[e]");
        if (index > 0 && Character.isLetter(phrase.charAt(index - 1))) {
            for (int i = 0; i < 2; ++i) {
                this.addWordPhrase(phrase.substring(0, index) + (i == 0 ? "e" : "") + phrase.substring(index + 3));
            }
        } else {
            String[] words = phrase.split("(\\s|/|,|!)+");
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                if (word.length() <= 0) continue;
                if (super.isValidWord(word)) {
                    this.addWord(word);
                    continue;
                }
                isValid = false;
            }
        }
        return isValid;
    }

    private void addDeklinationAdjektiv(Properties props) {
        this.addDeklinationAdjektiv(props.getProperty("Positiv-Stamm"));
        this.addDeklinationAdjektiv(props.getProperty("Komparativ-Stamm"));
        this.addDeklinationAdjektiv(props.getProperty("Superlativ-Stamm"));
    }

    private void addDeklinationAdjektiv(String wordStamm) {
        if (wordStamm != null && super.isValidWord(wordStamm)) {
            this.addWord(wordStamm + "e");
            this.addWord(wordStamm + "er");
            this.addWord(wordStamm + "es");
            this.addWord(wordStamm + "en");
            this.addWord(wordStamm + "em");
        }
    }

    private void addIndefinitpronomen(String word, String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "Pronomina-Tabelle", 0);
        if (props != null) {
            Set<Map.Entry<Object, Object>> entries = props.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                this.addFormatedWordPhrase(word, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private boolean addDeklinationSubstTable(String wikiText, int fromIndex, String baseWord) {
        Properties props = BookUtils.parseRule(wikiText, "Deutsch Substantiv \u00dcbersicht", fromIndex);
        if (props != null) {
            if (props.remove("Bild") != null || props.remove("Bild 1") != null) {
                props.remove("1");
                props.remove("2");
                props.remove("3");
            }
            if (props.remove("Bild 2") != null) {
                props.remove("4");
                props.remove("5");
                props.remove("6");
            }
            if (props.remove("Bild 3") != null) {
                props.remove("7");
                props.remove("8");
                props.remove("9");
            }
            if (props.remove("Bild 4") != null) {
                props.remove("10");
                props.remove("11");
                props.remove("12");
            }
            if (props.remove("Bild 5") != null) {
                props.remove("13");
                props.remove("14");
                props.remove("15");
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String word = (String)entry.getValue();
                this.addFormatedWordPhrase(baseWord, (String)entry.getKey(), word);
            }
            return true;
        }
        return false;
    }

    private String removeHtmlFormating(String word) {
        int idx1 = word.indexOf(60);
        while (idx1 >= 0) {
            int idx2 = word.indexOf(62, idx1);
            if (idx2 > 0) {
                String html = word.substring(idx1 + 1, idx2).toLowerCase().trim();
                html = html.equals("br") || html.equals("p") || html.startsWith("br ") || html.startsWith("p ") ? " " : "";
                word = word.substring(0, idx1) + html + word.substring(idx2 + 1);
                idx1 = word.indexOf(60);
                continue;
            }
            idx1 = -1;
        }
        for (String blank : new String[]{"&nbsp;", "&#32;"}) {
            idx1 = word.indexOf(blank);
            while (idx1 >= 0) {
                word = word.substring(0, idx1) + " " + word.substring(idx1 + blank.length());
                idx1 = word.indexOf(blank);
            }
        }
        return word;
    }

    private void addKonjugationVerbUnregular(Properties props) {
        String vorsilbe = props.getProperty("1", "");
        String stamm = props.getProperty("2");
        this.addWord(vorsilbe + stamm + "end");
        if ("ja".equals(props.getProperty("gerund"))) {
            String gerund = vorsilbe.length() > 0 ? vorsilbe + "zu" + stamm : stamm;
            this.addWord(gerund + "nder");
            this.addWord(gerund + "nde");
            this.addWord(gerund + "ndes");
            this.addWord(gerund + "nden");
            this.addWord(gerund + "ndem");
        }
        if (stamm != null && super.isValidWord(stamm)) {
            this.addWord(stamm + "e");
            this.addWord(stamm + "st");
            this.addWord(stamm + "t");
            this.addWord(stamm + "en");
            this.addWord(stamm + "est");
            this.addWord(stamm + "et");
            if (vorsilbe.length() > 0) {
                this.addWord(vorsilbe + stamm);
                this.addWord(vorsilbe + stamm + "e");
                this.addWord(vorsilbe + stamm + "st");
                this.addWord(vorsilbe + stamm + "t");
                this.addWord(vorsilbe + stamm + "en");
                this.addWord(vorsilbe + stamm + "est");
                this.addWord(vorsilbe + stamm + "et");
            }
        }
        if ((stamm = props.getProperty("3")) != null && super.isValidWord(stamm)) {
            this.addWord(stamm);
            this.addWord(stamm + "st");
            this.addWord(stamm + "en");
            this.addWord(stamm + "t");
            if (vorsilbe.length() > 0) {
                this.addWord(vorsilbe + stamm);
                this.addWord(vorsilbe + stamm + "st");
                this.addWord(vorsilbe + stamm + "en");
                this.addWord(vorsilbe + stamm + "t");
            }
        }
        if ((stamm = props.getProperty("4")) != null && super.isValidWord(stamm)) {
            this.addWord(stamm + "e");
            this.addWord(stamm + "est");
            this.addWord(stamm + "en");
            this.addWord(stamm + "et");
            if (vorsilbe.length() > 0) {
                this.addWord(vorsilbe + stamm);
                this.addWord(vorsilbe + stamm + "est");
                this.addWord(vorsilbe + stamm + "en");
                this.addWord(vorsilbe + stamm + "et");
            }
        }
        if ((stamm = props.getProperty("5")) != null && super.isValidWord(stamm)) {
            this.addWord(vorsilbe + stamm);
            this.addDeklinationAdjektiv(vorsilbe + stamm);
        }
    }

    private void addKonjugationVerbSchwachUntrennbar(Properties props, boolean reflexiv) {
        String stamm4;
        String partizip2 = props.getProperty("6");
        if (partizip2 != null && super.isValidWord(partizip2)) {
            this.addWord(partizip2);
            this.addDeklinationAdjektiv(partizip2);
        }
        if (super.isValidWord(stamm4 = props.getProperty("1") + props.getProperty("2") + props.getProperty("3") + props.getProperty("4"))) {
            this.addWord(stamm4 + "nd");
            if (!reflexiv) {
                this.addWord(stamm4 + "nder");
                this.addWord(stamm4 + "nde");
                this.addWord(stamm4 + "ndes");
                this.addWord(stamm4 + "nden");
                this.addWord(stamm4 + "ndem");
            }
            String stamm3 = props.getProperty("1") + props.getProperty("2") + props.getProperty("3");
            this.addWord(stamm4);
            this.addWord(stamm3 + "st");
            this.addWord(stamm3 + "t");
            this.addWord(stamm3 + "est");
            this.addWord(stamm3 + "e");
            this.addWord(stamm3 + "et");
            this.addWord(stamm3 + "te");
            this.addWord(stamm3 + "test");
            this.addWord(stamm3 + "ten");
            this.addWord(stamm3 + "tet");
        }
    }

    private void addKonjugationVerbSchwachTrennbar(Properties props, boolean reflexiv) {
        String partizip2 = props.getProperty("7");
        if (partizip2 != null && super.isValidWord(partizip2)) {
            this.addWord(partizip2);
            this.addDeklinationAdjektiv(partizip2);
        }
        String vorsilbe = props.getProperty("1");
        String stamm4 = props.getProperty("2") + props.getProperty("3") + props.getProperty("4");
        String stamm5 = stamm4 + props.getProperty("5");
        String all4 = vorsilbe + stamm4;
        String all5 = vorsilbe + stamm5;
        this.addWord(vorsilbe + "zu" + stamm5 + "n");
        this.addWord(all5 + "nd");
        if (!reflexiv) {
            this.addWord(vorsilbe + "zu" + stamm5 + "nder");
            this.addWord(vorsilbe + "zu" + stamm5 + "nde");
            this.addWord(vorsilbe + "zu" + stamm5 + "ndes");
            this.addWord(vorsilbe + "zu" + stamm5 + "nden");
            this.addWord(vorsilbe + "zu" + stamm5 + "ndem");
        }
        this.addWord(stamm5);
        this.addWord(stamm4 + "st");
        this.addWord(stamm4 + "t");
        this.addWord(stamm4 + "est");
        this.addWord(stamm4 + "e");
        this.addWord(stamm5 + "n");
        this.addWord(stamm4 + "et");
        this.addWord(all5);
        this.addWord(all4 + "st");
        this.addWord(all4 + "t");
        this.addWord(all4 + "est");
        this.addWord(all4 + "e");
        this.addWord(all5 + "n");
        this.addWord(all4 + "et");
        this.addWord(stamm4 + "te");
        this.addWord(stamm4 + "test");
        this.addWord(stamm4 + "ten");
        this.addWord(stamm4 + "tet");
        this.addWord(all4 + "te");
        this.addWord(all4 + "test");
        this.addWord(all4 + "ten");
        this.addWord(all4 + "tet");
    }

    private void addKonjugationVerbSchwachDoppeltTrennbar(Properties props) {
        String partizip2 = props.getProperty("8");
        if (partizip2 != null && super.isValidWord(partizip2)) {
            this.addWord(partizip2);
            this.addDeklinationAdjektiv(partizip2);
        }
        String vorsilbe = props.getProperty("1") + props.getProperty("2");
        String stamm5 = props.getProperty("3") + props.getProperty("4") + props.getProperty("5");
        String stamm6 = stamm5 + props.getProperty("6");
        String all5 = vorsilbe + stamm5;
        String all6 = vorsilbe + stamm6;
        this.addWord(vorsilbe + "zu" + stamm6 + "n");
        this.addWord(all6 + "nd");
        this.addWord(vorsilbe + "zu" + stamm6 + "nder");
        this.addWord(vorsilbe + "zu" + stamm6 + "nde");
        this.addWord(vorsilbe + "zu" + stamm6 + "ndes");
        this.addWord(vorsilbe + "zu" + stamm6 + "nden");
        this.addWord(vorsilbe + "zu" + stamm6 + "ndem");
        this.addWord(stamm6);
        this.addWord(stamm5 + "st");
        this.addWord(stamm5 + "t");
        this.addWord(stamm5 + "est");
        this.addWord(stamm5 + "e");
        this.addWord(stamm6 + "n");
        this.addWord(stamm5 + "et");
        this.addWord(all6);
        this.addWord(all5 + "st");
        this.addWord(all5 + "t");
        this.addWord(all5 + "est");
        this.addWord(all5 + "e");
        this.addWord(all6 + "n");
        this.addWord(all5 + "et");
        this.addWord(stamm5 + "te");
        this.addWord(stamm5 + "test");
        this.addWord(stamm5 + "ten");
        this.addWord(stamm5 + "tet");
        this.addWord(all5 + "te");
        this.addWord(all5 + "test");
        this.addWord(all5 + "ten");
        this.addWord(all5 + "tet");
    }
}

