/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.SpellChecker;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.WordIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;

public class FileUserDictionary
implements UserDictionaryProvider {
    protected final String fileBase;
    protected File file;

    public FileUserDictionary() {
        this("");
    }

    public FileUserDictionary(String fileBase) {
        if (fileBase == null) {
            fileBase = "";
        }
        fileBase = fileBase.trim();
        if ((fileBase = fileBase.replace('\\', '/')).length() > 0 && !fileBase.endsWith("/")) {
            fileBase = fileBase + "/";
        }
        this.fileBase = fileBase;
    }

    @Override
    public void addWord(String word) {
        try {
            FileOutputStream output = new FileOutputStream(this.file, true);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF8");
            if (this.file.length() > 0L) {
                writer.write("\n");
            }
            writer.write(word);
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            SpellChecker.getMessageHandler().handleException(ex);
        }
    }

    @Override
    public Iterator<String> getWords(Locale locale) {
        this.file = new File(this.fileBase + "UserDictionary_" + locale + ".txt");
        try {
            FileInputStream input = new FileInputStream(this.file);
            return new WordIterator(input, "UTF8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void setUserWords(String wordList) {
        try {
            FileOutputStream output = new FileOutputStream(this.file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF8");
            writer.write(wordList);
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            SpellChecker.getMessageHandler().handleException(ex);
        }
    }
}

