/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.SpellChecker;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;

class DictionaryEditDialog
extends JDialog {
    private final JList list;
    private final JButton delete;
    private boolean isModify;

    DictionaryEditDialog(JDialog parent) {
        super(parent, Utils.getResource("userDictionary"), true);
        this.setDefaultCloseOperation(2);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        DefaultListModel data = new DefaultListModel();
        this.loadWordList(data);
        this.list = new JList(data);
        content.add((Component)new JScrollPane(this.list), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.delete = Utils.getButton("delete");
        content.add((Component)this.delete, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 8, 8, 8), 0, 0));
        DeleteAction deleteAction = new DeleteAction();
        this.delete.addActionListener(deleteAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(127, 0, false), "DELETE");
        this.getRootPane().getActionMap().put("DELETE", deleteAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionaryEditDialog.this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        String title = this.getTitle();
        int titleWidth = this.getFontMetrics(this.getFont()).stringWidth(title) + 80;
        if (dim.width < titleWidth) {
            dim.width = titleWidth;
        }
        return dim;
    }

    private void loadWordList(DefaultListModel data) {
        Iterator<String> userWords;
        UserDictionaryProvider provider = SpellChecker.getUserDictionaryProvider();
        if (provider != null && (userWords = provider.getWords(SpellChecker.getCurrentLocale())) != null) {
            ArrayList<String> wordList = new ArrayList<String>();
            while (userWords.hasNext()) {
                String word = userWords.next();
                if (word == null || word.length() <= 1) continue;
                wordList.add(word);
            }
            Collections.sort(wordList, Collator.getInstance());
            for (String str : wordList) {
                data.addElement(str);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isModify) {
            Component[] comps;
            UserDictionaryProvider provider = SpellChecker.getUserDictionaryProvider();
            if (provider != null) {
                ListModel model = this.list.getModel();
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < model.getSize(); ++i) {
                    if (builder.length() != 0) {
                        builder.append('\n');
                    }
                    builder.append(model.getElementAt(i));
                }
                provider.setUserWords(builder.toString());
            }
            JMenu menu = SpellChecker.createLanguagesMenu(null);
            for (Component comp : comps = menu.getMenuComponents()) {
                JRadioButtonMenuItem item;
                if (!(comp instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)comp).isSelected()) continue;
                item.doClick();
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = DictionaryEditDialog.this.list.getSelectedIndices();
            Arrays.sort(selected);
            for (int i = selected.length - 1; i >= 0; --i) {
                ((DefaultListModel)DictionaryEditDialog.this.list.getModel()).remove(selected[i]);
                DictionaryEditDialog.this.isModify = true;
            }
        }
    }
}

