/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AutoSpellChecker;
import com.inet.jortho.Dictionary;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.JTextComponent;

public class AddWordAction
extends AbstractAction {
    private String word;
    private JTextComponent jText;

    public AddWordAction(JTextComponent jText, String word) {
        this(jText, word, Utils.getResource("addToDictionary"));
    }

    public AddWordAction(JTextComponent jText, String word, String label) {
        super(label);
        this.word = word;
        this.jText = jText;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        UserDictionaryProvider provider = SpellChecker.getUserDictionaryProvider();
        if (provider != null) {
            provider.addWord(this.word);
        }
        Dictionary dictionary = SpellChecker.getCurrentDictionary();
        dictionary.add(this.word);
        dictionary.trimToSize();
        AutoSpellChecker.refresh(this.jText);
    }
}

