/*
 * Decompiled with CFR 0.152.
 */
package pixy.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.image.ImageType;
import pixy.io.IOUtils;
import pixy.io.PeekHeadInputStream;
import pixy.io.RandomAccessInputStream;
import pixy.meta.adobe.ImageResourceID;
import pixy.meta.adobe._8BIM;

public class MetadataUtils {
    private static byte[] BM = new byte[]{66, 77};
    private static byte[] GIF = new byte[]{71, 73, 70, 56};
    private static byte[] PNG = new byte[]{-119, 80, 78, 71};
    private static byte[] TIFF_II = new byte[]{73, 73, 42, 0};
    private static byte[] TIFF_MM = new byte[]{77, 77, 0, 42};
    private static byte[] JPG = new byte[]{-1, -40, -1};
    private static byte[] PCX = new byte[]{10};
    private static byte[] JPG2000 = new byte[]{0, 0, 0, 12};
    public static final int IMAGE_MAGIC_NUMBER_LEN = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataUtils.class);

    public static ImageType guessImageType(PeekHeadInputStream peekHeadInputStream) throws IOException {
        byte[] byArray = peekHeadInputStream.peek(4);
        ImageType imageType = MetadataUtils.guessImageType(byArray);
        return imageType;
    }

    public static ImageType guessImageType(byte[] byArray) {
        ImageType imageType = ImageType.UNKNOWN;
        if (Arrays.equals(byArray, TIFF_II) || Arrays.equals(byArray, TIFF_MM)) {
            imageType = ImageType.TIFF;
        } else if (Arrays.equals(byArray, PNG)) {
            imageType = ImageType.PNG;
        } else if (Arrays.equals(byArray, GIF)) {
            imageType = ImageType.GIF;
        } else if (byArray[0] == JPG[0] && byArray[1] == JPG[1] && byArray[2] == JPG[2]) {
            imageType = ImageType.JPG;
        } else if (byArray[0] == BM[0] && byArray[1] == BM[1]) {
            imageType = ImageType.BMP;
        } else if (byArray[0] == PCX[0]) {
            imageType = ImageType.PCX;
        } else if (Arrays.equals(byArray, JPG2000)) {
            imageType = ImageType.JPG2000;
        } else if (byArray[1] == 0 || byArray[1] == 1) {
            switch (byArray[2]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 32: 
                case 33: {
                    imageType = ImageType.TGA;
                }
            }
        } else {
            LOGGER.error("Unknown format!");
        }
        return imageType;
    }

    public static BufferedImage createThumbnail(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = null;
        if (inputStream instanceof RandomAccessInputStream) {
            RandomAccessInputStream randomAccessInputStream = (RandomAccessInputStream)inputStream;
            long l = randomAccessInputStream.getStreamPointer();
            randomAccessInputStream.seek(l);
            bufferedImage = ImageIO.read(randomAccessInputStream);
            randomAccessInputStream.seek(l);
        } else {
            bufferedImage = ImageIO.read(inputStream);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = 160;
        int n4 = 120;
        if (n < n2) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (n < n3) {
            n3 = n;
        }
        if (n2 < n4) {
            n4 = n2;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, n3, n4, null);
        return bufferedImage2;
    }

    public static _8BIM createThumbnail8BIM(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetadataUtils.saveAsJPEG(bufferedImage, byteArrayOutputStream, 100);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        IOUtils.writeIntMM(byteArrayOutputStream, 1);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        IOUtils.writeIntMM(byteArrayOutputStream, n);
        IOUtils.writeIntMM(byteArrayOutputStream, n2);
        int n3 = 24;
        int n4 = 1;
        int n5 = (n * n3 + 31) / 32 * 4;
        IOUtils.writeIntMM(byteArrayOutputStream, n5);
        IOUtils.writeIntMM(byteArrayOutputStream, n5 * n2 * n4);
        IOUtils.writeIntMM(byteArrayOutputStream, byArray.length);
        IOUtils.writeShortMM(byteArrayOutputStream, n3);
        IOUtils.writeShortMM(byteArrayOutputStream, n4);
        byteArrayOutputStream.write(byArray);
        _8BIM _8BIM2 = new _8BIM(ImageResourceID.THUMBNAIL_RESOURCE_PS5, "thumbnail", byteArrayOutputStream.toByteArray());
        return _8BIM2;
    }

    public static int[] toARGB(byte[] byArray) {
        int[] nArray = new int[byArray.length / 3];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0xFF000000 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        }
        return nArray;
    }

    public static int[] bgr2ARGB(byte[] byArray) {
        int[] nArray = new int[byArray.length / 3];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0xFF000000 | byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16;
        }
        return nArray;
    }

    public static void saveAsJPEG(BufferedImage bufferedImage, OutputStream outputStream, int n) throws IOException {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("Quality out of bounds!");
        }
        float f = (float)n / 100.0f;
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(f);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
    }

    private MetadataUtils() {
    }
}

