/*
 * Decompiled with CFR 0.152.
 */
package pixy.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static void delete(String string) {
        FileUtils.delete(string, "");
    }

    public static void delete(String string, String string2) {
        File file = new File(string);
        FileUtils.delete(file, string2);
    }

    public static String getNameWithoutExtension(File file) {
        return file.getName().replaceFirst("[.][^.]+$", "");
    }

    public static void delete(File file, String string) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    FileUtils.delete(file2, string);
                }
            } else {
                String string2 = file.getAbsolutePath();
                if (string != null && string2.endsWith(string)) {
                    boolean bl = file.delete();
                    if (bl) {
                        LOGGER.info("File {} deleted", (Object)file.getAbsolutePath());
                    } else {
                        LOGGER.info("File {} was not deleted, unknown reason", (Object)file.getAbsolutePath());
                    }
                }
            }
        } else {
            LOGGER.info("File {} doesn't exist", (Object)file.getAbsolutePath());
        }
    }

    public static List<String> list(String string) {
        return FileUtils.list(string, "");
    }

    public static List<String> list(String string, String string2) {
        File file = new File(string);
        return FileUtils.list(file, string2);
    }

    public static List<String> list(File file, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                FileUtils.list(file2, string);
            }
        } else {
            String string2 = "";
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                LOGGER.error("IOException", (Throwable)iOException);
            }
            if (string != null && string2.endsWith(string)) {
                arrayList.add(string2);
                LOGGER.info("File: {}", (Object)string2);
            }
        }
        return arrayList;
    }

    public static File[] listFilesMatching(File file, String string) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory.");
        }
        final Pattern pattern = Pattern.compile(string);
        return file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return pattern.matcher(file.getName()).matches();
            }
        });
    }

    private FileUtils() {
    }
}

