/*
 * Decompiled with CFR 0.152.
 */
package pixy.string;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pixy.string.StringUtils;

public class XMLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtils.class);

    public static void addChild(Node node, Node node2) {
        node.appendChild(node2);
    }

    public static void addText(Document document, Node node, String string) {
        node.appendChild(document.createTextNode(string));
    }

    public static Document createDocumentNode() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return documentBuilder.newDocument();
    }

    public static Node createElement(Document document, String string) {
        return document.createElement(string);
    }

    public static Document createXML(byte[] byArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    public static Document createXML(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        Document document = null;
        InputSource inputSource = new InputSource(new StringReader(string));
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    public static String escapeXML(String string) {
        Iterator<Character> iterator = StringUtils.stringIterator(string);
        StringBuilder stringBuilder = new StringBuilder();
        block7: while (iterator.hasNext()) {
            Character c = iterator.next();
            switch (c.charValue()) {
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getAttribute(Document document, String string, String string2) {
        if (document == null || string == null || string2 == null) {
            return "";
        }
        NodeList nodeList = document.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string3 = ((Element)nodeList.item(i)).getAttribute(string2);
            if (StringUtils.isNullOrEmpty(string3)) continue;
            return string3;
        }
        return "";
    }

    public static void insertLeadingPI(Document document, String string, String string2) {
        Element element = document.getDocumentElement();
        ProcessingInstruction processingInstruction = document.createProcessingInstruction(string, string2);
        element.getParentNode().insertBefore(processingInstruction, element);
    }

    public static void insertTrailingPI(Document document, String string, String string2) {
        Element element = document.getDocumentElement();
        ProcessingInstruction processingInstruction = document.createProcessingInstruction(string, string2);
        element.getParentNode().appendChild(processingInstruction);
    }

    public static void printNode(Node node, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        XMLUtils.print(node, string, stringBuilder);
        LOGGER.info("\n{}", (Object)stringBuilder);
    }

    private static void print(Node node, String string, StringBuilder stringBuilder) {
        if (node != null) {
            if (string == null) {
                string = "";
            }
            switch (node.getNodeType()) {
                case 9: {
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        XMLUtils.print(node2, string, stringBuilder);
                    }
                    break;
                }
                case 10: {
                    DocumentType documentType = (DocumentType)node;
                    stringBuilder.append("<!DOCTYPE " + documentType.getName() + ">\n");
                    break;
                }
                case 1: {
                    Node node3;
                    Element element = (Element)node;
                    stringBuilder.append(string + "<" + element.getTagName());
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        node3 = namedNodeMap.item(i);
                        stringBuilder.append(" " + node3.getNodeName() + "='" + XMLUtils.escapeXML(node3.getNodeValue()) + "'");
                    }
                    stringBuilder.append(">\n");
                    String string2 = string + "    ";
                    for (node3 = element.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        XMLUtils.print(node3, string2, stringBuilder);
                    }
                    stringBuilder.append(string + "</" + element.getTagName() + ">\n");
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    String string3 = text.getData().trim();
                    if (string3 == null || string3.length() <= 0) break;
                    stringBuilder.append(string + XMLUtils.escapeXML(string3) + "\n");
                    break;
                }
                case 7: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    stringBuilder.append(string + "<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>\n");
                    break;
                }
                case 5: {
                    stringBuilder.append(string + "&" + node.getNodeName() + ";\n");
                    break;
                }
                case 4: {
                    CDATASection cDATASection = (CDATASection)node;
                    stringBuilder.append(string + "<![CDATA[" + cDATASection.getData() + "]]>\n");
                    break;
                }
                case 8: {
                    Comment comment = (Comment)node;
                    stringBuilder.append(string + "<!--" + comment.getData() + "-->\n");
                    break;
                }
                default: {
                    LOGGER.error("Unknown node: " + node.getClass().getName());
                }
            }
        }
    }

    public static String removeAttribute(Document document, String string, String string2) {
        NodeList nodeList = document.getElementsByTagName(string);
        String string3 = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string4 = element.getAttribute(string2);
            if (StringUtils.isNullOrEmpty(string4)) continue;
            string3 = string4;
            element.removeAttribute(string2);
            break;
        }
        return string3;
    }

    public static byte[] serializeToByteArray(Document document) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException("Unable to serialize XML document");
        }
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        String string = document.getInputEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        transformer.setOutputProperty("encoding", string);
        DOMSource dOMSource = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Unable to serialize XML document");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String serializeToStringLS(Document document) throws IOException {
        return XMLUtils.serializeToStringLS(document, document);
    }

    public static String serializeToStringLS(Document document, Node node) throws IOException {
        String string = document.getInputEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        return XMLUtils.serializeToStringLS(document, node, string);
    }

    public static String serializeToStringLS(Document document, Node node, String string) throws IOException {
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setEncoding(string);
        StringWriter stringWriter = new StringWriter();
        lSOutput.setCharacterStream(stringWriter);
        lSSerializer.write(node, lSOutput);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static String serializeToString(Document document) throws IOException {
        String string = document.getInputEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        return XMLUtils.serializeToString(document, string);
    }

    public static String serializeToString(Node node, String string) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException("Unable to serialize XML document");
        }
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", string);
        DOMSource dOMSource = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Unable to serialize XML document");
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static void showXML(Document document) {
        XMLUtils.printNode(document, "");
    }
}

