/*
 * Decompiled with CFR 0.152.
 */
package pixy.string;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char[] HEXES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String byteArrayToHexString(byte[] byArray) {
        return StringUtils.byteArrayToHexString(byArray, 0, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "[]";
        }
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int n3 = n + Math.min(n2, byArray.length);
        if (n3 > byArray.length) {
            n2 = byArray.length - n;
        }
        StringBuilder stringBuilder = new StringBuilder(5 * n2 + 2);
        stringBuilder.append("[");
        for (int i = n; i < n3; ++i) {
            stringBuilder.append("0x").append(HEXES[(byArray[i] & 0xF0) >> 4]).append(HEXES[byArray[i] & 0xF]).append(",");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (n3 < byArray.length) {
            stringBuilder.append(" ...");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String byteToHexString(byte by) {
        return String.format("0x%02X ", by);
    }

    public static String capitalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("\\b(\\w)(\\w*)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            if (Character.isUpperCase(matcher.group().charAt(0))) continue;
            matcher.appendReplacement(stringBuffer, matcher.group(1).toUpperCase() + "$2");
        }
        return matcher.appendTail(stringBuffer).toString();
    }

    public static String capitalizeFully(String string) {
        return StringUtils.capitalize(string.toLowerCase());
    }

    public static String concat(Iterable<? extends CharSequence> iterable, String string) {
        int n = 0;
        int n2 = string.length();
        for (CharSequence charSequence2 : iterable) {
            if (StringUtils.isNullOrEmpty(charSequence2)) continue;
            n += charSequence2.length() + n2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (CharSequence n3 : iterable) {
            if (StringUtils.isNullOrEmpty(n3)) continue;
            stringBuilder.append(n3);
            stringBuilder.append(string);
        }
        int n3 = stringBuilder.lastIndexOf(string);
        stringBuilder.delete(n3, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
        stringBuilder.append(string);
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String concat(String string, String ... stringArray) {
        StringBuilder stringBuilder = string != null ? new StringBuilder(string) : new StringBuilder();
        for (String string2 : stringArray) {
            if (StringUtils.isNullOrEmpty(string2)) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static <T extends CharSequence> String concat(T[] TArray, String string) {
        int n = 0;
        int n2 = string.length();
        for (T t : TArray) {
            if (StringUtils.isNullOrEmpty(t)) continue;
            n += t.length() + n2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (T t : TArray) {
            if (StringUtils.isNullOrEmpty(t)) continue;
            stringBuilder.append((CharSequence)t);
            stringBuilder.append(string);
        }
        int n3 = stringBuilder.lastIndexOf(string);
        stringBuilder.delete(n3, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static boolean contains(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static String decimalToDMS(double d) {
        double d2 = d % 1.0;
        int n = (int)d;
        d = d2 * 60.0;
        d2 = d % 1.0;
        int n2 = (int)d;
        d = d2 * 60.0;
        int n3 = (int)d;
        String string = n + 176 + n2 + "'" + n3 + "\"";
        return string;
    }

    public double DMSToDecimal(String string, double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 1.0;
        if (string == "W" || string == "S") {
            d5 = -1.0;
        }
        d4 = d5 * (Math.floor(d) + Math.floor(d2) / 60.0 + d3 / 3600.0);
        return d4;
    }

    public static String encodeURL(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
        }
        return string2;
    }

    public static String escapeHTML(String string) {
        Iterator<Character> iterator = StringUtils.stringIterator(string);
        StringBuilder stringBuilder = new StringBuilder();
        block35: while (iterator.hasNext()) {
            Character c = iterator.next();
            switch (c.charValue()) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block35;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block35;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block35;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block35;
                }
                case '\t': {
                    stringBuilder.append("&#009;");
                    continue block35;
                }
                case '!': {
                    stringBuilder.append("&#033;");
                    continue block35;
                }
                case '#': {
                    stringBuilder.append("&#035;");
                    continue block35;
                }
                case '$': {
                    stringBuilder.append("&#036;");
                    continue block35;
                }
                case '%': {
                    stringBuilder.append("&#037;");
                    continue block35;
                }
                case '\'': {
                    stringBuilder.append("&#039;");
                    continue block35;
                }
                case '(': {
                    stringBuilder.append("&#040;");
                    continue block35;
                }
                case ')': {
                    stringBuilder.append("&#041;");
                    continue block35;
                }
                case '*': {
                    stringBuilder.append("&#042;");
                    continue block35;
                }
                case '+': {
                    stringBuilder.append("&#043;");
                    continue block35;
                }
                case ',': {
                    stringBuilder.append("&#044;");
                    continue block35;
                }
                case '-': {
                    stringBuilder.append("&#045;");
                    continue block35;
                }
                case '.': {
                    stringBuilder.append("&#046;");
                    continue block35;
                }
                case '/': {
                    stringBuilder.append("&#047;");
                    continue block35;
                }
                case ':': {
                    stringBuilder.append("&#058;");
                    continue block35;
                }
                case ';': {
                    stringBuilder.append("&#059;");
                    continue block35;
                }
                case '=': {
                    stringBuilder.append("&#061;");
                    continue block35;
                }
                case '?': {
                    stringBuilder.append("&#063;");
                    continue block35;
                }
                case '@': {
                    stringBuilder.append("&#064;");
                    continue block35;
                }
                case '[': {
                    stringBuilder.append("&#091;");
                    continue block35;
                }
                case '\\': {
                    stringBuilder.append("&#092;");
                    continue block35;
                }
                case ']': {
                    stringBuilder.append("&#093;");
                    continue block35;
                }
                case '^': {
                    stringBuilder.append("&#094;");
                    continue block35;
                }
                case '_': {
                    stringBuilder.append("&#095;");
                    continue block35;
                }
                case '`': {
                    stringBuilder.append("&#096;");
                    continue block35;
                }
                case '{': {
                    stringBuilder.append("&#123;");
                    continue block35;
                }
                case '|': {
                    stringBuilder.append("&#124;");
                    continue block35;
                }
                case '}': {
                    stringBuilder.append("&#125;");
                    continue block35;
                }
                case '~': {
                    stringBuilder.append("&#126;");
                    continue block35;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escapeQueryStringAmp(String string) {
        return string.replace("&", "&amp;");
    }

    public static String escapeRegex(String string) {
        Iterator<Character> iterator = StringUtils.stringIterator(string);
        StringBuilder stringBuilder = new StringBuilder();
        block4: while (iterator.hasNext()) {
            Character c = iterator.next();
            switch (c.charValue()) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '^': 
                case '{': {
                    stringBuilder.append("\\").append(c);
                    continue block4;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block4;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String generateMD5(byte[] byArray) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("No such algorithm: MD5");
        }
        return StringUtils.toHexString(messageDigest.digest(byArray));
    }

    public static String intToHexString(int n) {
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append("0x");
        stringBuilder.append(HEXES[n & 0xF]);
        stringBuilder.append(HEXES[(n & 0xF0) >>> 4]);
        stringBuilder.append(HEXES[(n & 0xF00) >>> 8]);
        stringBuilder.append(HEXES[(n & 0xF000) >>> 12]);
        stringBuilder.append(HEXES[(n & 0xF0000) >>> 16]);
        stringBuilder.append(HEXES[(n & 0xF00000) >>> 20]);
        stringBuilder.append(HEXES[(n & 0xF000000) >>> 24]);
        stringBuilder.append(HEXES[(n & 0xF0000000) >>> 28]);
        return stringBuilder.toString();
    }

    public static String intToHexStringMM(int n) {
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append("0x");
        stringBuilder.append(HEXES[(n & 0xF0000000) >>> 28]);
        stringBuilder.append(HEXES[(n & 0xF000000) >>> 24]);
        stringBuilder.append(HEXES[(n & 0xF00000) >>> 20]);
        stringBuilder.append(HEXES[(n & 0xF0000) >>> 16]);
        stringBuilder.append(HEXES[(n & 0xF000) >>> 12]);
        stringBuilder.append(HEXES[(n & 0xF00) >>> 8]);
        stringBuilder.append(HEXES[(n & 0xF0) >>> 4]);
        stringBuilder.append(HEXES[n & 0xF]);
        return stringBuilder.toString();
    }

    public static boolean isInCharset(String string, String string2) {
        Charset charset = null;
        try {
            charset = Charset.forName(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        String string3 = new String(string.getBytes(charset), charset);
        return string3.equals(string);
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static String longArrayToString(int[] nArray, boolean bl) {
        return StringUtils.longArrayToString(nArray, 0, nArray.length, bl);
    }

    public static String longArrayToString(int[] nArray, int n, int n2, boolean bl) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return "[]";
        }
        if (n < 0 || n >= nArray.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int n3 = n + Math.min(n2, nArray.length);
        if (n3 > nArray.length) {
            n2 = nArray.length - n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = n; i < n3; ++i) {
            if (bl) {
                stringBuilder.append((long)nArray[i] & 0xFFFFFFFFL);
            } else {
                stringBuilder.append(nArray[i]);
            }
            stringBuilder.append(",");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (n3 < nArray.length) {
            stringBuilder.append(" ...");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static boolean parseBoolean(String string) {
        return Boolean.parseBoolean(string);
    }

    public static byte parseByte(String string) {
        return Byte.parseByte(string);
    }

    public static byte parseByte(String string, int n) {
        return Byte.parseByte(string, n);
    }

    public static double parseDouble(String string) {
        return Double.parseDouble(string);
    }

    public static float parseFloat(String string) {
        return Float.parseFloat(string);
    }

    public static int parseInt(String string) {
        return Integer.parseInt(string);
    }

    public static int parseInt(String string, int n) {
        return Integer.parseInt(string, n);
    }

    public static long parseLong(String string) {
        return Long.parseLong(string);
    }

    public static long parseLong(String string, int n) {
        return Long.parseLong(string, n);
    }

    public static short parseShort(String string) {
        return Short.parseShort(string);
    }

    public static short parseShort(String string, int n) {
        return Short.parseShort(string, n);
    }

    public static String quoteRegexReplacement(String string) {
        return Matcher.quoteReplacement(string);
    }

    public static String rationalArrayToString(int[] nArray, boolean bl) {
        if (nArray.length % 2 != 0) {
            throw new IllegalArgumentException("Data length is odd number, expect even!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < nArray.length; i += 2) {
            long l = nArray[i];
            long l2 = nArray[i + 1];
            if (bl) {
                l = (long)nArray[i] & 0xFFFFFFFFL;
                l2 = (long)nArray[i + 1] & 0xFFFFFFFFL;
            }
            stringBuilder.append(l);
            stringBuilder.append("/");
            stringBuilder.append(l2);
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String rationalToString(DecimalFormat decimalFormat, boolean bl, int ... nArray) {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("Input data length is too short");
        }
        if (nArray[1] == 0) {
            throw new ArithmeticException("Divided by zero");
        }
        long l = nArray[0];
        long l2 = nArray[1];
        if (bl) {
            l &= 0xFFFFFFFFL;
            l2 &= 0xFFFFFFFFL;
        }
        return decimalFormat.format(1.0 * (double)l / (double)l2);
    }

    public static String replaceLast(String string, String string2, String string3) {
        return string.replaceAll(string2 + "(?!.*" + string2 + ")", string3);
    }

    public static String reverse(String string) {
        if (string == null) {
            return null;
        }
        return new StringBuilder(string).reverse().toString();
    }

    public static String reverse2(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = n - 1; i >= 0; --i) {
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String reverse(String string, String string2) {
        if (StringUtils.isNullOrEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringUtils.reverseIt(string, string2, stringBuilder);
        return stringBuilder.toString();
    }

    public static String reverse2(String string, String string2) {
        if (StringUtils.isNullOrEmpty(string2) || StringUtils.isNullOrEmpty(string) || string.trim().length() == 0 || string.indexOf(string2) < 0) {
            return string;
        }
        String string3 = StringUtils.escapeRegex(string2);
        String[] stringArray = string.split(string3, -1);
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringBuilder.append(stringArray[i]).append(string2);
        }
        return stringBuilder.substring(0, stringBuilder.lastIndexOf(string2));
    }

    private static void reverseIt(String string, String string2, StringBuilder stringBuilder) {
        if (StringUtils.isNullOrEmpty(string) || string.trim().length() == 0 || string.indexOf(string2) < 0) {
            stringBuilder.append(string);
            return;
        }
        StringUtils.reverseIt(string.substring(string.indexOf(string2) + string2.length()), string2, stringBuilder);
        stringBuilder.append(string2);
        stringBuilder.append(string.substring(0, string.indexOf(string2)));
    }

    public static String reverseWords(String string) {
        String[] stringArray = string.split("\\b");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String shortArrayToString(short[] sArray, boolean bl) {
        return StringUtils.shortArrayToString(sArray, 0, sArray.length, bl);
    }

    public static String shortArrayToString(short[] sArray, int n, int n2, boolean bl) {
        if (sArray == null) {
            return null;
        }
        if (sArray.length == 0) {
            return "[]";
        }
        if (n < 0 || n >= sArray.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int n3 = n + Math.min(n2, sArray.length);
        if (n3 > sArray.length) {
            n2 = sArray.length - n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = n; i < n3; ++i) {
            if (bl) {
                stringBuilder.append(sArray[i] & 0xFFFF);
            } else {
                stringBuilder.append(sArray[i]);
            }
            stringBuilder.append(",");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (n3 < sArray.length) {
            stringBuilder.append(" ...");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String shortToHexString(short s) {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append("0x");
        stringBuilder.append(HEXES[s & 0xF]);
        stringBuilder.append(HEXES[(s & 0xF0) >>> 4]);
        stringBuilder.append(HEXES[(s & 0xF00) >>> 8]);
        stringBuilder.append(HEXES[(s & 0xF000) >>> 12]);
        return stringBuilder.toString();
    }

    public static String shortToHexStringMM(short s) {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append("0x");
        stringBuilder.append(HEXES[(s & 0xF000) >>> 12]);
        stringBuilder.append(HEXES[(s & 0xF00) >>> 8]);
        stringBuilder.append(HEXES[(s & 0xF0) >>> 4]);
        stringBuilder.append(HEXES[s & 0xF]);
        return stringBuilder.toString();
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static Iterator<Character> stringIterator(final String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Iterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length();
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(string.charAt(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String toHexString(byte[] byArray) {
        return StringUtils.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int n3 = n + Math.min(n2, byArray.length);
        if (n3 > byArray.length) {
            n2 = byArray.length - n;
        }
        StringBuilder stringBuilder = new StringBuilder(5 * n2 + 2);
        for (int i = n; i < n3; ++i) {
            stringBuilder.append(HEXES[(byArray[i] & 0xF0) >> 4]).append(HEXES[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String toUTF16BE(byte[] byArray, int n, int n2) {
        String string = "";
        try {
            string = new String(byArray, n, n2, "UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    private StringUtils() {
    }
}

