/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.tiff;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import pixy.image.jpeg.Marker;
import pixy.image.tiff.ASCIIField;
import pixy.image.tiff.AbstractRationalField;
import pixy.image.tiff.ByteField;
import pixy.image.tiff.DoubleField;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.FloatField;
import pixy.image.tiff.IFD;
import pixy.image.tiff.IFDField;
import pixy.image.tiff.LongField;
import pixy.image.tiff.RationalField;
import pixy.image.tiff.SRationalField;
import pixy.image.tiff.ShortField;
import pixy.image.tiff.TIFFImage;
import pixy.image.tiff.Tag;
import pixy.image.tiff.TiffField;
import pixy.image.tiff.TiffFieldEnum;
import pixy.image.tiff.TiffTag;
import pixy.image.tiff.UndefinedField;
import pixy.io.IOUtils;
import pixy.io.MemoryCacheRandomAccessInputStream;
import pixy.io.RandomAccessInputStream;
import pixy.io.RandomAccessOutputStream;
import pixy.io.ReadStrategy;
import pixy.io.ReadStrategyII;
import pixy.io.ReadStrategyMM;
import pixy.io.WriteStrategyII;
import pixy.io.WriteStrategyMM;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.meta.adobe.DDB;
import pixy.meta.adobe.IRB;
import pixy.meta.adobe.IRBThumbnail;
import pixy.meta.adobe.ImageResourceID;
import pixy.meta.adobe.ThumbnailResource;
import pixy.meta.adobe._8BIM;
import pixy.meta.exif.Exif;
import pixy.meta.exif.ExifTag;
import pixy.meta.exif.GPSTag;
import pixy.meta.exif.InteropTag;
import pixy.meta.icc.ICCProfile;
import pixy.meta.image.Comments;
import pixy.meta.iptc.IPTC;
import pixy.meta.iptc.IPTCDataSet;
import pixy.meta.iptc.IPTCTag;
import pixy.meta.tiff.TiffExif;
import pixy.meta.tiff.TiffXMP;
import pixy.meta.xmp.XMP;
import pixy.string.StringUtils;
import pixy.string.XMLUtils;
import pixy.util.ArrayUtils;
import pixy.util.MetadataUtils;

public class TIFFMeta {
    public static final int OFFSET_TO_WRITE_FIRST_IFD_OFFSET = 4;
    public static final int FIRST_WRITE_OFFSET = 8;
    public static final int STREAM_HEAD = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(TIFFMeta.class);

    private static int copyHeader(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        randomAccessInputStream.seek(0L);
        short s = randomAccessInputStream.readShort();
        if (s == 19789) {
            randomAccessInputStream.setReadStrategy(ReadStrategyMM.getInstance());
            randomAccessOutputStream.setWriteStrategy(WriteStrategyMM.getInstance());
        } else if (s == 18761) {
            randomAccessInputStream.setReadStrategy(ReadStrategyII.getInstance());
            randomAccessOutputStream.setWriteStrategy(WriteStrategyII.getInstance());
        } else {
            randomAccessInputStream.close();
            randomAccessOutputStream.close();
            throw new RuntimeException("Invalid TIFF byte order");
        }
        randomAccessOutputStream.writeShort(s);
        randomAccessInputStream.seek(2L);
        short s2 = randomAccessInputStream.readShort();
        if (s2 != 42) {
            randomAccessInputStream.close();
            randomAccessOutputStream.close();
            throw new RuntimeException("Invalid TIFF identifier");
        }
        randomAccessOutputStream.writeShort(s2);
        randomAccessInputStream.seek(4L);
        return randomAccessInputStream.readInt();
    }

    private static Collection<IPTCDataSet> copyIPTCDataSet(Collection<IPTCDataSet> collection, byte[] byArray) throws IOException {
        IPTC iPTC = new IPTC(byArray);
        HashMap<IPTCTag, List<IPTCDataSet>> hashMap = new HashMap<IPTCTag, List<IPTCDataSet>>(iPTC.getDataSets());
        for (IPTCDataSet object : collection) {
            if (object.allowMultiple()) continue;
            hashMap.remove(object.getName());
        }
        for (List list : hashMap.values()) {
            collection.addAll(list);
        }
        return collection;
    }

    private static TiffField<?> copyJpegHufTable(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, TiffField<?> tiffField, int n) throws IOException {
        int[] nArray = tiffField.getDataAsLong();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            randomAccessInputStream.seek(nArray[i]);
            nArray2[i] = n;
            byte[] byArray = new byte[16];
            IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
            IOUtils.write((OutputStream)randomAccessOutputStream, byArray);
            n += 16;
            int n2 = 0;
            for (int j = 0; j < 16; ++j) {
                n2 += byArray[j] & 0xFF;
            }
            n += n2;
            byArray = new byte[n2];
            IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
            IOUtils.write((OutputStream)randomAccessOutputStream, byArray);
        }
        if (TiffTag.fromShort(tiffField.getTag()) == TiffTag.JPEG_AC_TABLES) {
            return new LongField(TiffTag.JPEG_AC_TABLES.getValue(), nArray2);
        }
        return new LongField(TiffTag.JPEG_DC_TABLES.getValue(), nArray2);
    }

    private static void copyJpegIFByteCount(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, int n2) throws IOException {
        boolean bl = false;
        int n3 = 0;
        randomAccessInputStream.seek(n);
        randomAccessOutputStream.seek(n2);
        if (Marker.fromShort(IOUtils.readShortMM(randomAccessInputStream)) != Marker.SOI) {
            return;
        }
        IOUtils.writeShortMM(randomAccessOutputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(randomAccessInputStream);
        block5: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                IOUtils.writeShortMM(randomAccessOutputStream, s);
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    s = IOUtils.readShortMM(randomAccessInputStream);
                    continue block5;
                }
                case SOS: {
                    s = TIFFMeta.copyJpegSOS(randomAccessInputStream, randomAccessOutputStream);
                    continue block5;
                }
                case PADDING: {
                    int n4 = 0;
                    while ((n4 = randomAccessInputStream.read()) == 255) {
                    }
                    s = (short)(0xFF00 | n4);
                    continue block5;
                }
            }
            n3 = IOUtils.readUnsignedShortMM(randomAccessInputStream);
            byte[] byArray = new byte[n3 - 2];
            randomAccessInputStream.read(byArray);
            IOUtils.writeShortMM(randomAccessOutputStream, s);
            IOUtils.writeShortMM(randomAccessOutputStream, n3);
            randomAccessOutputStream.write(byArray);
            s = IOUtils.readShortMM(randomAccessInputStream);
        }
    }

    private static TiffField<?> copyJpegQTable(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, TiffField<?> tiffField, int n) throws IOException {
        byte[] byArray = new byte[64];
        int[] nArray = tiffField.getDataAsLong();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            randomAccessInputStream.seek(nArray[i]);
            nArray2[i] = n;
            IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
            IOUtils.write((OutputStream)randomAccessOutputStream, byArray);
            n += 64;
        }
        return new LongField(TiffTag.JPEG_Q_TABLES.getValue(), nArray2);
    }

    private static short copyJpegSOS(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(randomAccessInputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
        IOUtils.writeShortMM(randomAccessOutputStream, Marker.SOS.getValue());
        IOUtils.writeShortMM(randomAccessOutputStream, n);
        randomAccessOutputStream.write(byArray);
        int n2 = 0;
        short s = 0;
        block3: while ((n2 = IOUtils.read(randomAccessInputStream)) != -1) {
            randomAccessOutputStream.write(n2);
            if (n2 != 255) continue;
            n2 = IOUtils.read(randomAccessInputStream);
            randomAccessOutputStream.write(n2);
            if (n2 == -1) {
                throw new IOException("Premature end of SOS segment!");
            }
            if (n2 == 0) continue;
            s = (short)(0xFF00 | n2);
            switch (Marker.fromShort(s)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (n2 == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return s;
    }

    private static int copyPageData(IFD iFD, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        Object object;
        TiffField<?> l;
        Object object2;
        Object object3;
        Object object4;
        TiffField<?> tiffField;
        int n2 = n;
        boolean n3 = false;
        randomAccessOutputStream.seek(n2);
        TiffField<?> tiffField2 = iFD.removeField(TiffTag.STRIP_OFFSETS);
        if (tiffField2 == null) {
            tiffField2 = iFD.removeField(TiffTag.TILE_OFFSETS);
        }
        if ((tiffField = iFD.getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
            tiffField = iFD.getField(TiffTag.TILE_BYTE_COUNTS);
        }
        if (tiffField2 != null) {
            int n4;
            object4 = tiffField.getDataAsLong();
            object3 = tiffField2.getDataAsLong();
            object2 = new int[((int[])object3).length];
            l = iFD.getField(TiffTag.COMPRESSION);
            if (l == null || l != null && l.getDataAsLong()[0] == 1) {
                n4 = 1;
                l = iFD.getField(TiffTag.PLANAR_CONFIGURATTION);
                if (l != null) {
                    n4 = l.getDataAsLong()[0];
                }
                l = iFD.getField(TiffTag.SAMPLES_PER_PIXEL);
                int byArray = 1;
                if (l != null) {
                    byArray = l.getDataAsLong()[0];
                }
                if (n4 == 1 && ((Object)object3).length == 1 || n4 == 2 && ((Object)object3).length == byArray) {
                    int[] nArray = TIFFMeta.getBytes2Read(iFD);
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        object4[i] = nArray[i];
                    }
                }
            }
            object = object4[0];
            randomAccessOutputStream.seek(n2);
            for (n4 = 0; n4 < ((Object)object3).length; ++n4) {
                randomAccessInputStream.seek((long)object3[n4]);
                byte[] l2 = new byte[object4[n4]];
                randomAccessInputStream.readFully(l2);
                randomAccessOutputStream.write(l2);
                object2[n4] = n2;
                n2 += l2.length;
            }
            if (iFD.getField(TiffTag.STRIP_BYTE_COUNTS) != null) {
                iFD.addField(new LongField(TiffTag.STRIP_OFFSETS.getValue(), (int[])object2));
            } else {
                iFD.addField(new LongField(TiffTag.TILE_OFFSETS.getValue(), (int[])object2));
            }
        }
        object4 = "ICAFE - https://github.com/dragon66/icafe\u0000";
        iFD.addField(new ASCIIField(TiffTag.SOFTWARE.getValue(), (String)object4));
        object3 = iFD.removeField(TiffTag.JPEG_INTERCHANGE_FORMAT);
        if (object3 != null) {
            object2 = iFD.removeField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH);
            if (((TiffField)object3).getDataAsLong()[0] != tiffField2.getDataAsLong()[0]) {
                try {
                    if (object2 != null) {
                        randomAccessInputStream.seek(((TiffField)object3).getDataAsLong()[0]);
                        l = (TiffField<?>)new byte[((TiffField)object2).getDataAsLong()[0]];
                        randomAccessInputStream.readFully((byte[])l);
                        randomAccessOutputStream.seek(n2);
                        randomAccessOutputStream.write((byte[])l);
                        iFD.addField((TiffField<?>)object2);
                    } else {
                        long eOFException = randomAccessOutputStream.getStreamPointer();
                        TIFFMeta.copyJpegIFByteCount(randomAccessInputStream, randomAccessOutputStream, ((TiffField)object3).getDataAsLong()[0], n2);
                        long l2 = randomAccessOutputStream.getStreamPointer();
                        iFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{(int)(l2 - eOFException)}));
                    }
                    object3 = new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{n2});
                    iFD.addField((TiffField<?>)object3);
                }
                catch (EOFException eOFException) {}
            } else {
                iFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{n}));
                iFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{(int)object}));
            }
        }
        if ((object2 = (Object)iFD.removeField(TiffTag.JPEG_DC_TABLES)) != null) {
            try {
                iFD.addField(TIFFMeta.copyJpegHufTable(randomAccessInputStream, randomAccessOutputStream, object2, (int)randomAccessOutputStream.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if ((object2 = (Object)iFD.removeField(TiffTag.JPEG_AC_TABLES)) != null) {
            try {
                iFD.addField(TIFFMeta.copyJpegHufTable(randomAccessInputStream, randomAccessOutputStream, object2, (int)randomAccessOutputStream.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if ((object2 = (Object)iFD.removeField(TiffTag.JPEG_Q_TABLES)) != null) {
            try {
                iFD.addField(TIFFMeta.copyJpegQTable(randomAccessInputStream, randomAccessOutputStream, object2, (int)randomAccessOutputStream.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return (int)randomAccessOutputStream.getStreamPointer();
    }

    private static int copyPages(List<IFD> list, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        n = TIFFMeta.copyPageData(list.get(0), n, randomAccessInputStream, randomAccessOutputStream);
        n = list.get(0).write(randomAccessOutputStream, n);
        for (int i = 1; i < list.size(); ++i) {
            n = TIFFMeta.copyPageData(list.get(i), n, randomAccessInputStream, randomAccessOutputStream);
            list.get(i - 1).setNextIFDOffset(randomAccessOutputStream, n);
            n = list.get(i).write(randomAccessOutputStream, n);
        }
        return n;
    }

    public static byte[] extractICCProfile(int n, RandomAccessInputStream randomAccessInputStream) throws Exception {
        int n2 = TIFFMeta.readHeader(randomAccessInputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = iFD.getField(TiffTag.ICC_PROFILE);
        if (tiffField != null) {
            return (byte[])tiffField.getData();
        }
        return null;
    }

    public static byte[] extractICCProfile(RandomAccessInputStream randomAccessInputStream) throws Exception {
        return TIFFMeta.extractICCProfile(0, randomAccessInputStream);
    }

    public static IRBThumbnail extractThumbnail(int n, RandomAccessInputStream randomAccessInputStream) throws IOException {
        byte[] byArray;
        IRB iRB;
        int n2 = TIFFMeta.readHeader(randomAccessInputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = iFD.getField(TiffTag.PHOTOSHOP);
        if (tiffField != null && (iRB = new IRB(byArray = (byte[])tiffField.getData())).containsThumbnail()) {
            IRBThumbnail iRBThumbnail = iRB.getThumbnail();
            return iRBThumbnail;
        }
        return null;
    }

    public static IRBThumbnail extractThumbnail(RandomAccessInputStream randomAccessInputStream) throws IOException {
        return TIFFMeta.extractThumbnail(0, randomAccessInputStream);
    }

    public static void extractThumbnail(RandomAccessInputStream randomAccessInputStream, String string) throws IOException {
        IRBThumbnail iRBThumbnail = TIFFMeta.extractThumbnail(randomAccessInputStream);
        if (iRBThumbnail != null) {
            Object object = "";
            object = string.endsWith("\\") || string.endsWith("/") ? string + "photoshop_thumbnail.jpg" : string.replaceFirst("[.][^.]+$", "") + "_photoshop_t.jpg";
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            if (iRBThumbnail.getDataType() == 1) {
                fileOutputStream.write(iRBThumbnail.getCompressedImage());
            } else {
                MetadataUtils.saveAsJPEG(iRBThumbnail.getRawImage(), fileOutputStream, 100);
            }
            fileOutputStream.close();
        }
    }

    private static int[] getBytes2Read(IFD iFD) {
        TiffField<?> tiffField = iFD.getField(TiffTag.IMAGE_WIDTH);
        int n = tiffField.getDataAsLong()[0];
        tiffField = iFD.getField(TiffTag.IMAGE_LENGTH);
        int n2 = tiffField.getDataAsLong()[0];
        int n3 = 2;
        int n4 = 2;
        int n5 = iFD.getField(TiffTag.PHOTOMETRIC_INTERPRETATION).getDataAsLong()[0];
        if (n5 == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            TiffField<?> tiffField2 = iFD.getField(TiffTag.YCbCr_SUB_SAMPLING);
            if (tiffField2 != null) {
                int[] nArray = tiffField2.getDataAsLong();
                n3 = nArray[0];
                n4 = nArray[1];
            }
            n = (n + n3 - 1) / n3 * n3;
            n2 = (n2 + n4 - 1) / n4 * n4;
        }
        int n6 = 1;
        tiffField = iFD.getField(TiffTag.SAMPLES_PER_PIXEL);
        if (tiffField != null) {
            n6 = tiffField.getDataAsLong()[0];
        }
        int n7 = 1;
        tiffField = iFD.getField(TiffTag.BITS_PER_SAMPLE);
        if (tiffField != null) {
            n7 = tiffField.getDataAsLong()[0];
        }
        int n8 = -1;
        int n9 = -1;
        TiffField<?> tiffField3 = iFD.getField(TiffTag.TILE_LENGTH);
        TiffField<?> tiffField4 = iFD.getField(TiffTag.TILE_WIDTH);
        if (tiffField4 != null) {
            n8 = tiffField4.getDataAsLong()[0];
            n9 = tiffField3.getDataAsLong()[0];
        }
        int n10 = n2;
        int n11 = n;
        TiffField<?> tiffField5 = iFD.getField(TiffTag.ROWS_PER_STRIP);
        if (tiffField5 != null) {
            n10 = tiffField5.getDataAsLong()[0];
        }
        if (n10 > n2) {
            n10 = n2;
        }
        if (n8 > 0) {
            n10 = n9;
            n11 = n8;
        }
        int n12 = 1;
        tiffField = iFD.getField(TiffTag.PLANAR_CONFIGURATTION);
        if (tiffField != null) {
            n12 = tiffField.getDataAsLong()[0];
        }
        int[] nArray = new int[n6];
        if (n12 == 1) {
            nArray[0] = (n11 * n7 * n6 + 7) / 8 * n10;
        } else {
            nArray[1] = nArray[2] = (n11 * n7 + 7) / 8 * n10;
            nArray[0] = nArray[2];
        }
        if (n5 == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            if (n6 != 3) {
                n6 = 3;
            }
            int[] nArray2 = new int[n6];
            nArray2[0] = (n7 * n11 + 7) / 8;
            nArray2[1] = (n7 * n11 / n3 + 7) / 8;
            nArray2[2] = nArray2[1];
            int[] nArray3 = new int[n6];
            nArray3[0] = n10;
            nArray3[1] = n10 / n4;
            nArray3[2] = nArray3[1];
            nArray[0] = nArray2[0] * nArray3[0];
            nArray[1] = nArray2[1] * nArray3[1];
            nArray[2] = nArray[1];
            if (tiffField != null) {
                n12 = tiffField.getDataAsLong()[0];
            }
            if (n12 == 1) {
                nArray[0] = nArray[0] + nArray[1] + nArray[2];
            }
        }
        return nArray;
    }

    public static void insertComments(List<String> list, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFMeta.insertComments(list, 0, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertComments(List<String> list, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append('\u0000');
        }
        iFD.addField(new ASCIIField(TiffTag.IMAGE_DESCRIPTION.getValue(), stringBuilder.toString()));
        n2 = TIFFMeta.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertExif(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Exif exif, boolean bl) throws IOException {
        TIFFMeta.insertExif(randomAccessInputStream, randomAccessOutputStream, exif, 0, bl);
    }

    public static void insertExif(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Exif exif, int n, boolean bl) throws IOException {
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        IFD iFD2 = iFD.getChild(TiffTag.EXIF_SUB_IFD);
        IFD iFD3 = iFD.getChild(TiffTag.GPS_SUB_IFD);
        IFD iFD4 = exif.getImageIFD();
        IFD iFD5 = exif.getExifIFD();
        IFD iFD6 = exif.getGPSIFD();
        if (iFD4 != null) {
            Collection<TiffField<?>> collection = iFD4.getFields();
            for (TiffField<?> tiffField : collection) {
                Tag tag = TiffTag.fromShort(tiffField.getTag());
                if (iFD.getField(tag) != null && tag.isCritical()) {
                    throw new RuntimeException("Duplicate Tag: " + tag);
                }
                iFD.addField(tiffField);
            }
        }
        if (bl && iFD2 != null && iFD5 != null) {
            iFD2.addFields(iFD5.getFields());
            iFD5 = iFD2;
        }
        if (iFD5 != null) {
            iFD.addField(new LongField(TiffTag.EXIF_SUB_IFD.getValue(), new int[]{0}));
            iFD.addChild(TiffTag.EXIF_SUB_IFD, iFD5);
        }
        if (bl && iFD3 != null && iFD6 != null) {
            iFD3.addFields(iFD6.getFields());
            iFD6 = iFD3;
        }
        if (iFD6 != null) {
            iFD.addField(new LongField(TiffTag.GPS_SUB_IFD.getValue(), new int[]{0}));
            iFD.addChild(TiffTag.GPS_SUB_IFD, iFD6);
        }
        int n3 = 8;
        n3 = TIFFMeta.copyPages(arrayList, n3, randomAccessInputStream, randomAccessOutputStream);
        int n4 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n4);
    }

    public static void insertICCProfile(byte[] byArray, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFMeta.insertICCProfile(byArray, 0, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertICCProfile(byte[] byArray, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        iFD.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), byArray));
        n2 = TIFFMeta.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertIPTC(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Collection<IPTCDataSet> collection, boolean bl) throws IOException {
        TIFFMeta.insertIPTC(randomAccessInputStream, randomAccessOutputStream, 0, collection, bl);
    }

    public static void insertIPTC(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, Collection<IPTCDataSet> collection, boolean bl) throws IOException {
        Object object;
        HashMap<Short, _8BIM> hashMap;
        Object object2;
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TiffField<?> tiffField = iFD.removeField(TiffTag.IPTC);
        TiffField<?> tiffField2 = iFD.getField(TiffTag.PHOTOSHOP);
        if (tiffField2 != null) {
            object2 = new IRB((byte[])tiffField2.getData());
            hashMap = new HashMap<Short, _8BIM>(((IRB)object2).get8BIM());
            object = (_8BIM)hashMap.remove(ImageResourceID.IPTC_NAA.getValue());
            if (object != null && bl) {
                if (tiffField != null) {
                    Object object3 = null;
                    object3 = tiffField.getType() == FieldType.LONG ? (Object)ArrayUtils.toByteArray(tiffField.getDataAsLong(), randomAccessInputStream.getEndian() == 19789) : (Object)((byte[])tiffField.getData());
                    TIFFMeta.copyIPTCDataSet(collection, (byte[])object3);
                }
                TIFFMeta.copyIPTCDataSet(collection, ((_8BIM)object).getData());
                collection = new ArrayList<IPTCDataSet>(new HashSet<IPTCDataSet>(collection));
            }
            for (_8BIM _8BIM2 : hashMap.values()) {
                _8BIM2.write(byteArrayOutputStream);
            }
            iFD.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), byteArrayOutputStream.toByteArray()));
        } else if (tiffField != null && bl) {
            object2 = null;
            object2 = tiffField.getType() == FieldType.LONG ? (Object)ArrayUtils.toByteArray(tiffField.getDataAsLong(), randomAccessInputStream.getEndian() == 19789) : (Object)((byte[])tiffField.getData());
            TIFFMeta.copyIPTCDataSet(collection, (byte[])object2);
        }
        object2 = new ArrayList<IPTCDataSet>(collection);
        Collections.sort(object2);
        byteArrayOutputStream.reset();
        hashMap = object2.iterator();
        while (hashMap.hasNext()) {
            object = (IPTCDataSet)hashMap.next();
            ((IPTCDataSet)object).write(byteArrayOutputStream);
        }
        iFD.addField(new UndefinedField(TiffTag.IPTC.getValue(), byteArrayOutputStream.toByteArray()));
        n2 = TIFFMeta.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertIRB(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Collection<_8BIM> collection, boolean bl) throws IOException {
        TIFFMeta.insertIRB(randomAccessInputStream, randomAccessOutputStream, 0, collection, bl);
    }

    public static void insertIRB(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, Collection<_8BIM> collection, boolean bl) throws IOException {
        Object object;
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl && (object = iFD.getField(TiffTag.PHOTOSHOP)) != null) {
            IRB object2 = new IRB((byte[])((TiffField)object).getData());
            HashMap<Short, _8BIM> hashMap = new HashMap<Short, _8BIM>(object2.get8BIM());
            for (_8BIM _8BIM2 : collection) {
                hashMap.put(_8BIM2.getID(), _8BIM2);
            }
            if (hashMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue()) && hashMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS5.getValue())) {
                hashMap.remove(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue());
            }
            collection = hashMap.values();
        }
        for (_8BIM _8BIM3 : collection) {
            _8BIM3.write(byteArrayOutputStream);
        }
        iFD.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), byteArrayOutputStream.toByteArray()));
        n2 = TIFFMeta.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertThumbnail(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, BufferedImage bufferedImage) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Input thumbnail is null");
        }
        ThumbnailResource thumbnailResource = new ThumbnailResource(bufferedImage);
        TIFFMeta.insertIRB(randomAccessInputStream, randomAccessOutputStream, Arrays.asList(thumbnailResource), true);
    }

    public static void insertXMP(XMP xMP, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFMeta.insertXMP(xMP.getData(), randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertXMP(XMP xMP, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFMeta.insertXMP(xMP.getData(), n, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertXMP(byte[] byArray, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFMeta.insertXMP(byArray, 0, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertXMP(byte[] byArray, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        iFD.addField(new UndefinedField(TiffTag.XMP.getValue(), byArray));
        n2 = TIFFMeta.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertXMP(String string, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        Document document = XMLUtils.createXML(string);
        XMLUtils.insertLeadingPI(document, "xpacket", "begin='' id='W5M0MpCehiHzreSzNTczkc9d'");
        XMLUtils.insertTrailingPI(document, "xpacket", "end='w'");
        byte[] byArray = XMLUtils.serializeToByteArray(document);
        TIFFMeta.insertXMP(byArray, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void printIFDs(Collection<IFD> collection, String string) {
        int n = 0;
        LOGGER.info("Printing IFDs ... ");
        for (IFD iFD : collection) {
            LOGGER.info("IFD #{}", (Object)n);
            TIFFMeta.printIFD(iFD, TiffTag.class, string);
            ++n;
        }
    }

    public static void printIFD(IFD iFD, Class<? extends Tag> clazz, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        TIFFMeta.print(iFD, clazz, string, stringBuilder);
        LOGGER.info("\n{}", (Object)stringBuilder);
    }

    private static void print(IFD iFD, Class<? extends Tag> clazz, String string, StringBuilder stringBuilder) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        Collection<TiffField<?>> collection = iFD.getFields();
        int n = 0;
        for (TiffField<?> tiffField : collection) {
            stringBuilder.append(string);
            stringBuilder.append("Field #" + n + "\n");
            stringBuilder.append(string);
            short s = tiffField.getTag();
            Tag tag = TiffTag.UNKNOWN;
            if (s == ExifTag.PADDING.getValue()) {
                tag = ExifTag.PADDING;
            } else {
                try {
                    tag = (Tag)method.invoke(null, s);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOGGER.error("IllegalAcessException", (Throwable)illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.error("IllegalArgumentException", (Throwable)illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOGGER.error("InvocationTargetException", (Throwable)invocationTargetException);
                }
            }
            if (tag == TiffTag.UNKNOWN) {
                LOGGER.warn("Tag: {} {}{}{} {}", new Object[]{tag, "[Value: 0x", Integer.toHexString(s & 0xFFFF), "]", "(Unknown)"});
            } else {
                stringBuilder.append("Tag: " + tag + "\n");
            }
            FieldType fieldType = tiffField.getType();
            stringBuilder.append(string);
            stringBuilder.append("Field type: " + fieldType + "\n");
            int n2 = tiffField.getLength();
            stringBuilder.append(string);
            stringBuilder.append("Field length: " + n2 + "\n");
            stringBuilder.append(string);
            String string2 = null;
            string2 = fieldType == FieldType.SHORT || fieldType == FieldType.SSHORT ? tag.getFieldAsString(tiffField.getDataAsLong()) : tag.getFieldAsString(tiffField.getData());
            stringBuilder.append("Field value: " + tiffField.getDataAsString() + (String)(StringUtils.isNullOrEmpty(string2) ? "" : " => " + string2) + "\n");
            ++n;
        }
        Map<Tag, IFD> map = iFD.getChildren();
        if (map.get(TiffTag.EXIF_SUB_IFD) != null) {
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<Exif SubIFD starts>>\n");
            TIFFMeta.print((IFD)map.get(TiffTag.EXIF_SUB_IFD), ExifTag.class, string + "--------- ", stringBuilder);
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<Exif SubIFD ends>>\n");
        }
        if (map.get(TiffTag.GPS_SUB_IFD) != null) {
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<GPS SubIFD starts>>\n");
            TIFFMeta.print((IFD)map.get(TiffTag.GPS_SUB_IFD), GPSTag.class, string + "--------- ", stringBuilder);
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<GPS SubIFD ends>>\n");
        }
    }

    private static int readHeader(RandomAccessInputStream randomAccessInputStream) throws IOException {
        int n = 0;
        randomAccessInputStream.seek(0L);
        short s = randomAccessInputStream.readShort();
        n += 2;
        if (s == 19789) {
            randomAccessInputStream.setReadStrategy(ReadStrategyMM.getInstance());
        } else if (s == 18761) {
            randomAccessInputStream.setReadStrategy(ReadStrategyII.getInstance());
        } else {
            randomAccessInputStream.close();
            throw new RuntimeException("Invalid TIFF byte order");
        }
        randomAccessInputStream.seek(n);
        short s2 = randomAccessInputStream.readShort();
        n += 2;
        if (s2 != 42) {
            randomAccessInputStream.close();
            throw new RuntimeException("Invalid TIFF identifier");
        }
        randomAccessInputStream.seek(n);
        n = randomAccessInputStream.readInt();
        return n;
    }

    private static int readIFD(IFD iFD, Tag tag, Class<? extends Tag> clazz, RandomAccessInputStream randomAccessInputStream, List<IFD> list, int n) throws IOException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        IFD iFD2 = new IFD();
        randomAccessInputStream.seek(n);
        int n2 = randomAccessInputStream.readShort();
        n += 2;
        block25: for (int i = 0; i < n2; ++i) {
            randomAccessInputStream.seek(n);
            short s = randomAccessInputStream.readShort();
            Tag tag2 = TiffTag.UNKNOWN;
            try {
                tag2 = (Tag)method.invoke(null, s);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            randomAccessInputStream.seek(n += 2);
            short s2 = randomAccessInputStream.readShort();
            FieldType fieldType = FieldType.fromShort(s2);
            randomAccessInputStream.seek(n += 2);
            int n3 = randomAccessInputStream.readInt();
            n += 4;
            switch (fieldType) {
                case BYTE: 
                case UNDEFINED: {
                    byte[] byArray = new byte[n3];
                    randomAccessInputStream.seek(n);
                    if (n3 <= 4) {
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    } else {
                        randomAccessInputStream.seek(randomAccessInputStream.readInt());
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    }
                    TiffField tiffField = null;
                    tiffField = fieldType == FieldType.BYTE ? new ByteField(s, byArray) : new UndefinedField(s, byArray);
                    iFD2.addField(tiffField);
                    n += 4;
                    continue block25;
                }
                case ASCII: {
                    byte[] byArray = new byte[n3];
                    if (n3 <= 4) {
                        randomAccessInputStream.seek(n);
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    } else {
                        randomAccessInputStream.seek(n);
                        randomAccessInputStream.seek(randomAccessInputStream.readInt());
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    }
                    ASCIIField aSCIIField = new ASCIIField(s, new String(byArray, "UTF-8"));
                    iFD2.addField(aSCIIField);
                    n += 4;
                    continue block25;
                }
                case SHORT: {
                    short[] sArray = new short[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        sArray[0] = randomAccessInputStream.readShort();
                        n += 4;
                    } else if (n3 == 2) {
                        randomAccessInputStream.seek(n);
                        sArray[0] = randomAccessInputStream.readShort();
                        randomAccessInputStream.seek(n += 2);
                        sArray[1] = randomAccessInputStream.readShort();
                        n += 2;
                    } else {
                        randomAccessInputStream.seek(n);
                        int n4 = randomAccessInputStream.readInt();
                        n += 4;
                        for (int j = 0; j < n3; ++j) {
                            randomAccessInputStream.seek(n4);
                            sArray[j] = randomAccessInputStream.readShort();
                            n4 += 2;
                        }
                    }
                    ShortField shortField = new ShortField(s, sArray);
                    iFD2.addField(shortField);
                    continue block25;
                }
                case LONG: {
                    int n5;
                    int[] nArray = new int[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        nArray[0] = randomAccessInputStream.readInt();
                        n += 4;
                    } else {
                        randomAccessInputStream.seek(n);
                        int n6 = randomAccessInputStream.readInt();
                        n += 4;
                        for (n5 = 0; n5 < n3; ++n5) {
                            randomAccessInputStream.seek(n6);
                            nArray[n5] = randomAccessInputStream.readInt();
                            n6 += 4;
                        }
                    }
                    LongField longField = new LongField(s, nArray);
                    iFD2.addField(longField);
                    if (tag2 == TiffTag.EXIF_SUB_IFD && nArray[0] != 0) {
                        try {
                            TIFFMeta.readIFD(iFD2, TiffTag.EXIF_SUB_IFD, ExifTag.class, randomAccessInputStream, null, nArray[0]);
                        }
                        catch (Exception exception) {
                            iFD2.removeField(TiffTag.EXIF_SUB_IFD);
                            exception.printStackTrace();
                        }
                        continue block25;
                    }
                    if (tag2 == TiffTag.GPS_SUB_IFD && nArray[0] != 0) {
                        try {
                            TIFFMeta.readIFD(iFD2, TiffTag.GPS_SUB_IFD, GPSTag.class, randomAccessInputStream, null, nArray[0]);
                        }
                        catch (Exception exception) {
                            iFD2.removeField(TiffTag.GPS_SUB_IFD);
                            exception.printStackTrace();
                        }
                        continue block25;
                    }
                    if (tag2 == ExifTag.EXIF_INTEROPERABILITY_OFFSET && nArray[0] != 0) {
                        try {
                            TIFFMeta.readIFD(iFD2, ExifTag.EXIF_INTEROPERABILITY_OFFSET, InteropTag.class, randomAccessInputStream, null, nArray[0]);
                        }
                        catch (Exception exception) {
                            iFD2.removeField(ExifTag.EXIF_INTEROPERABILITY_OFFSET);
                            exception.printStackTrace();
                        }
                        continue block25;
                    }
                    if (tag2 != TiffTag.SUB_IFDS) continue block25;
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        try {
                            TIFFMeta.readIFD(iFD2, TiffTag.SUB_IFDS, TiffTag.class, randomAccessInputStream, null, nArray[0]);
                            continue;
                        }
                        catch (Exception exception) {
                            iFD2.removeField(TiffTag.SUB_IFDS);
                            exception.printStackTrace();
                        }
                    }
                    continue block25;
                }
                case FLOAT: {
                    float[] fArray = new float[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        fArray[0] = randomAccessInputStream.readFloat();
                        n += 4;
                    } else {
                        randomAccessInputStream.seek(n);
                        int n7 = randomAccessInputStream.readInt();
                        n += 4;
                        for (int j = 0; j < n3; ++j) {
                            randomAccessInputStream.seek(n7);
                            fArray[j] = randomAccessInputStream.readFloat();
                            n7 += 4;
                        }
                    }
                    FloatField floatField = new FloatField(s, fArray);
                    iFD2.addField(floatField);
                    continue block25;
                }
                case DOUBLE: {
                    double[] dArray = new double[n3];
                    randomAccessInputStream.seek(n);
                    int n8 = randomAccessInputStream.readInt();
                    n += 4;
                    for (int j = 0; j < n3; ++j) {
                        randomAccessInputStream.seek(n8);
                        dArray[j] = randomAccessInputStream.readDouble();
                        n8 += 8;
                    }
                    DoubleField doubleField = new DoubleField(s, dArray);
                    iFD2.addField(doubleField);
                    continue block25;
                }
                case RATIONAL: 
                case SRATIONAL: {
                    int n9 = 2 * n3;
                    int[] nArray = new int[n9];
                    randomAccessInputStream.seek(n);
                    int n8 = randomAccessInputStream.readInt();
                    n += 4;
                    for (int j = 0; j < n9; j += 2) {
                        randomAccessInputStream.seek(n8);
                        nArray[j] = randomAccessInputStream.readInt();
                        randomAccessInputStream.seek(n8 += 4);
                        nArray[j + 1] = randomAccessInputStream.readInt();
                        n8 += 4;
                    }
                    AbstractRationalField abstractRationalField = null;
                    abstractRationalField = fieldType == FieldType.SRATIONAL ? new SRationalField(s, nArray) : new RationalField(s, nArray);
                    iFD2.addField(abstractRationalField);
                    continue block25;
                }
                case IFD: {
                    int n8;
                    int[] nArray = new int[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        nArray[0] = randomAccessInputStream.readInt();
                        n += 4;
                    } else {
                        randomAccessInputStream.seek(n);
                        n8 = randomAccessInputStream.readInt();
                        n += 4;
                        for (int j = 0; j < n3; ++j) {
                            randomAccessInputStream.seek(n8);
                            nArray[j] = randomAccessInputStream.readInt();
                            n8 += 4;
                        }
                    }
                    IFDField iFDField = new IFDField(s, nArray);
                    iFD2.addField(iFDField);
                    for (int j = 0; j < nArray.length; ++j) {
                        TIFFMeta.readIFD(iFD2, TiffTag.SUB_IFDS, TiffTag.class, randomAccessInputStream, null, nArray[0]);
                    }
                    continue block25;
                }
                default: {
                    n += 4;
                }
            }
        }
        if (iFD != null) {
            iFD.addChild(tag, iFD2);
        } else {
            list.add(iFD2);
        }
        randomAccessInputStream.seek(n);
        return randomAccessInputStream.readInt();
    }

    private static void readIFDs(IFD iFD, Tag tag, Class<? extends Tag> clazz, List<IFD> list, int n, RandomAccessInputStream randomAccessInputStream) throws IOException {
        while (n != 0) {
            n = TIFFMeta.readIFD(iFD, tag, clazz, randomAccessInputStream, list, n);
        }
    }

    public static void readIFDs(List<IFD> list, RandomAccessInputStream randomAccessInputStream) throws IOException {
        int n = TIFFMeta.readHeader(randomAccessInputStream);
        TIFFMeta.readIFDs(null, null, TiffTag.class, list, n, randomAccessInputStream);
    }

    public static Map<MetadataType, Metadata> readMetadata(RandomAccessInputStream randomAccessInputStream) throws IOException {
        return TIFFMeta.readMetadata(randomAccessInputStream, 0);
    }

    public static Map<MetadataType, Metadata> readMetadata(RandomAccessInputStream randomAccessInputStream, int n) throws IOException {
        Object object;
        Object object2;
        Metadata metadata;
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        int n2 = TIFFMeta.readHeader(randomAccessInputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = iFD.getField(TiffTag.ICC_PROFILE);
        if (tiffField != null) {
            hashMap.put(MetadataType.ICC_PROFILE, new ICCProfile((byte[])tiffField.getData()));
        }
        if ((tiffField = iFD.getField(TiffTag.XMP)) != null) {
            hashMap.put(MetadataType.XMP, new TiffXMP((byte[])tiffField.getData()));
        }
        if ((tiffField = iFD.getField(TiffTag.PHOTOSHOP)) != null) {
            metadata = new IRB((byte[])tiffField.getData());
            hashMap.put(MetadataType.PHOTOSHOP_IRB, metadata);
            object2 = ((IRB)metadata).get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (object2 != null) {
                object = new IPTC(((_8BIM)object2).getData());
                hashMap.put(MetadataType.IPTC, (Metadata)object);
            }
        }
        if ((tiffField = iFD.getField(TiffTag.IPTC)) != null) {
            metadata = (IPTC)hashMap.get((Object)MetadataType.IPTC);
            object2 = null;
            object = tiffField.getType();
            object2 = object == FieldType.LONG ? (Object)ArrayUtils.toByteArray(tiffField.getDataAsLong(), randomAccessInputStream.getEndian() == 19789) : (Object)((byte[])tiffField.getData());
            if (metadata != null) {
                object2 = ArrayUtils.concat((byte[])object2, new byte[][]{metadata.getData()});
            }
            hashMap.put(MetadataType.IPTC, new IPTC((byte[])object2));
        }
        if ((tiffField = iFD.getField(TiffTag.EXIF_SUB_IFD)) != null) {
            hashMap.put(MetadataType.EXIF, new TiffExif(iFD));
        }
        if ((tiffField = iFD.getField(TiffTag.IMAGE_SOURCE_DATA)) != null) {
            boolean bl = randomAccessInputStream.getEndian() == 19789;
            object2 = bl ? ReadStrategyMM.getInstance() : ReadStrategyII.getInstance();
            hashMap.put(MetadataType.PHOTOSHOP_DDB, new DDB((byte[])tiffField.getData(), (ReadStrategy)object2));
        }
        if ((tiffField = iFD.getField(TiffTag.IMAGE_DESCRIPTION)) != null) {
            Comments comments = new Comments();
            comments.addComment(tiffField.getDataAsString());
            hashMap.put(MetadataType.COMMENT, comments);
        }
        return hashMap;
    }

    public static Map<MetadataType, Metadata> removeMetadata(int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, MetadataType ... metadataTypeArray) throws IOException {
        return TIFFMeta.removeMetadata(new HashSet<MetadataType>(Arrays.asList(metadataTypeArray)), n, randomAccessInputStream, randomAccessOutputStream);
    }

    public static Map<MetadataType, Metadata> removeMetadata(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, MetadataType ... metadataTypeArray) throws IOException {
        return TIFFMeta.removeMetadata(0, randomAccessInputStream, randomAccessOutputStream, metadataTypeArray);
    }

    public static Map<MetadataType, Metadata> removeMetadata(Set<MetadataType> set, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = null;
        block8: for (MetadataType metadataType : set) {
            switch (metadataType) {
                case XMP: {
                    TiffField<?> tiffField2 = iFD.removeField(TiffTag.XMP);
                    if (tiffField2 != null) {
                        hashMap.put(MetadataType.XMP, new TiffXMP((byte[])tiffField2.getData()));
                    }
                    if ((tiffField = iFD.removeField(TiffTag.PHOTOSHOP)) == null) break;
                    Object object2 = (byte[])tiffField.getData();
                    List<_8BIM> list = TIFFMeta.removeMetadataFromIRB(iFD, (byte[])object2, ImageResourceID.XMP_METADATA);
                    if (list.size() <= 0 || tiffField2 != null) continue block8;
                    hashMap.put(MetadataType.XMP, new TiffXMP(list.get(0).getData()));
                    break;
                }
                case IPTC: {
                    Object object;
                    Object object2 = iFD.removeField(TiffTag.IPTC);
                    if (object2 != null) {
                        hashMap.put(MetadataType.IPTC, new IPTC((byte[])((TiffField)object2).getData()));
                    }
                    if ((tiffField = iFD.removeField(TiffTag.PHOTOSHOP)) == null) break;
                    List<_8BIM> list = (List<_8BIM>)((byte[])tiffField.getData());
                    List<_8BIM> list2 = TIFFMeta.removeMetadataFromIRB(iFD, (byte[])list, ImageResourceID.IPTC_NAA);
                    if (list2.size() <= 0) continue block8;
                    List<_8BIM> list3 = (IPTC)hashMap.remove((Object)MetadataType.IPTC);
                    if (list3 != null) {
                        object = ArrayUtils.concat(((Metadata)((Object)list3)).getData(), new byte[][]{list2.get(0).getData()});
                        hashMap.put(MetadataType.IPTC, new IPTC((byte[])object));
                        break;
                    }
                    hashMap.put(MetadataType.IPTC, new IPTC(list2.get(0).getData()));
                    break;
                }
                case ICC_PROFILE: {
                    List<_8BIM> list = iFD.removeField(TiffTag.ICC_PROFILE);
                    if (list != null) {
                        hashMap.put(MetadataType.ICC_PROFILE, new ICCProfile((byte[])((TiffField)((Object)list)).getData()));
                    }
                    if ((tiffField = iFD.removeField(TiffTag.PHOTOSHOP)) == null) break;
                    List<_8BIM> list2 = (List<_8BIM>)((byte[])tiffField.getData());
                    List<_8BIM> list3 = TIFFMeta.removeMetadataFromIRB(iFD, (byte[])list2, ImageResourceID.ICC_PROFILE);
                    if (list3.size() <= 0 || list != null) continue block8;
                    hashMap.put(MetadataType.ICC_PROFILE, new ICCProfile(((_8BIM)list3.get(0)).getData()));
                    break;
                }
                case PHOTOSHOP_IRB: {
                    List<_8BIM> list2 = iFD.removeField(TiffTag.PHOTOSHOP);
                    if (list2 == null) break;
                    hashMap.put(MetadataType.PHOTOSHOP_IRB, new IRB((byte[])((TiffField)((Object)list2)).getData()));
                    break;
                }
                case EXIF: {
                    List<_8BIM> list3 = iFD.removeField(TiffTag.EXIF_SUB_IFD);
                    if (list3 != null) {
                        hashMap.put(MetadataType.EXIF, new TiffExif(iFD));
                    }
                    iFD.removeField(TiffTag.GPS_SUB_IFD);
                    tiffField = iFD.removeField(TiffTag.PHOTOSHOP);
                    if (tiffField == null) break;
                    Object object = (byte[])tiffField.getData();
                    Iterable<MetadataEntry> iterable = TIFFMeta.removeMetadataFromIRB(iFD, (byte[])object, ImageResourceID.EXIF_DATA1, ImageResourceID.EXIF_DATA3);
                    if (list3 != null || iterable.size() <= 0) continue block8;
                    MemoryCacheRandomAccessInputStream memoryCacheRandomAccessInputStream = new MemoryCacheRandomAccessInputStream(new ByteArrayInputStream(((_8BIM)iterable.get(0)).getData()));
                    ArrayList<IFD> arrayList2 = new ArrayList<IFD>();
                    TIFFMeta.readIFDs(arrayList2, memoryCacheRandomAccessInputStream);
                    ((InputStream)memoryCacheRandomAccessInputStream).close();
                    if (arrayList2.size() <= 0) continue block8;
                    hashMap.put(MetadataType.EXIF, new TiffExif((IFD)arrayList2.get(0)));
                    break;
                }
                case COMMENT: {
                    Object object = iFD.removeField(TiffTag.IMAGE_DESCRIPTION);
                    if (object == null) break;
                    Iterable<MetadataEntry> iterable = new Comments();
                    ((Comments)iterable).addComment(((TiffField)object).getDataAsString());
                    hashMap.put(MetadataType.COMMENT, (Metadata)iterable);
                    break;
                }
            }
        }
        n2 = TIFFMeta.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n3);
        return hashMap;
    }

    public static Map<MetadataType, Metadata> removeMetadata(Set<MetadataType> set, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        return TIFFMeta.removeMetadata(set, 0, randomAccessInputStream, randomAccessOutputStream);
    }

    private static List<_8BIM> removeMetadataFromIRB(IFD iFD, byte[] byArray, ImageResourceID ... imageResourceIDArray) throws IOException {
        IRB iRB = new IRB(byArray);
        HashMap<Short, _8BIM> hashMap = new HashMap<Short, _8BIM>(iRB.get8BIM());
        ArrayList<_8BIM> arrayList = new ArrayList<_8BIM>();
        for (ImageResourceID imageResourceID : imageResourceIDArray) {
            _8BIM _8BIM2 = (_8BIM)hashMap.remove(imageResourceID.getValue());
            if (_8BIM2 == null) continue;
            arrayList.add(_8BIM2);
        }
        if (hashMap.size() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (_8BIM _8BIM3 : hashMap.values()) {
                _8BIM3.write(byteArrayOutputStream);
            }
            iFD.addField(new ByteField(TiffTag.PHOTOSHOP.getValue(), byteArrayOutputStream.toByteArray()));
        }
        return arrayList;
    }

    public static int retainPages(int n, int n2, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Negative start or end page");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Start page is larger than end page");
        }
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n4 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n4, randomAccessInputStream);
        int n5 = arrayList.size();
        ArrayList<IFD> arrayList2 = new ArrayList<IFD>();
        if (n <= arrayList.size() - 1) {
            if (n2 > arrayList.size() - 1) {
                n2 = arrayList.size() - 1;
            }
            for (n3 = n2; n3 >= n; --n3) {
                arrayList2.add((IFD)arrayList.get(n3));
            }
        }
        if (arrayList2.size() > 0) {
            n5 = arrayList2.size();
            arrayList.retainAll(arrayList2);
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            ((IFD)arrayList.get(n3)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n3)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n3, (short)(arrayList.size() - 1)}));
        }
        n3 = 8;
        n4 = TIFFMeta.copyPages(arrayList, n3, randomAccessInputStream, randomAccessOutputStream);
        int n6 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n6);
        return n5;
    }

    public static int retainPages(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int ... nArray) throws IOException {
        int n;
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n2 = TIFFMeta.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFMeta.readIFDs(null, null, TiffTag.class, arrayList, n2, randomAccessInputStream);
        int n3 = arrayList.size();
        ArrayList<IFD> arrayList2 = new ArrayList<IFD>();
        Arrays.sort(nArray);
        for (n = nArray.length - 1; n >= 0; --n) {
            if (nArray[n] < 0 || nArray[n] >= arrayList.size()) continue;
            arrayList2.add((IFD)arrayList.get(nArray[n]));
        }
        if (arrayList2.size() > 0) {
            n3 = arrayList2.size();
            arrayList.retainAll(arrayList2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((IFD)arrayList.get(n)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n, (short)(arrayList.size() - 1)}));
        }
        n = 8;
        n2 = TIFFMeta.copyPages(arrayList, n, randomAccessInputStream, randomAccessOutputStream);
        int n4 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n4);
        return n3;
    }

    public static void write(TIFFImage tIFFImage, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        RandomAccessInputStream randomAccessInputStream = tIFFImage.getInputStream();
        int n = TIFFMeta.writeHeader(randomAccessOutputStream);
        n = TIFFMeta.copyPages(tIFFImage.getIFDs(), n, randomAccessInputStream, randomAccessOutputStream);
        int n2 = tIFFImage.getIFDs().get(0).getStartOffset();
        TIFFMeta.writeToStream(randomAccessOutputStream, n2);
    }

    private static int writeHeader(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        short s = randomAccessOutputStream.getEndian();
        randomAccessOutputStream.writeShort(s);
        randomAccessOutputStream.writeShort(42);
        return 8;
    }

    private static void writeToStream(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        randomAccessOutputStream.seek(4L);
        randomAccessOutputStream.writeInt(n);
        randomAccessOutputStream.seek(0L);
        randomAccessOutputStream.writeToStream(randomAccessOutputStream.getLength());
    }
}

