/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.png;

import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkType;
import pixy.image.png.ICCPBuilder;
import pixy.image.png.TextBuilder;
import pixy.image.png.TextReader;
import pixy.image.png.UnknownChunk;
import pixy.io.IOUtils;
import pixy.meta.Metadata;
import pixy.meta.MetadataType;
import pixy.meta.icc.ICCProfile;
import pixy.meta.png.PngXMP;
import pixy.meta.png.TIMEChunk;
import pixy.meta.png.TextualChunks;
import pixy.meta.xmp.XMP;
import pixy.string.XMLUtils;

public class PNGMeta {
    private static final long SIGNATURE = -8552249625308161526L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PNGMeta.class);

    public static void insertChunk(Chunk chunk, InputStream inputStream, OutputStream outputStream) throws IOException {
        PNGMeta.insertChunks(inputStream, outputStream, chunk);
    }

    public static void insertChunks(InputStream inputStream, OutputStream outputStream, Chunk ... chunkArray) throws IOException {
        List<Chunk> list = PNGMeta.readChunks(inputStream);
        Collections.addAll(list, chunkArray);
        IOUtils.writeLongMM(outputStream, -8552249625308161526L);
        PNGMeta.serializeChunks(list, outputStream);
    }

    public static void insertChunks(List<Chunk> list, InputStream inputStream, OutputStream outputStream) throws IOException {
        List<Chunk> list2 = PNGMeta.readChunks(inputStream);
        list2.addAll(list);
        IOUtils.writeLongMM(outputStream, -8552249625308161526L);
        PNGMeta.serializeChunks(list2, outputStream);
    }

    public static void insertComments(InputStream inputStream, OutputStream outputStream, List<String> list) throws IOException {
        TextBuilder textBuilder = new TextBuilder(ChunkType.TEXT);
        int n = list.size();
        Chunk[] chunkArray = new Chunk[n];
        for (int i = 0; i < n; ++i) {
            chunkArray[i] = textBuilder.keyword("Comment").text(list.get(i)).build();
        }
        PNGMeta.insertChunks(inputStream, outputStream, chunkArray);
    }

    public static void insertICCProfile(String string, byte[] byArray, InputStream inputStream, OutputStream outputStream) throws IOException {
        ICCPBuilder iCCPBuilder = new ICCPBuilder();
        iCCPBuilder.name(string);
        iCCPBuilder.data(byArray);
        PNGMeta.insertChunk(iCCPBuilder.build(), inputStream, outputStream);
    }

    public static void insertICCProfile(String string, ICC_Profile iCC_Profile, InputStream inputStream, OutputStream outputStream) throws IOException {
        PNGMeta.insertICCProfile(string, iCC_Profile.getData(), inputStream, outputStream);
    }

    public static void insertTextChunk(ChunkType chunkType, String string, String string2, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (chunkType == null || string == null || string2 == null) {
            throw new IllegalArgumentException("Argument(s) are null");
        }
        PNGMeta.insertChunk(new TextBuilder(chunkType).keyword(string).text(string2).build(), inputStream, outputStream);
    }

    public static void insertTextChunks(TextualChunks textualChunks, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (textualChunks == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        PNGMeta.insertChunks(textualChunks.getChunks(), inputStream, outputStream);
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, XMP xMP) throws IOException {
        PNGMeta.insert(inputStream, outputStream, XMLUtils.serializeToString(xMP.getMergedDocument()));
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        Document document = XMLUtils.createXML(string);
        XMLUtils.insertLeadingPI(document, "xpacket", "begin='' id='W5M0MpCehiHzreSzNTczkc9d'");
        XMLUtils.insertTrailingPI(document, "xpacket", "end='r'");
        String string2 = XMLUtils.serializeToString(document);
        PNGMeta.insert(inputStream, outputStream, string2);
    }

    private static void insert(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        Chunk chunk;
        List<Chunk> list = PNGMeta.readChunks(inputStream);
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            chunk = listIterator.next();
            if (chunk.getChunkType() != ChunkType.ITXT) continue;
            TextReader textReader = new TextReader(chunk);
            if (textReader.getKeyword().equals("XML:com.adobe.xmp")) {
                // empty if block
            }
            listIterator.remove();
        }
        chunk = new TextBuilder(ChunkType.ITXT).keyword("XML:com.adobe.xmp").text(string).build();
        list.add(chunk);
        IOUtils.writeLongMM(outputStream, -8552249625308161526L);
        PNGMeta.serializeChunks(list, outputStream);
    }

    public static List<Chunk> readChunks(InputStream inputStream) throws IOException {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        long l = IOUtils.readLongMM(inputStream);
        if (l != -8552249625308161526L) {
            throw new RuntimeException("Invalid PNG signature");
        }
        if (IOUtils.readIntMM(inputStream) != 13 || IOUtils.readIntMM(inputStream) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("Invalid PNG header");
        }
        byArray = new byte[13];
        IOUtils.readFully(inputStream, byArray, 0, 13);
        arrayList.add(new Chunk(ChunkType.IHDR, 13L, byArray, IOUtils.readUnsignedIntMM(inputStream)));
        while (true) {
            n = IOUtils.readIntMM(inputStream);
            n2 = IOUtils.readIntMM(inputStream);
            if (n2 == ChunkType.IEND.getValue()) break;
            ChunkType chunkType = ChunkType.fromInt(n2);
            byArray = new byte[n];
            IOUtils.readFully(inputStream, byArray, 0, n);
            if (chunkType == ChunkType.UNKNOWN) {
                arrayList.add(new UnknownChunk(n, n2, byArray, IOUtils.readUnsignedIntMM(inputStream)));
                continue;
            }
            arrayList.add(new Chunk(chunkType, n, byArray, IOUtils.readUnsignedIntMM(inputStream)));
        }
        arrayList.add(new Chunk(ChunkType.IEND, n, new byte[0], IOUtils.readUnsignedIntMM(inputStream)));
        return arrayList;
    }

    private static byte[] readICCProfile(byte[] byArray) throws IOException {
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        String string = new String(byArray, 0, n, "UTF-8");
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, n + 2, byArray.length - n - 2));
        LOGGER.info("ICCProfile name: {}", (Object)string);
        byte[] byArray2 = IOUtils.readFully((InputStream)inflaterInputStream, 4096);
        LOGGER.info("ICCProfile length: {}", (Object)byArray2.length);
        return byArray2;
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        Object object;
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        List<Chunk> list = PNGMeta.readChunks(inputStream);
        Iterator<Chunk> iterator = list.iterator();
        TextualChunks textualChunks = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            ChunkType chunkType = ((Chunk)object).getChunkType();
            long l = ((Chunk)object).getLength();
            if (chunkType == ChunkType.ICCP) {
                hashMap.put(MetadataType.ICC_PROFILE, new ICCProfile(PNGMeta.readICCProfile(((Chunk)object).getData())));
            } else if (chunkType == ChunkType.TEXT || chunkType == ChunkType.ITXT || chunkType == ChunkType.ZTXT) {
                if (textualChunks == null) {
                    textualChunks = new TextualChunks();
                }
                textualChunks.addChunk((Chunk)object);
            } else if (chunkType == ChunkType.TIME) {
                hashMap.put(MetadataType.PNG_TIME, new TIMEChunk((Chunk)object));
            }
            LOGGER.info("{} ({}) | {} bytes | 0x{} (CRC)", new Object[]{chunkType.getName(), chunkType.getAttribute(), l, Long.toHexString(((Chunk)object).getCRC())});
        }
        if (textualChunks != null) {
            hashMap.put(MetadataType.PNG_TEXTUAL, textualChunks);
            object = textualChunks.getKeyValMap();
            for (Map.Entry entry : object.entrySet()) {
                if (!((String)entry.getKey()).equals("XML:com.adobe.xmp")) continue;
                hashMap.put(MetadataType.XMP, new PngXMP((String)entry.getValue()));
            }
        }
        inputStream.close();
        return hashMap;
    }

    public static List<Chunk> removeChunks(List<Chunk> list, ChunkType chunkType) {
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Chunk chunk = (Chunk)listIterator.next();
            if (chunk.getChunkType() != chunkType) continue;
            listIterator.remove();
        }
        return list;
    }

    public static List<Chunk> removeChunks(List<Chunk> list, Set<ChunkType> set) {
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Chunk chunk = (Chunk)listIterator.next();
            if (!set.contains((Object)chunk.getChunkType())) continue;
            listIterator.remove();
        }
        return list;
    }

    public static void serializeChunks(List<Chunk> list, OutputStream outputStream) throws IOException {
        Collections.sort(list);
        for (Chunk chunk : list) {
            chunk.write(outputStream);
        }
    }

    private PNGMeta() {
    }
}

