/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pixy.image.jpeg.Marker;
import pixy.io.IOUtils;
import pixy.meta.xmp.XMP;
import pixy.string.StringUtils;
import pixy.string.XMLUtils;
import pixy.util.ArrayUtils;

public class JpegXMP
extends XMP {
    private static final int MAX_EXTENDED_XMP_CHUNK_SIZE = 65458;
    private static final int MAX_XMP_CHUNK_SIZE = 65504;
    private static final int GUID_LEN = 32;

    public JpegXMP(byte[] byArray) {
        super(byArray);
    }

    public JpegXMP(String string) {
        super(string);
    }

    public JpegXMP(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        int n;
        Object object;
        Document document = this.getXmpDocument();
        XMLUtils.insertLeadingPI(document, "xpacket", "begin='' id='W5M0MpCehiHzreSzNTczkc9d'");
        XMLUtils.insertTrailingPI(document, "xpacket", "end='r'");
        byte[] byArray = this.getExtendedXmpData();
        String string = null;
        if (byArray != null) {
            string = StringUtils.generateMD5(byArray);
            object = document.getElementsByTagName("rdf:Description");
            n = object.getLength();
            if (n > 0) {
                Element element = (Element)object.item(n - 1);
                element.setAttribute("xmlns:xmpNote", "http://ns.adobe.com/xmp/extension/");
                element.setAttribute("xmpNote:HasExtendedXMP", string);
            }
        }
        if (((byte[])(object = XMLUtils.serializeToByteArray(document))).length > 65504) {
            throw new RuntimeException("XMP data size exceededs JPEG segment size");
        }
        IOUtils.writeShortMM(outputStream, Marker.APP1.getValue());
        IOUtils.writeShortMM(outputStream, "http://ns.adobe.com/xap/1.0/\u0000".length() + 2 + ((Object)object).length);
        outputStream.write("http://ns.adobe.com/xap/1.0/\u0000".getBytes());
        outputStream.write((byte[])object);
        if (byArray != null) {
            int n2;
            n = byArray.length / 65458;
            int n3 = byArray.length;
            int n4 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                IOUtils.writeShortMM(outputStream, Marker.APP1.getValue());
                IOUtils.writeShortMM(outputStream, 2 + "http://ns.adobe.com/xmp/extension/\u0000".length() + 32 + 4 + 4 + 65458);
                outputStream.write("http://ns.adobe.com/xmp/extension/\u0000".getBytes());
                outputStream.write(string.getBytes());
                IOUtils.writeIntMM(outputStream, n3);
                IOUtils.writeIntMM(outputStream, n4);
                outputStream.write(ArrayUtils.subArray(byArray, n4, 65458));
                n4 += 65458;
            }
            n2 = byArray.length % 65458;
            if (n2 != 0) {
                IOUtils.writeShortMM(outputStream, Marker.APP1.getValue());
                IOUtils.writeShortMM(outputStream, 2 + "http://ns.adobe.com/xmp/extension/\u0000".length() + 32 + 4 + 4 + n2);
                outputStream.write("http://ns.adobe.com/xmp/extension/\u0000".getBytes());
                outputStream.write(string.getBytes());
                IOUtils.writeIntMM(outputStream, n3);
                IOUtils.writeIntMM(outputStream, n4);
                outputStream.write(ArrayUtils.subArray(byArray, n4, n2));
            }
        }
    }
}

