/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.IOUtils;
import pixy.meta.MetadataEntry;
import pixy.meta.jpeg.DuckyTag;
import pixy.util.ArrayUtils;

public class DuckyDataSet {
    private int tag;
    private int size;
    private byte[] data;
    private int offset;
    private static final Logger LOGGER = LoggerFactory.getLogger(DuckyDataSet.class);

    public DuckyDataSet(int n, byte[] byArray) {
        this(n, byArray.length, byArray, 0);
    }

    public DuckyDataSet(int n, int n2, byte[] byArray, int n3) {
        this.tag = n;
        this.size = n2;
        this.data = byArray;
        this.offset = n3;
    }

    public byte[] getData() {
        return ArrayUtils.subArray(this.data, this.offset, this.size);
    }

    public MetadataEntry getMetadataEntry() {
        MetadataEntry metadataEntry = null;
        if (this.size < 4) {
            LOGGER.warn("Data set size {} is too small, should >= 4", (Object)this.size);
            return new MetadataEntry("Bad Ducky DataSet", "Data set size " + this.size + " is two small, should >= 4");
        }
        DuckyTag duckyTag = DuckyTag.fromTag(this.tag);
        if (duckyTag == DuckyTag.UNKNOWN) {
            metadataEntry = new MetadataEntry("Unknown tag", "" + this.tag);
        } else if (duckyTag == DuckyTag.QUALITY) {
            metadataEntry = new MetadataEntry(duckyTag.getName(), "" + IOUtils.readUnsignedIntMM(this.data, this.offset));
        } else {
            String string = "";
            try {
                string = new String(this.data, this.offset + 4, this.size - 4, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error("UnsupportedEncoding \"UTF-16BE\"");
            }
            metadataEntry = new MetadataEntry(duckyTag.getName(), string);
        }
        return metadataEntry;
    }

    public int getSize() {
        return this.size;
    }

    public int getTag() {
        return this.tag;
    }

    public void print() {
        if (this.size < 4) {
            LOGGER.warn("Data set size {} is too small, should >= 4", (Object)this.size);
            return;
        }
        DuckyTag duckyTag = DuckyTag.fromTag(this.tag);
        if (duckyTag == DuckyTag.UNKNOWN) {
            LOGGER.info("Unknown tag: {}", (Object)this.tag);
        } else if (duckyTag == DuckyTag.QUALITY) {
            LOGGER.info(duckyTag + ": {}", (Object)IOUtils.readUnsignedIntMM(this.data, this.offset));
        } else {
            String string = "";
            try {
                string = new String(this.data, this.offset + 4, this.size - 4, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error("UnsupportedEncoding \"UTF-16BE\"");
            }
            LOGGER.info(duckyTag + ": {}", (Object)string);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        IOUtils.writeShortMM(outputStream, this.tag);
        IOUtils.writeShortMM(outputStream, this.size);
        outputStream.write(this.data, this.offset, this.size);
    }
}

