/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import pixy.io.IOUtils;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.string.StringUtils;

public class Adobe
extends Metadata {
    private int m_DCTEncodeVersion;
    private int m_APP14Flags0;
    private int m_APP14Flags1;
    private int m_ColorTransform;

    public Adobe(byte[] byArray) {
        super(MetadataType.JPG_ADOBE, byArray);
        this.ensureDataRead();
    }

    public Adobe(int n, int n2, int n3, int n4) {
        super(MetadataType.JPG_ADOBE);
        this.m_DCTEncodeVersion = n;
        this.m_APP14Flags0 = n2;
        this.m_APP14Flags1 = n3;
        this.m_ColorTransform = n4;
        this.isDataRead = true;
    }

    public int getAPP14Flags0() {
        return this.m_APP14Flags0;
    }

    public int getAPP14Flags1() {
        return this.m_APP14Flags1;
    }

    public int getColorTransform() {
        return this.m_ColorTransform;
    }

    public int getDCTEncodeVersion() {
        return this.m_DCTEncodeVersion;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 7;
            int n2 = 0;
            if (this.data.length >= n) {
                this.m_DCTEncodeVersion = IOUtils.readUnsignedShortMM(this.data, n2);
                this.m_APP14Flags0 = IOUtils.readUnsignedShortMM(this.data, n2 += 2);
                this.m_APP14Flags1 = IOUtils.readUnsignedShortMM(this.data, n2 += 2);
                this.m_ColorTransform = this.data[n2 += 2] & 0xFF;
            }
            this.isDataRead = true;
        }
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        String[] stringArray = new String[]{"Unknown (RGB or CMYK)", "YCbCr", "YCCK"};
        arrayList.add(new MetadataEntry("DCTEncodeVersion", "" + this.m_DCTEncodeVersion));
        arrayList.add(new MetadataEntry("APP14Flags0", StringUtils.shortToHexStringMM((short)this.m_APP14Flags0)));
        arrayList.add(new MetadataEntry("APP14Flags1", StringUtils.shortToHexStringMM((short)this.m_APP14Flags1)));
        arrayList.add(new MetadataEntry("ColorTransform", (String)(this.m_ColorTransform <= 2 ? stringArray[this.m_ColorTransform] : "" + this.m_ColorTransform)));
        return Collections.unmodifiableCollection(arrayList).iterator();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.ensureDataRead();
        IOUtils.writeShortMM(outputStream, this.getDCTEncodeVersion());
        IOUtils.writeShortMM(outputStream, this.getAPP14Flags0());
        IOUtils.writeShortMM(outputStream, this.getAPP14Flags1());
        IOUtils.write(outputStream, this.getColorTransform());
    }
}

