/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.iptc;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import pixy.meta.iptc.IPTCRecord;
import pixy.meta.iptc.IPTCTag;
import pixy.string.StringUtils;

public enum IPTCPreObjectDataTag implements IPTCTag
{
    SIZE_MODE(10, "SizeMode"),
    MAX_SUBFILE_SIZE(20, "MaxSubfileSize"),
    OBJECT_SIZE_ANNOUNCED(90, "ObjectSizeAnnounced"),
    MAXIMUM_OBJECT_SIZE(95, "MaximumObjectSize"),
    UNKNOWN(999, "Unknown");

    private static final Map<Integer, IPTCPreObjectDataTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCPreObjectDataTag(int n2, String string2) {
        this.tag = n2;
        this.name = string2;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8").trim();
            if (string.length() > 0) {
                return string;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(byArray, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRecordNumber() {
        return IPTCRecord.PRE_OBJECTDATA.getRecordNumber();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public static IPTCPreObjectDataTag fromTag(int n) {
        IPTCPreObjectDataTag iPTCPreObjectDataTag = recordMap.get(n);
        if (iPTCPreObjectDataTag == null) {
            return UNKNOWN;
        }
        return iPTCPreObjectDataTag;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCPreObjectDataTag>();
        for (IPTCPreObjectDataTag iPTCPreObjectDataTag : IPTCPreObjectDataTag.values()) {
            recordMap.put(iPTCPreObjectDataTag.getTag(), iPTCPreObjectDataTag);
        }
    }
}

