/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.iptc;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import pixy.meta.iptc.IPTCRecord;
import pixy.meta.iptc.IPTCTag;
import pixy.string.StringUtils;

public enum IPTCNewsPhotoTag implements IPTCTag
{
    RECORD_VERSION(0, "NewsPhotoVersion"),
    PICTURE_NUMBER(10, "PictureNumber"),
    IMAGE_WIDTH(20, "ImageWidth"),
    IMAGE_HEIGHT(30, "ImageHeight"),
    PIXEL_WIDTH(40, "PixelWidth"),
    PIXEL_HEIGHT(50, "PixelHeight"),
    SUPPLEMENTAL_TYPE(55, "SupplementalType"),
    COLOR_REPRESENTATION(60, "ColorRepresentation"),
    INTERCHANGE_COLOR_SPACE(64, "InterchangeColorSpace"),
    COLOR_SEQUENCE(65, "ColorSequence"),
    ICC_PROFILE(66, "ICC_Profile"),
    COLOR_CALIBRATION_MATRIX(70, "ColorCalibrationMatrix"),
    LOOKUP_TABLE(80, "LookupTable"),
    NUM_INDEX_ENTRIES(84, "NumIndexEntries"),
    COLOR_PALETTE(85, "ColorPalette"),
    BITS_PER_SAMPLE(86, "BitsPerSample"),
    SAMPLE_STRUCTURE(90, "SampleStructure"),
    SCANNING_DIRECTION(100, "ScanningDirection"),
    IMAGE_ROTATION(102, "ImageRotation"),
    DATA_COMPRESSION_METHOD(110, "DataCompressionMethod"),
    QUANTIZATION_METHOD(120, "QuantizationMethod"),
    END_POINTS(125, "EndPoints"),
    EXCURSION_TOLERANCE(130, "ExcursionTolerance"),
    BITS_PER_COMPONENT(135, "BitsPerComponent"),
    MAXIMUM_DENSITY_RANGE(140, "MaximumDensityRange"),
    GAMMA_COMPENSATED_VALUE(145, "GammaCompensatedValue"),
    UNKNOWN(999, "Unknown");

    private static final Map<Integer, IPTCNewsPhotoTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCNewsPhotoTag(int n2, String string2) {
        this.tag = n2;
        this.name = string2;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8").trim();
            if (string.length() > 0) {
                return string;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(byArray, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRecordNumber() {
        return IPTCRecord.NEWSPHOTO.getRecordNumber();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public static IPTCNewsPhotoTag fromTag(int n) {
        IPTCNewsPhotoTag iPTCNewsPhotoTag = recordMap.get(n);
        if (iPTCNewsPhotoTag == null) {
            return UNKNOWN;
        }
        return iPTCNewsPhotoTag;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCNewsPhotoTag>();
        for (IPTCNewsPhotoTag iPTCNewsPhotoTag : IPTCNewsPhotoTag.values()) {
            recordMap.put(iPTCNewsPhotoTag.getTag(), iPTCNewsPhotoTag);
        }
    }
}

