/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.image;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;

public class Comments
extends Metadata {
    private Queue<byte[]> queue = new LinkedList<byte[]>();
    private List<String> comments;

    public Comments() {
        super(MetadataType.COMMENT);
        this.comments = new ArrayList<String>();
    }

    public Comments(List<String> list) {
        super(MetadataType.COMMENT);
        if (list == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.comments = list;
    }

    public List<String> getComments() {
        this.ensureDataRead();
        return Collections.unmodifiableList(this.comments);
    }

    public void addComment(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.queue.offer(byArray);
    }

    public void addComment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input is null");
        }
        this.comments.add(string);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        for (String string : this.comments) {
            arrayList.add(new MetadataEntry(string, ""));
        }
        return Collections.unmodifiableCollection(arrayList).iterator();
    }

    @Override
    public void read() throws IOException {
        if (this.queue.size() > 0) {
            for (byte[] byArray : this.queue) {
                try {
                    this.comments.add(new String(byArray, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new UnsupportedEncodingException("UTF-8");
                }
            }
            this.queue.clear();
        }
    }
}

