/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.icc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.IOUtils;
import pixy.meta.icc.ProfileTag;

public class ProfileTagTable {
    private int tagCount;
    private Map<Integer, TagEntry> tagEntries = new HashMap<Integer, TagEntry>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileTagTable.class);

    public void addTagEntry(TagEntry tagEntry) {
        this.tagEntries.put(tagEntry.getProfileTag(), tagEntry);
    }

    public void read(byte[] byArray) {
        int n = 128;
        this.tagCount = IOUtils.readIntMM(byArray, n);
        n += 4;
        for (int i = 0; i < this.tagCount; ++i) {
            int n2 = IOUtils.readIntMM(byArray, n);
            ProfileTag profileTag = ProfileTag.fromInt(n2);
            int n3 = IOUtils.readIntMM(byArray, n += 4);
            int n4 = IOUtils.readIntMM(byArray, n += 4);
            n += 4;
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            this.tagEntries.put(n2, new TagEntry(profileTag.getValue(), n3, n4, byArray2));
        }
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public TagEntry getTagEntry(ProfileTag profileTag) {
        return this.tagEntries.get(profileTag.getValue());
    }

    public List<TagEntry> getTagEntries() {
        return new ArrayList<TagEntry>(this.tagEntries.values());
    }

    public void showTable() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*** Start of ICC_Profile Tag Table ***\n");
        stringBuilder.append("Tag Count: " + this.tagCount + "\n");
        List<TagEntry> list = this.getTagEntries();
        Collections.sort(list);
        int n = 0;
        for (TagEntry tagEntry : list) {
            stringBuilder.append("Tag# " + n++);
            stringBuilder.append(", Tag Name: " + ProfileTag.fromInt(tagEntry.getProfileTag()));
            stringBuilder.append(", Data Offset: " + tagEntry.getDataOffset());
            stringBuilder.append(", Data Length: " + tagEntry.getDataLength() + "\n");
        }
        stringBuilder.append("*** End of ICC_Profile Tag Table ***\n");
        LOGGER.info("\n{}", (Object)stringBuilder);
    }

    public static class TagEntry
    implements Comparable<TagEntry> {
        private int profileTag;
        private int dataOffset;
        private int dataLength;
        private byte[] data;

        public TagEntry(int n, int n2, int n3, byte[] byArray) {
            this.profileTag = n;
            this.dataOffset = n2;
            this.dataLength = n3;
            this.data = byArray;
        }

        @Override
        public int compareTo(TagEntry tagEntry) {
            return (int)(((long)this.profileTag & 0xFFFFFFFFL) - ((long)tagEntry.profileTag & 0xFFFFFFFFL));
        }

        public int getProfileTag() {
            return this.profileTag;
        }

        public int getDataOffset() {
            return this.dataOffset;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

