/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.exif;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.Tag;
import pixy.image.tiff.TiffTag;
import pixy.string.StringUtils;

public enum ExifTag implements Tag
{
    EXPOSURE_TIME("ExposureTime", -32102),
    FNUMBER("FNumber", -32099){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of EXIF FNumber data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.#");
            return "F" + StringUtils.rationalToString(decimalFormat, true, nArray);
        }
    }
    ,
    EXPOSURE_PROGRAM("ExposureProgram", -30686),
    SPECTRAL_SENSITIVITY("SpectralSensitivity", -30684),
    ISO_SPEED_RATINGS("ISOSpeedRatings", -30681),
    OECF("OECF", -30680),
    EXIF_VERSION("ExifVersion", -28672){

        @Override
        public String getFieldAsString(Object object) {
            return new String((byte[])object).trim();
        }
    }
    ,
    DATE_TIME_ORIGINAL("DateTimeOriginal", -28669),
    DATE_TIME_DIGITIZED("DateTimeDigitized", -28668),
    COMPONENT_CONFIGURATION("ComponentConfiguration", -28415),
    COMPRESSED_BITS_PER_PIXEL("CompressedBitsPerPixel", -28414),
    SHUTTER_SPEED_VALUE("ShutterSpeedValue", -28159){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of EXIF ShutterSpeedValue data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, false, nArray);
        }
    }
    ,
    APERTURE_VALUE("ApertureValue", -28158),
    BRIGHTNESS_VALUE("BrightValue", -28157),
    EXPOSURE_BIAS_VALUE("ExposureBiasValue", -28156),
    MAX_APERTURE_VALUE("MaxApertureValue", -28155),
    SUBJECT_DISTANCE("SubjectDistance", -28154),
    METERING_MODE("MeteringMode", -28153),
    LIGHT_SOURCE("LightSource", -28152),
    FLASH("Flash", -28151),
    FOCAL_LENGTH("FocalLength", -28150){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of EXIF FocalLength data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "mm";
        }
    }
    ,
    SUBJECT_AREA("SubjectArea", -28140),
    MAKER_NODE("MakerNote", -28036),
    USER_COMMENT("UserComment", -28026),
    SUB_SEC_TIME("SubSecTime", -28016),
    SUB_SEC_TIME_ORIGINAL("SubSecTimeOriginal", -28015),
    SUB_SEC_TIME_DIGITIZED("SubSecTimeDigitized", -28014),
    WINDOWS_XP_TITLE("WindowsXP Title", -25445){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_COMMENT("WindowsXP Comment", -25444){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_AUTHOR("WindowsXP Author", -25443){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_KEYWORDS("WindowsXP Keywords", -25442){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_SUBJECT("WindowsXP Subject", -25441){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    FLASH_PIX_VERSION("FlashPixVersion", -24576){

        @Override
        public String getFieldAsString(Object object) {
            return new String((byte[])object).trim();
        }
    }
    ,
    COLOR_SPACE("ColorSpace", -24575){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            Object object2 = "Warning: unknown color space value: " + n;
            switch (n) {
                case 1: {
                    object2 = "sRGB";
                    break;
                }
                case 65535: {
                    object2 = "Uncalibrated";
                }
            }
            return object2;
        }
    }
    ,
    EXIF_IMAGE_WIDTH("ExifImageWidth", -24574),
    EXIF_IMAGE_HEIGHT("ExifImageHeight", -24573),
    RELATED_SOUND_FILE("RelatedSoundFile", -24572),
    EXIF_INTEROPERABILITY_OFFSET("ExifInteroperabilityOffset", -24571){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    FLASH_ENERGY("FlashEnergy", -24053),
    SPATIAL_FREQUENCY_RESPONSE("SpatialFrequencyResponse", -24052),
    FOCAL_PLANE_X_RESOLUTION("FocalPlanXResolution", -24050),
    FOCAL_PLANE_Y_RESOLUTION("FocalPlanYResolution", -24049),
    FOCAL_PLANE_RESOLUTION_UNIT("FocalPlanResolutionUnit", -24048),
    SUBJECT_LOCATION("SubjectLocation", -24044),
    EXPOSURE_INDEX("ExposureIndex", -24043),
    SENSING_METHOD("SensingMethod", -24041),
    FILE_SOURCE("FileSource", -23808),
    SCENE_TYPE("SceneType", -23807),
    CFA_PATTERN("CFAPattern", -23806),
    CUSTOM_RENDERED("CustomRendered", -23551),
    EXPOSURE_MODE("ExposureMode", -23550),
    WHITE_BALENCE("WhileBalence", -23549),
    DIGITAL_ZOOM_RATIO("DigitalZoomRatio", -23548),
    FOCAL_LENGTH_IN_35MM_FORMAT("FocalLengthIn35mmFormat", -23547),
    SCENE_CAPTURE_TYPE("SceneCaptureType", -23546),
    GAIN_CONTROL("GainControl", -23545),
    CONTRAST("Contrast", -23544),
    SATURATION("Saturation", -23543),
    SHARPNESS("Sharpness", -23542),
    DEVICE_SETTING_DESCRIPTION("DeviceSettingDescription", -23541),
    SUBJECT_DISTANCE_RANGE("SubjectDistanceRange", -23540),
    IMAGE_UNIQUE_ID("ImageUniqueID", -23520),
    OWNER_NAME("OwnerName", -23504),
    BODY_SERIAL_NUMBER("BodySerialNumber", -23503),
    LENS_SPECIFICATION("LensSpecification", -23502),
    LENS_Make("LensMake", -23501),
    LENS_MODEL("LensModel", -23500),
    LENS_SERIAL_NUMBER("LensSerialNumber", -23499),
    EXPAND_SOFTWARE("ExpandSoftware", -20544),
    EXPAND_LENS("ExpandLens", -20543),
    EXPAND_FILM("ExpandFilm", -20542),
    EXPAND_FILTER_LENS("ExpandFilterLens", -20541),
    EXPAND_SCANNER("ExpandScanner", -20540),
    EXPAND_FLASH_LAMP("ExpandFlashLamp", -20539),
    PADDING("Padding", -5604),
    UNKNOWN("Unknown", -1);

    private static final Map<Short, ExifTag> tagMap;
    private final String name;
    private final short value;

    private ExifTag(String string2, short s) {
        this.name = string2;
        this.value = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name;
        }
        return this.name + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "]";
    }

    public static Tag fromShort(short s) {
        ExifTag exifTag = tagMap.get(s);
        if (exifTag == null) {
            return TiffTag.UNKNOWN;
        }
        return exifTag;
    }

    @Override
    public String getFieldAsString(Object object) {
        return "";
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNKNOWN;
    }

    static {
        tagMap = new HashMap<Short, ExifTag>();
        for (ExifTag exifTag : ExifTag.values()) {
            tagMap.put(exifTag.getValue(), exifTag);
        }
    }
}

