/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.exif;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.IFD;
import pixy.image.tiff.Tag;
import pixy.image.tiff.TiffField;
import pixy.image.tiff.TiffTag;
import pixy.io.FileCacheRandomAccessInputStream;
import pixy.io.FileCacheRandomAccessOutputStream;
import pixy.io.IOUtils;
import pixy.io.RandomAccessInputStream;
import pixy.io.RandomAccessOutputStream;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.meta.exif.ExifTag;
import pixy.meta.exif.ExifThumbnail;
import pixy.meta.exif.GPSTag;
import pixy.meta.tiff.TIFFMeta;
import pixy.string.StringUtils;

public abstract class Exif
extends Metadata {
    protected IFD imageIFD;
    protected IFD exifSubIFD;
    protected IFD gpsSubIFD;
    protected ExifThumbnail thumbnail;
    private boolean containsThumbnail;
    private boolean isThumbnailRequired;
    public static final int FIRST_IFD_OFFSET = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(Exif.class);

    public Exif() {
        super(MetadataType.EXIF);
        this.isDataRead = true;
    }

    public Exif(byte[] byArray) {
        super(MetadataType.EXIF, byArray);
        this.ensureDataRead();
    }

    public Exif(IFD iFD) {
        this();
        this.setImageIFD(iFD);
    }

    public Exif(InputStream inputStream) throws IOException {
        this(IOUtils.inputStreamToByteArray(inputStream));
    }

    public void addExifField(ExifTag exifTag, FieldType fieldType, Object object) {
        TiffField<?> tiffField;
        if (this.exifSubIFD == null) {
            this.exifSubIFD = new IFD();
        }
        if ((tiffField = FieldType.createField(exifTag, fieldType, object)) == null) {
            throw new IllegalArgumentException("Cannot create required EXIF TIFF field");
        }
        this.exifSubIFD.addField(tiffField);
    }

    public void addGPSField(GPSTag gPSTag, FieldType fieldType, Object object) {
        TiffField<?> tiffField;
        if (this.gpsSubIFD == null) {
            this.gpsSubIFD = new IFD();
        }
        if ((tiffField = FieldType.createField(gPSTag, fieldType, object)) == null) {
            throw new IllegalArgumentException("Cannot create required GPS TIFF field");
        }
        this.gpsSubIFD.addField(tiffField);
    }

    public void addImageField(TiffTag tiffTag, FieldType fieldType, Object object) {
        TiffField<?> tiffField;
        if (this.imageIFD == null) {
            this.imageIFD = new IFD();
        }
        if ((tiffField = FieldType.createField(tiffTag, fieldType, object)) == null) {
            throw new IllegalArgumentException("Cannot create required Image TIFF field");
        }
        this.imageIFD.addField(tiffField);
    }

    public boolean containsThumbnail() {
        if (this.containsThumbnail) {
            return true;
        }
        return this.thumbnail != null;
    }

    public IFD getExifIFD() {
        if (this.exifSubIFD != null) {
            return new IFD(this.exifSubIFD);
        }
        return null;
    }

    public IFD getGPSIFD() {
        if (this.gpsSubIFD != null) {
            return new IFD(this.gpsSubIFD);
        }
        return null;
    }

    public IFD getImageIFD() {
        if (this.imageIFD != null) {
            return new IFD(this.imageIFD);
        }
        return null;
    }

    private void getMetadataEntries(IFD iFD, Class<? extends Tag> clazz, List<MetadataEntry> list) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Method 'fromShort' is not defined for class " + clazz);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("The operation is not allowed by the current security setup");
        }
        Collection<TiffField<?>> collection = iFD.getFields();
        MetadataEntry metadataEntry = null;
        metadataEntry = clazz.equals(TiffTag.class) ? new MetadataEntry("IFD0", "Image Info", true) : (clazz.equals(ExifTag.class) ? new MetadataEntry("EXIF SubIFD", "EXIF Info", true) : (clazz.equals(GPSTag.class) ? new MetadataEntry("GPS SubIFD", "GPS Info", true) : new MetadataEntry("UNKNOWN", "UNKNOWN SubIFD", true)));
        for (TiffField<?> tiffField : collection) {
            short s = tiffField.getTag();
            Tag tag = TiffTag.UNKNOWN;
            if (s == ExifTag.PADDING.getValue()) {
                tag = ExifTag.PADDING;
            } else {
                try {
                    tag = (Tag)method.invoke(null, s);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Illegal access for method: " + method);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException("Illegal argument for method:  " + method);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException("Incorrect invocation target");
                }
            }
            if (tag == TiffTag.UNKNOWN) {
                LOGGER.warn("Tag: {} [Value: 0x{}] (Unknown)", (Object)tag, (Object)Integer.toHexString(s & 0xFFFF));
            }
            FieldType fieldType = tiffField.getType();
            String string = null;
            string = fieldType == FieldType.SHORT || fieldType == FieldType.SSHORT ? tag.getFieldAsString(tiffField.getDataAsLong()) : tag.getFieldAsString(tiffField.getData());
            if (StringUtils.isNullOrEmpty(string)) {
                metadataEntry.addEntry(new MetadataEntry(tag.getName(), tiffField.getDataAsString()));
                continue;
            }
            metadataEntry.addEntry(new MetadataEntry(tag.getName(), string));
        }
        list.add(metadataEntry);
        Map<Tag, IFD> map = iFD.getChildren();
        if (map.get(TiffTag.EXIF_SUB_IFD) != null) {
            this.getMetadataEntries((IFD)map.get(TiffTag.EXIF_SUB_IFD), ExifTag.class, list);
        }
        if (map.get(TiffTag.GPS_SUB_IFD) != null) {
            this.getMetadataEntries((IFD)map.get(TiffTag.GPS_SUB_IFD), GPSTag.class, list);
        }
    }

    public ExifThumbnail getThumbnail() {
        if (this.thumbnail != null) {
            return new ExifThumbnail(this.thumbnail);
        }
        return null;
    }

    public boolean isThumbnailRequired() {
        return this.isThumbnailRequired;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        if (this.imageIFD != null) {
            this.getMetadataEntries(this.imageIFD, TiffTag.class, arrayList);
        }
        if (this.containsThumbnail) {
            MetadataEntry metadataEntry = new MetadataEntry("IFD1", "Thumbnail Image", true);
            metadataEntry.addEntry(new MetadataEntry("Thumbnail format", this.thumbnail.getDataType() == 1 ? "DATA_TYPE_KJpegRGB" : "DATA_TYPE_TIFF"));
            metadataEntry.addEntry(new MetadataEntry("Thumbnail data length", "" + this.thumbnail.getCompressedImage().length));
            arrayList.add(metadataEntry);
        }
        return Collections.unmodifiableList(arrayList).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(new ByteArrayInputStream(this.data));
            ArrayList<IFD> arrayList = new ArrayList<IFD>(3);
            TIFFMeta.readIFDs(arrayList, fileCacheRandomAccessInputStream);
            if (arrayList.size() > 0) {
                this.imageIFD = (IFD)arrayList.get(0);
                this.exifSubIFD = this.imageIFD.getChild(TiffTag.EXIF_SUB_IFD);
                this.gpsSubIFD = this.imageIFD.getChild(TiffTag.GPS_SUB_IFD);
            }
            if (arrayList.size() >= 2) {
                IFD iFD = (IFD)arrayList.get(1);
                int n = -1;
                int n2 = -1;
                TiffField<?> tiffField = iFD.getField(TiffTag.IMAGE_WIDTH);
                if (tiffField != null) {
                    n = tiffField.getDataAsLong()[0];
                }
                if ((tiffField = iFD.getField(TiffTag.IMAGE_LENGTH)) != null) {
                    n2 = tiffField.getDataAsLong()[0];
                }
                if ((tiffField = iFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT)) != null) {
                    int n3 = tiffField.getDataAsLong()[0];
                    tiffField = iFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH);
                    int n4 = tiffField.getDataAsLong()[0];
                    ((RandomAccessInputStream)fileCacheRandomAccessInputStream).seek(n3);
                    byte[] byArray = new byte[n4];
                    fileCacheRandomAccessInputStream.readFully(byArray);
                    this.thumbnail = new ExifThumbnail(n, n2, 1, byArray, iFD);
                    this.containsThumbnail = true;
                } else {
                    tiffField = iFD.getField(TiffTag.STRIP_OFFSETS);
                    if (tiffField == null) {
                        tiffField = iFD.getField(TiffTag.TILE_OFFSETS);
                    }
                    if (tiffField != null) {
                        ((RandomAccessInputStream)fileCacheRandomAccessInputStream).seek(0L);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(byteArrayOutputStream);
                        TIFFMeta.retainPages(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, 1);
                        ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                        this.thumbnail = new ExifThumbnail(n, n2, 2, byteArrayOutputStream.toByteArray(), iFD);
                        this.containsThumbnail = true;
                    }
                }
            }
            ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
            this.isDataRead = true;
        }
    }

    public void setExifIFD(IFD iFD) {
        this.exifSubIFD = iFD;
    }

    public void setGPSIFD(IFD iFD) {
        this.gpsSubIFD = iFD;
    }

    public void setImageIFD(IFD iFD) {
        if (iFD == null) {
            throw new IllegalArgumentException("Input image IFD is null");
        }
        this.imageIFD = iFD;
        this.exifSubIFD = iFD.getChild(TiffTag.EXIF_SUB_IFD);
        this.gpsSubIFD = iFD.getChild(TiffTag.GPS_SUB_IFD);
    }

    public void setThumbnail(ExifThumbnail exifThumbnail) {
        this.thumbnail = exifThumbnail;
    }

    public void setThumbnailImage(BufferedImage bufferedImage) {
        if (this.thumbnail == null) {
            this.thumbnail = new ExifThumbnail();
        }
        this.thumbnail.setImage(bufferedImage);
    }

    public void setThumbnailRequired(boolean bl) {
        this.isThumbnailRequired = bl;
    }

    @Override
    public abstract void write(OutputStream var1) throws IOException;
}

