/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.ReadStrategy;
import pixy.meta.adobe.ColorSpaceID;
import pixy.meta.adobe.DDBEntry;
import pixy.meta.adobe.DataBlockType;

public class UserMask
extends DDBEntry {
    private int colorSpaceId;
    private int[] colors = new int[4];
    private int opacity;
    private int flag;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMask.class);

    public UserMask(int n, byte[] byArray, ReadStrategy readStrategy) {
        super(DataBlockType.LMsk, n, byArray, readStrategy);
        this.read();
    }

    public int[] getColors() {
        return (int[])this.colors.clone();
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getColorSpace() {
        return this.colorSpaceId;
    }

    public ColorSpaceID getColorSpaceID() {
        return ColorSpaceID.fromInt(this.colorSpaceId);
    }

    @Override
    public void print() {
        super.print();
        LOGGER.info("Color space: {}", (Object)this.getColorSpaceID());
        LOGGER.info("Color values: {}", (Object)Arrays.toString(this.colors));
        LOGGER.info("Opacity: {}", (Object)this.opacity);
        LOGGER.info("Flag: {}", (Object)this.flag);
    }

    private void read() {
        int n = 0;
        this.colorSpaceId = this.readStrategy.readShort(this.data, n);
        this.colors[0] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[1] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[2] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[3] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.opacity = this.readStrategy.readShort(this.data, n += 2);
        this.flag = this.data[n += 2] & 0xFF;
    }
}

