/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import pixy.io.IOUtils;
import pixy.meta.Thumbnail;
import pixy.meta.adobe.IRBThumbnail;
import pixy.meta.adobe.ImageResourceID;
import pixy.meta.adobe._8BIM;
import pixy.util.ArrayUtils;
import pixy.util.MetadataUtils;

public class ThumbnailResource
extends _8BIM {
    private int width;
    private int height;
    private int paddedRowBytes;
    private int totalSize;
    private int compressedSize;
    private int bitsPerPixel;
    private int numOfPlanes;
    private ImageResourceID id;
    private int dataType;
    private IRBThumbnail thumbnail = new IRBThumbnail();

    private static ImageResourceID validateID(ImageResourceID imageResourceID) {
        if (imageResourceID != ImageResourceID.THUMBNAIL_RESOURCE_PS4 && imageResourceID != ImageResourceID.THUMBNAIL_RESOURCE_PS5) {
            throw new IllegalArgumentException("Unsupported thumbnail ImageResourceID: " + imageResourceID);
        }
        return imageResourceID;
    }

    public ThumbnailResource(BufferedImage bufferedImage) {
        this("THUMBNAIL_RESOURCE", bufferedImage);
    }

    public ThumbnailResource(String string, BufferedImage bufferedImage) {
        super(ImageResourceID.THUMBNAIL_RESOURCE_PS5, string, null);
        try {
            this.thumbnail = this.createThumbnail(bufferedImage);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create IRBThumbnail from BufferedImage");
        }
    }

    public ThumbnailResource(ImageResourceID imageResourceID, int n, int n2, int n3, byte[] byArray) {
        super(ThumbnailResource.validateID(imageResourceID), "THUMBNAIL_RESOURCE", null);
        this.id = imageResourceID;
        this.dataType = n;
        this.width = n2 > 0 ? n2 : 0;
        this.height = n3 > 0 ? n3 : 0;
        this.paddedRowBytes = (n2 * 24 + 31) / 32 * 4;
        this.totalSize = this.paddedRowBytes * n3 * this.numOfPlanes;
        this.compressedSize = byArray.length;
        this.bitsPerPixel = 24;
        this.numOfPlanes = 1;
        this.setThumbnailImage(imageResourceID, n, n2, n3, this.totalSize, byArray);
    }

    public ThumbnailResource(ImageResourceID imageResourceID, byte[] byArray) {
        super(ThumbnailResource.validateID(imageResourceID), "THUMBNAIL_RESOURCE", byArray);
        this.id = imageResourceID;
        this.read();
    }

    public ThumbnailResource(ImageResourceID imageResourceID, Thumbnail thumbnail) {
        this(imageResourceID, thumbnail.getDataType(), thumbnail.getWidth(), thumbnail.getHeight(), thumbnail.getCompressedImage());
    }

    private IRBThumbnail createThumbnail(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetadataUtils.saveAsJPEG(bufferedImage, byteArrayOutputStream, 100);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.id = ImageResourceID.THUMBNAIL_RESOURCE_PS5;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.bitsPerPixel = 24;
        this.numOfPlanes = 1;
        this.paddedRowBytes = (this.width * this.bitsPerPixel + 31) / 32 * 4;
        this.totalSize = this.paddedRowBytes * this.height * this.numOfPlanes;
        this.compressedSize = byArray.length;
        this.dataType = 1;
        return new IRBThumbnail(this.width, this.height, this.dataType, byArray);
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumOfPlanes() {
        return this.numOfPlanes;
    }

    public int getPaddedRowBytes() {
        return this.paddedRowBytes;
    }

    public ImageResourceID getResouceID() {
        return this.id;
    }

    public IRBThumbnail getThumbnail() {
        return new IRBThumbnail(this.thumbnail);
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getWidth() {
        return this.width;
    }

    private void setThumbnailImage(ImageResourceID imageResourceID, int n, int n2, int n3, int n4, byte[] byArray) {
        if (n == 1) {
            this.thumbnail.setImage(n2, n3, n, byArray);
        } else if (n == 0) {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, n4);
            int[] nArray = new int[]{0, 1, 2};
            if (imageResourceID == ImageResourceID.THUMBNAIL_RESOURCE_PS4) {
                nArray = new int[]{2, 1, 0};
            }
            int n5 = 3;
            int n6 = 1;
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, this.paddedRowBytes, n5, nArray, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, n6, 0);
            this.thumbnail.setImage(new BufferedImage(componentColorModel, writableRaster, false, null));
        } else {
            throw new UnsupportedOperationException("Unsupported IRB thumbnail data type: " + n);
        }
    }

    private void read() {
        this.dataType = IOUtils.readIntMM(this.data, 0);
        this.width = IOUtils.readIntMM(this.data, 4);
        this.height = IOUtils.readIntMM(this.data, 8);
        this.paddedRowBytes = IOUtils.readIntMM(this.data, 12);
        this.totalSize = IOUtils.readIntMM(this.data, 16);
        this.compressedSize = IOUtils.readIntMM(this.data, 20);
        this.bitsPerPixel = IOUtils.readShortMM(this.data, 24);
        this.numOfPlanes = IOUtils.readShortMM(this.data, 26);
        byte[] byArray = null;
        if (this.dataType == 1) {
            byArray = ArrayUtils.subArray(this.data, 28, this.compressedSize);
        } else if (this.dataType == 0) {
            byArray = ArrayUtils.subArray(this.data, 28, this.totalSize);
        }
        this.setThumbnailImage(this.id, this.dataType, this.width, this.height, this.totalSize, byArray);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.data == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.thumbnail.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            IOUtils.writeIntMM(byteArrayOutputStream, this.dataType);
            IOUtils.writeIntMM(byteArrayOutputStream, this.width);
            IOUtils.writeIntMM(byteArrayOutputStream, this.height);
            IOUtils.writeIntMM(byteArrayOutputStream, this.paddedRowBytes);
            IOUtils.writeIntMM(byteArrayOutputStream, this.totalSize);
            IOUtils.writeIntMM(byteArrayOutputStream, byArray.length);
            IOUtils.writeShortMM(byteArrayOutputStream, this.bitsPerPixel);
            IOUtils.writeShortMM(byteArrayOutputStream, this.numOfPlanes);
            byteArrayOutputStream.write(byArray);
            this.data = byteArrayOutputStream.toByteArray();
            this.size = this.data.length;
        }
        super.write(outputStream);
    }
}

