/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.ReadStrategy;
import pixy.meta.adobe.Channel;
import pixy.meta.adobe.DDBEntry;
import pixy.meta.adobe.DataBlockType;

public class LayerData
extends DDBEntry {
    private int layerCount;
    private List<Channel> channels = new ArrayList<Channel>();
    private static final Logger LOGGER = LoggerFactory.getLogger(LayerData.class);

    public LayerData(int n, byte[] byArray, ReadStrategy readStrategy) {
        super(DataBlockType.Layr, n, byArray, readStrategy);
        this.read();
    }

    @Override
    public void print() {
        super.print();
        LOGGER.info("Number of layers: {}", (Object)this.layerCount);
    }

    private void read() {
        int n = 0;
        this.layerCount = this.readStrategy.readUnsignedShort(this.data, n);
        n += 2;
        for (int i = 0; i < this.layerCount; ++i) {
            int n2;
            int n3;
            int n4;
            int n5 = this.readStrategy.readInt(this.data, n);
            int n6 = this.readStrategy.readInt(this.data, n += 4);
            int n7 = this.readStrategy.readInt(this.data, n += 4);
            int n8 = this.readStrategy.readInt(this.data, n += 4);
            int n9 = this.readStrategy.readUnsignedShort(this.data, n += 4);
            n += 2;
            for (n4 = 0; n4 < n9; ++n4) {
                n3 = this.readStrategy.readShort(this.data, n);
                n2 = this.readStrategy.readInt(this.data, n += 2);
                n += 4;
                this.channels.add(new Channel(n3, n2));
            }
            n4 = this.readStrategy.readInt(this.data, n);
            n3 = this.readStrategy.readInt(this.data, n += 4);
            n += 4;
            n2 = this.data[n++] & 0xFF;
            int n10 = this.data[n++] & 0xFF;
            int n11 = this.data[n++] & 0xFF;
            int n12 = this.data[n++] & 0xFF;
            int n13 = this.readStrategy.readInt(this.data, n);
            n += 4;
            n += n13;
        }
    }
}

